/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.DelimiterState;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.RegisterName;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractManyRegisterVariableMsSymbol
extends AbstractMsSymbol {
    protected RecordNumber typeRecordNumber;
    protected int count;
    protected List<RegisterName> registerNameList = new ArrayList<RegisterName>();
    protected String name;

    public AbstractManyRegisterVariableMsSymbol(AbstractPdb pdb, PdbByteReader reader, int recordNumberSize, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.typeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, recordNumberSize);
        this.count = reader.parseUnsignedByteVal();
        for (int i = 0; i < this.count; ++i) {
            int registerIndex = reader.parseUnsignedByteVal();
            RegisterName registerName = new RegisterName(pdb, registerIndex);
            this.registerNameList.add(registerName);
        }
        this.name = reader.parseString(pdb, strType);
        reader.align4();
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: ", this.getSymbolTypeName()));
        DelimiterState ds = new DelimiterState("", ", ");
        for (RegisterName registerName : this.registerNameList) {
            builder.append(ds.out(true, registerName));
        }
        builder.append(String.format(" %s %s", this.pdb.getTypeRecord(this.typeRecordNumber), this.name));
    }
}

