/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.SymbolPathParser;
import ghidra.app.util.bin.format.pdb.PdbBitField;
import ghidra.app.util.bin.format.pdb.PdbDataTypeParser;
import ghidra.app.util.bin.format.pdb.PdbKind;
import ghidra.app.util.bin.format.pdb.PdbMember;
import ghidra.app.util.bin.format.pdb.WrappedDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class DefaultPdbMember
extends PdbMember {
    final PdbKind kind;
    private boolean isBitField;
    private int bitFieldSize = -1;
    private int bitFieldOffset = -1;
    private final PdbDataTypeParser dataTypeParser;

    DefaultPdbMember(String name, String dataTypeName, int offset, PdbKind kind, PdbDataTypeParser dataTypeParser) {
        super(DefaultPdbMember.getMemberName(name, kind), dataTypeName, offset, null);
        this.kind = kind;
        this.dataTypeParser = dataTypeParser;
        this.parseBitField(name);
    }

    public PdbKind getKind() {
        return this.kind;
    }

    @Override
    public String toString() {
        Object str = super.toString();
        if (this.isBitField) {
            str = (String)str + ", bitSize=" + this.bitFieldSize + ", bitOffset=" + this.bitFieldOffset;
        }
        return str;
    }

    private static String getMemberName(String name, PdbKind kind) {
        int bitFieldColonIndex;
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        if (kind == PdbKind.MEMBER && (bitFieldColonIndex = DefaultPdbMember.getBitfieldIndex(name)) >= 0) {
            return name.substring(0, bitFieldColonIndex);
        }
        List names = SymbolPathParser.parse((String)name);
        return (String)names.get(names.size() - 1);
    }

    @Override
    protected WrappedDataType getDataType() throws CancelledException {
        WrappedDataType wrappedDt = this.dataTypeParser.findDataType(this.getDataTypeName());
        if (wrappedDt != null && this.isBitField) {
            PdbBitField bitFieldDt;
            if (wrappedDt.isZeroLengthArray()) {
                return null;
            }
            try {
                DataType baseDataType = wrappedDt.getDataType().clone(this.dataTypeParser.getProgramDataTypeManager());
                bitFieldDt = new PdbBitField(baseDataType, this.bitFieldSize, this.bitFieldOffset >= 0 ? this.bitFieldOffset : 0);
            }
            catch (InvalidDataTypeException e) {
                Msg.error((Object)this, (Object)("PDB parse error: " + e.getMessage()));
                return null;
            }
            wrappedDt = new WrappedDataType((DataType)bitFieldDt, false, false);
        }
        return wrappedDt;
    }

    private void parseBitField(String name) {
        if (name == null || this.kind != PdbKind.MEMBER) {
            return;
        }
        int bitFieldColonIndex = DefaultPdbMember.getBitfieldIndex(name);
        if (bitFieldColonIndex >= 0) {
            this.isBitField = true;
            String bitSizeOffsetStr = name.substring(bitFieldColonIndex + 1);
            try {
                int colonIndex = bitSizeOffsetStr.indexOf(58);
                if (colonIndex > 0) {
                    this.bitFieldOffset = NumericUtilities.parseInt((String)bitSizeOffsetStr.substring(colonIndex + 1));
                    bitSizeOffsetStr = bitSizeOffsetStr.substring(0, colonIndex);
                } else {
                    this.dataTypeParser.setMissingBitOffsetError();
                }
                NumberUtils.toInt((String)bitSizeOffsetStr, (int)0);
                this.bitFieldSize = NumericUtilities.parseInt((String)bitSizeOffsetStr);
            }
            catch (NumberFormatException e) {
                Msg.error((Object)this, (Object)("Invalid PDB bitfield specification: " + name));
            }
        }
    }

    private static int getBitfieldIndex(String name) {
        int loc = name.lastIndexOf(58);
        if (loc < 5) {
            return -1;
        }
        if (name.charAt(loc - 1) == ':') {
            return -1;
        }
        if ((loc = name.lastIndexOf(58, loc - 1)) > 0 && name.charAt(loc - 1) != ':') {
            return loc;
        }
        return -1;
    }
}

