/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.facade;

import ghidra.features.bsim.query.protocol.PreFilter;
import ghidra.features.bsim.query.protocol.QueryNearestVector;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.listing.Program;
import java.util.Set;

public class SFOverviewInfo {
    public static final int DEFAULT_QUERIES_PER_STAGE = 10;
    private Set<FunctionSymbol> functions;
    private Program program;
    private QueryNearestVector queryNearestVector;
    private PreFilter preFilter;

    public SFOverviewInfo(Set<FunctionSymbol> functions) {
        if (functions == null) {
            throw new IllegalArgumentException("Function list cannot be null");
        }
        if (functions.isEmpty()) {
            throw new IllegalArgumentException("Function list cannot be empty");
        }
        this.functions = functions;
        for (FunctionSymbol s : functions) {
            if (this.program == null) {
                this.program = s.getProgram();
                continue;
            }
            if (this.program == s.getProgram()) continue;
            throw new IllegalArgumentException("all function symbols are not from the same program");
        }
        this.queryNearestVector = new QueryNearestVector();
        this.preFilter = new PreFilter();
    }

    public Program getProgram() {
        return this.program;
    }

    public double getSimilarityThreshold() {
        return this.queryNearestVector.thresh;
    }

    public void setSimilarityThreshold(double similarityThreshold) {
        this.queryNearestVector.thresh = similarityThreshold;
    }

    public double getSignificanceThreshold() {
        return this.queryNearestVector.signifthresh;
    }

    public void setSignificanceThreshold(double significanceThreshold) {
        this.queryNearestVector.signifthresh = significanceThreshold;
    }

    public int getVectorMax() {
        return this.queryNearestVector.vectormax;
    }

    public void setVectorMax(int max) {
        this.queryNearestVector.vectormax = max;
    }

    public QueryNearestVector buildQueryNearestVector() {
        return this.queryNearestVector;
    }

    public Set<FunctionSymbol> getFunctions() {
        return this.functions;
    }

    public int getNumberOfStages(int queries_per_stage) {
        if (this.functions == null || this.functions.size() == 0) {
            return 1;
        }
        if (queries_per_stage == 0) {
            queries_per_stage = 10;
        }
        return (this.functions.size() + (queries_per_stage - 1)) / queries_per_stage;
    }

    public PreFilter getPreFilter() {
        return this.preFilter;
    }
}

