/*
 * Decompiled with CFR 0.152.
 */
import ghidra.launch.AppConfig;
import ghidra.launch.JavaFinder;
import ghidra.launch.JavaVersion;
import ghidra.launch.LaunchProperties;
import ghidra.launch.MacJavaFinder;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.List;
import javax.swing.JFileChooser;

public class LaunchSupport {
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_FAILURE = 1;

    public static void main(String[] args) {
        int exitCode = 1;
        if (args.length < 2 || args.length > 4) {
            System.err.println("LaunchSupport expected 2 to 4 arguments but got " + args.length);
            System.exit(exitCode);
        }
        int argIx = 0;
        String installDirPath = args[argIx++];
        String mode = args[argIx++];
        String checkPath = null;
        if ("-java_home_check".equals(mode)) {
            checkPath = args[argIx++];
        }
        if (!"-java_home".equals(mode) && !"-jdk_home".equals(mode) && argIx != args.length) {
            System.err.println("LaunchSupport received illegal argument: " + args[argIx]);
            System.exit(exitCode);
        }
        boolean ask = false;
        boolean save = false;
        for (int i = argIx; i < args.length; ++i) {
            if (args[i].equals("-ask")) {
                ask = true;
                continue;
            }
            if (args[i].equals("-save")) {
                save = true;
                continue;
            }
            System.err.println("LaunchSupport received illegal argument: " + args[i]);
            System.exit(exitCode);
        }
        try {
            File installDir = new File(installDirPath).getCanonicalFile();
            AppConfig appConfig = new AppConfig(installDir);
            JavaFinder javaFinder = JavaFinder.create();
            switch (mode.toLowerCase()) {
                case "-java_home": {
                    exitCode = LaunchSupport.handleJavaHome(appConfig, javaFinder, JavaFinder.JavaFilter.ANY, ask, save);
                    break;
                }
                case "-java_home_check": {
                    if (appConfig.isSupportedJavaHomeDir(new File(checkPath), JavaFinder.JavaFilter.ANY)) {
                        exitCode = 0;
                    }
                    break;
                }
                case "-jdk_home": {
                    exitCode = LaunchSupport.handleJavaHome(appConfig, javaFinder, JavaFinder.JavaFilter.JDK_ONLY, ask, save);
                    break;
                }
                case "-vmargs": {
                    exitCode = LaunchSupport.handleVmArgs(appConfig);
                    break;
                }
                default: {
                    System.err.println("LaunchSupport received illegal argument: " + mode);
                    break;
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        System.exit(exitCode);
    }

    private static int handleJavaHome(AppConfig appConfig, JavaFinder javaFinder, JavaFinder.JavaFilter javaFilter, boolean ask, boolean save) throws IOException {
        if (ask) {
            return LaunchSupport.askJavaHome(appConfig, javaFinder, javaFilter);
        }
        return LaunchSupport.findJavaHome(appConfig, javaFinder, javaFilter, save);
    }

    private static void logJavaHomeError(File javaHomeDir, boolean isError, String source) {
        String level;
        String string = level = isError ? "ERROR: " : "WARNING: ";
        if (!javaHomeDir.isDirectory()) {
            System.err.println(level + source + " specifies non-existing directory: " + javaHomeDir);
        } else {
            System.err.println(level + source + " specifies unsupported java version: " + javaHomeDir);
        }
    }

    private static int findJavaHome(AppConfig appConfig, JavaFinder javaFinder, JavaFinder.JavaFilter javaFilter, boolean save) throws IOException {
        String javaHome;
        LaunchProperties launchProperties = appConfig.getLaunchProperties();
        File javaHomeDir = launchProperties.getJavaHomeOverride();
        if (appConfig.isSupportedJavaHomeDir(javaHomeDir, javaFilter)) {
            if (save) {
                appConfig.saveJavaHome(javaHomeDir);
            }
            System.out.println(javaHomeDir);
            return 0;
        }
        if (javaHomeDir != null) {
            LaunchSupport.logJavaHomeError(javaHomeDir, true, launchProperties.getLaunchPropertiesFile().getAbsolutePath() + ", " + LaunchProperties.JAVA_HOME_OVERRIDE);
        }
        if ((javaHome = System.getenv("JAVA_HOME")) != null && appConfig.isSupportedJavaHomeDir(javaHomeDir = new File(javaHome), javaFilter)) {
            if (save) {
                appConfig.saveJavaHome(javaHomeDir);
            }
            System.out.println(javaHomeDir);
            return 0;
        }
        javaHomeDir = javaFinder.findSupportedJavaHomeFromCurrentJavaHome(appConfig, javaFilter);
        if (javaHomeDir != null) {
            if (save) {
                appConfig.saveJavaHome(javaHomeDir);
            }
            System.out.println(javaHomeDir);
            return 0;
        }
        javaHomeDir = appConfig.getSavedJavaHome();
        if (appConfig.isSupportedJavaHomeDir(javaHomeDir, javaFilter)) {
            System.out.println(javaHomeDir);
            return 0;
        }
        List<File> javaHomeDirs = javaFinder.findSupportedJavaHomeFromInstallations(appConfig, javaFilter);
        if (!javaHomeDirs.isEmpty()) {
            javaHomeDir = javaHomeDirs.iterator().next();
            if (save) {
                appConfig.saveJavaHome(javaHomeDir);
            }
            System.out.println(javaHomeDir);
            return 0;
        }
        if (javaHome != null) {
            LaunchSupport.logJavaHomeError(new File(javaHome), false, "JAVA_HOME environment");
        }
        return 1;
    }

    private static int askJavaHome(AppConfig appConfig, JavaFinder javaFinder, JavaFinder.JavaFilter javaFilter) throws IOException {
        int max;
        String javaName = javaFilter.equals((Object)JavaFinder.JavaFilter.JDK_ONLY) ? "JDK" : "Java";
        int min = appConfig.getMinSupportedJava();
        String javaRange = min == (max = appConfig.getMaxSupportedJava()) ? min + "" : (max == 0 ? min + "+" : min + "-" + max);
        System.out.println("******************************************************************");
        System.out.println(javaName + " " + javaRange + " (" + appConfig.getSupportedArchitecture() + "-bit) could not be found and must be manually chosen!");
        System.out.println("******************************************************************");
        File javaHomeDir = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            boolean supportsDialog = !GraphicsEnvironment.isHeadless() && !(javaFinder instanceof MacJavaFinder);
            System.out.print("Enter path to " + javaName + " home directory");
            System.out.print(supportsDialog ? " (ENTER for dialog): " : ": ");
            String line = in.readLine().trim();
            if (supportsDialog && line.isEmpty()) {
                System.out.println("Opening selection dialog...");
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(1);
                chooser.setDialogTitle("Choose a " + javaName + " home directory");
                if (chooser.showOpenDialog(null) == 0) {
                    javaHomeDir = chooser.getSelectedFile();
                }
            } else {
                if (line.isEmpty()) continue;
                javaHomeDir = new File(line);
            }
            try {
                JavaVersion javaVersion = appConfig.getJavaVersion(javaHomeDir, javaFilter);
                if (appConfig.isJavaVersionSupported(javaVersion)) break;
                System.out.println("Java version " + javaVersion + " is outside of supported range: [" + javaRange + " " + appConfig.getSupportedArchitecture() + "-bit]");
            }
            catch (FileNotFoundException e) {
                System.out.println("Not a valid " + javaName + " home directory. " + e.getMessage() + "!");
            }
            catch (IOException | ParseException e) {
                System.out.println("Failed to verify Java version. " + e.getMessage() + "!");
            }
        }
        File javaHomeSaveFile = appConfig.saveJavaHome(javaHomeDir);
        System.out.println("Saved changes to " + javaHomeSaveFile);
        return 0;
    }

    private static int handleVmArgs(AppConfig appConfig) {
        if (appConfig.getLaunchProperties() == null) {
            System.err.println("Launch properties file was not specified!");
            return 1;
        }
        appConfig.getLaunchProperties().getVmArgList().forEach(e -> System.out.print(e + "\r\n"));
        return 0;
    }
}

