/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.engine.value.AbstractValue;
import io.sf.carte.echosvg.css.engine.value.ComponentValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import org.w3c.api.DOMSyntaxException;
import org.w3c.css.om.typed.CSSRectValue;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public class RectValue
extends ComponentValue
implements CSSRectValue {
    private static final long serialVersionUID = 1L;
    protected Value top;
    protected Value right;
    protected Value bottom;
    protected Value left;

    public RectValue(Value t, Value r, Value b, Value l) {
        this.setTop(t);
        this.setRight(r);
        this.setBottom(b);
        this.setLeft(l);
    }

    public CSSValue.Type getPrimitiveType() {
        return CSSValue.Type.RECT;
    }

    public String getCssText() {
        return "rect(" + this.top.getCssText() + ", " + this.right.getCssText() + ", " + this.bottom.getCssText() + ", " + this.left.getCssText() + ')';
    }

    public Value getTop() throws DOMException {
        return this.top;
    }

    public Value getRight() throws DOMException {
        return this.right;
    }

    public Value getBottom() throws DOMException {
        return this.bottom;
    }

    public Value getLeft() throws DOMException {
        return this.left;
    }

    void setTop(Value top) {
        this.top = this.component(top);
    }

    Value component(Value c) throws DOMSyntaxException {
        short unit = c.getUnitType();
        if (unit != 2 && unit != 0 && !CSSUnit.isLengthUnitType((short)unit) && c.getPrimitiveType() != CSSValue.Type.IDENT) {
            throw new DOMSyntaxException("rect() component must be a length or percentage.");
        }
        if (c.getModificationHandler() != null) {
            c = ((AbstractValue)c).clone();
        }
        this.componentize(c);
        return c;
    }

    void setRight(Value right) {
        this.right = this.component(right);
    }

    void setBottom(Value bottom) {
        this.bottom = this.component(bottom);
    }

    void setLeft(Value left) {
        this.left = this.component(left);
    }

    @Override
    public RectValue getRectValue() throws DOMException {
        return this;
    }

    @Override
    public int getLength() throws DOMException {
        return 4;
    }

    @Override
    public Value item(int index) throws DOMException {
        switch (index) {
            case 0: {
                return this.getTop();
            }
            case 1: {
                return this.getRight();
            }
            case 2: {
                return this.getBottom();
            }
            case 3: {
                return this.getLeft();
            }
        }
        return null;
    }

    @Override
    public RectValue clone() {
        RectValue clon = new RectValue(this.top, this.right, this.bottom, this.left);
        return clon;
    }
}

