/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.kingbase.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDialect;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class KingbaseDialect
extends PostgreDialect {
    public boolean isDelimiterAfterBlock() {
        return true;
    }

    public void generateStoredProcedureCall(StringBuilder sql, DBSProcedure proc, Collection<? extends DBSProcedureParameter> parameters, boolean castParams) {
        DBPDataSource dataSource;
        ArrayList<DBSProcedureParameter> inParameters = new ArrayList<DBSProcedureParameter>();
        if (parameters != null) {
            inParameters.addAll(parameters);
        }
        DBPPreferenceStore prefStore = (dataSource = proc.getDataSource()) != null ? dataSource.getContainer().getPreferenceStore() : DBWorkbench.getPlatform().getPreferenceStore();
        String namedParameterPrefix = prefStore.getString("sql.parameter.prefix");
        boolean useBrackets = this.useBracketsForExec(proc);
        if (useBrackets) {
            sql.append("{ ");
        }
        sql.append(this.getStoredProcedureCallInitialClause(proc)).append("(");
        if (!inParameters.isEmpty()) {
            this.inParametersProc(sql, castParams, inParameters, namedParameterPrefix);
        }
        sql.append(")");
        String callEndClause = this.getProcedureCallEndClause(proc);
        if (!CommonUtils.isEmpty((String)callEndClause)) {
            sql.append(" ").append(callEndClause);
        }
        if (!useBrackets) {
            sql.append(";");
        } else {
            sql.append(" }");
        }
        sql.append("\n\n");
    }

    private void inParametersProc(StringBuilder sql, boolean castParams, List<DBSProcedureParameter> inParameters, String namedParameterPrefix) {
        boolean first = true;
        block4: for (DBSProcedureParameter parameter : inParameters) {
            String typeName = parameter.getParameterType().getFullTypeName();
            switch (parameter.getParameterKind()) {
                case IN: 
                case INOUT: {
                    if (!first) {
                        sql.append(", ");
                    }
                    if (castParams) {
                        sql.append("cast(").append(namedParameterPrefix).append(CommonUtils.escapeIdentifier((String)parameter.getName())).append(" as ").append(typeName).append(")");
                        break;
                    }
                    sql.append(namedParameterPrefix).append(CommonUtils.escapeIdentifier((String)parameter.getName()));
                    break;
                }
                case RETURN: {
                    continue block4;
                }
                default: {
                    if (!this.isStoredProcedureCallIncludesOutParameters()) break;
                    if (!first) {
                        sql.append(", ");
                    }
                    if (castParams) {
                        sql.append("cast(?").append(" as ").append(typeName).append(")");
                        break;
                    }
                    sql.append("?");
                }
            }
            first = false;
        }
    }
}

