/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlProcessorFactory {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY_ERROR_ON_DOCTYPE = XmlProcessorFactory.createDocumentBuilderFactoryWithErrorOnDOCTYPE();
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY_IGNORING_DOCTYPE = XmlProcessorFactory.createDocumentBuilderFactoryIgnoringDOCTYPE();
    private static final SAXParserFactory SAX_FACTORY_ERROR_ON_DOCTYPE = XmlProcessorFactory.createSAXFactoryWithErrorOnDOCTYPE(false);
    private static final SAXParserFactory SAX_FACTORY_ERROR_ON_DOCTYPE_NS = XmlProcessorFactory.createSAXFactoryWithErrorOnDOCTYPE(true);
    private static final SAXParserFactory SAX_FACTORY_IGNORING_DOCTYPE = XmlProcessorFactory.createSAXFactoryIgnoringDOCTYPE();
    private static final SAXParserFactory SAX_FACTORY_PURE = XmlProcessorFactory.createSAXFactory(false);
    private static final SAXParserFactory SAX_FACTORY_PURE_NS = XmlProcessorFactory.createSAXFactory(true);

    private XmlProcessorFactory() {
    }

    public static TransformerFactory createTransformerFactoryWithErrorOnDOCTYPE() {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return factory;
    }

    public static synchronized DocumentBuilderFactory createDocumentBuilderFactoryWithErrorOnDOCTYPE() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return factory;
    }

    public static synchronized DocumentBuilderFactory createDocumentBuilderFactoryIgnoringDOCTYPE() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return factory;
    }

    public static synchronized DocumentBuilder createDocumentBuilderWithErrorOnDOCTYPE() throws ParserConfigurationException {
        return DOCUMENT_BUILDER_FACTORY_ERROR_ON_DOCTYPE.newDocumentBuilder();
    }

    public static synchronized DocumentBuilder createDocumentBuilderIgnoringDOCTYPE() throws ParserConfigurationException {
        DocumentBuilder builder = DOCUMENT_BUILDER_FACTORY_IGNORING_DOCTYPE.newDocumentBuilder();
        builder.setEntityResolver((publicId, systemId) -> new InputSource(new ByteArrayInputStream(new byte[0])));
        return builder;
    }

    public static SAXParserFactory createSAXFactoryWithErrorOnDOCTYPE() {
        return XmlProcessorFactory.createSAXFactoryWithErrorOnDOCTYPE(false);
    }

    public static synchronized SAXParserFactory createSAXFactoryWithErrorOnDOCTYPE(boolean awareness) {
        SAXParserFactory f = SAXParserFactory.newInstance();
        if (awareness) {
            f.setNamespaceAware(true);
        }
        try {
            f.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return f;
    }

    private static synchronized SAXParserFactory createSAXFactoryIgnoringDOCTYPE() {
        SAXParserFactory f = SAXParserFactory.newInstance();
        try {
            f.setFeature("http://xml.org/sax/features/external-general-entities", false);
            f.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            f.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return f;
    }

    public static SAXParser createSAXParserWithErrorOnDOCTYPE() throws ParserConfigurationException, SAXException {
        return XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE(false);
    }

    public static synchronized SAXParser createSAXParserWithErrorOnDOCTYPE(boolean namespaceAware) throws ParserConfigurationException, SAXException {
        if (namespaceAware) {
            return SAX_FACTORY_ERROR_ON_DOCTYPE_NS.newSAXParser();
        }
        return SAX_FACTORY_ERROR_ON_DOCTYPE.newSAXParser();
    }

    public static synchronized SAXParser createSAXParserIgnoringDOCTYPE() throws ParserConfigurationException, SAXException {
        SAXParser parser = SAX_FACTORY_IGNORING_DOCTYPE.newSAXParser();
        parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return parser;
    }

    private static synchronized SAXParserFactory createSAXFactory(boolean awareness) {
        SAXParserFactory f = SAXParserFactory.newInstance();
        if (awareness) {
            f.setNamespaceAware(true);
        }
        return f;
    }

    public static synchronized SAXParser createSAXParserNoExternal(boolean namespaceAware) throws ParserConfigurationException, SAXException {
        SAXParser parser = namespaceAware ? SAX_FACTORY_PURE_NS.newSAXParser() : SAX_FACTORY_PURE.newSAXParser();
        parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        parser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return parser;
    }

    public static synchronized SAXParser createSAXParserNoExternal() throws ParserConfigurationException, SAXException {
        return XmlProcessorFactory.createSAXParserNoExternal(false);
    }

    public static Document parseWithErrorOnDOCTYPE(InputSource is) throws SAXException, IOException, ParserConfigurationException {
        return XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE().parse(is);
    }

    public static Document parseWithErrorOnDOCTYPE(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        return XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE().parse(is);
    }

    public static Document parseWithErrorOnDOCTYPE(File file) throws SAXException, IOException, ParserConfigurationException {
        return XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE().parse(file);
    }

    public static Document newDocumentWithErrorOnDOCTYPE() throws ParserConfigurationException {
        return XmlProcessorFactory.createDocumentBuilderWithErrorOnDOCTYPE().newDocument();
    }
}

