﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/securityhub/SecurityHub_EXPORTS.h>
#include <aws/securityhub/model/AwsEcsContainerDetails.h>
#include <aws/securityhub/model/AwsEcsTaskVolumeDetails.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SecurityHub {
namespace Model {

/**
 * <p>Provides details about a task in a cluster. </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsEcsTaskDetails">AWS
 * API Reference</a></p>
 */
class AwsEcsTaskDetails {
 public:
  AWS_SECURITYHUB_API AwsEcsTaskDetails() = default;
  AWS_SECURITYHUB_API AwsEcsTaskDetails(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API AwsEcsTaskDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SECURITYHUB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the cluster that hosts the task. </p>
   */
  inline const Aws::String& GetClusterArn() const { return m_clusterArn; }
  inline bool ClusterArnHasBeenSet() const { return m_clusterArnHasBeenSet; }
  template <typename ClusterArnT = Aws::String>
  void SetClusterArn(ClusterArnT&& value) {
    m_clusterArnHasBeenSet = true;
    m_clusterArn = std::forward<ClusterArnT>(value);
  }
  template <typename ClusterArnT = Aws::String>
  AwsEcsTaskDetails& WithClusterArn(ClusterArnT&& value) {
    SetClusterArn(std::forward<ClusterArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the task definition that creates the task. </p>
   */
  inline const Aws::String& GetTaskDefinitionArn() const { return m_taskDefinitionArn; }
  inline bool TaskDefinitionArnHasBeenSet() const { return m_taskDefinitionArnHasBeenSet; }
  template <typename TaskDefinitionArnT = Aws::String>
  void SetTaskDefinitionArn(TaskDefinitionArnT&& value) {
    m_taskDefinitionArnHasBeenSet = true;
    m_taskDefinitionArn = std::forward<TaskDefinitionArnT>(value);
  }
  template <typename TaskDefinitionArnT = Aws::String>
  AwsEcsTaskDetails& WithTaskDefinitionArn(TaskDefinitionArnT&& value) {
    SetTaskDefinitionArn(std::forward<TaskDefinitionArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version counter for the task. </p>
   */
  inline const Aws::String& GetVersion() const { return m_version; }
  inline bool VersionHasBeenSet() const { return m_versionHasBeenSet; }
  template <typename VersionT = Aws::String>
  void SetVersion(VersionT&& value) {
    m_versionHasBeenSet = true;
    m_version = std::forward<VersionT>(value);
  }
  template <typename VersionT = Aws::String>
  AwsEcsTaskDetails& WithVersion(VersionT&& value) {
    SetVersion(std::forward<VersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Unix timestamp for the time when the task was created. More specifically,
   * it's for the time when the task entered the <code>PENDING</code> state. </p>
   */
  inline const Aws::String& GetCreatedAt() const { return m_createdAt; }
  inline bool CreatedAtHasBeenSet() const { return m_createdAtHasBeenSet; }
  template <typename CreatedAtT = Aws::String>
  void SetCreatedAt(CreatedAtT&& value) {
    m_createdAtHasBeenSet = true;
    m_createdAt = std::forward<CreatedAtT>(value);
  }
  template <typename CreatedAtT = Aws::String>
  AwsEcsTaskDetails& WithCreatedAt(CreatedAtT&& value) {
    SetCreatedAt(std::forward<CreatedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Unix timestamp for the time when the task started. More specifically,
   * it's for the time when the task transitioned from the <code>PENDING</code> state
   * to the <code>RUNNING</code> state. </p>
   */
  inline const Aws::String& GetStartedAt() const { return m_startedAt; }
  inline bool StartedAtHasBeenSet() const { return m_startedAtHasBeenSet; }
  template <typename StartedAtT = Aws::String>
  void SetStartedAt(StartedAtT&& value) {
    m_startedAtHasBeenSet = true;
    m_startedAt = std::forward<StartedAtT>(value);
  }
  template <typename StartedAtT = Aws::String>
  AwsEcsTaskDetails& WithStartedAt(StartedAtT&& value) {
    SetStartedAt(std::forward<StartedAtT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The tag specified when a task is started. If an Amazon ECS service started
   * the task, the <code>startedBy</code> parameter contains the deployment ID of
   * that service. </p>
   */
  inline const Aws::String& GetStartedBy() const { return m_startedBy; }
  inline bool StartedByHasBeenSet() const { return m_startedByHasBeenSet; }
  template <typename StartedByT = Aws::String>
  void SetStartedBy(StartedByT&& value) {
    m_startedByHasBeenSet = true;
    m_startedBy = std::forward<StartedByT>(value);
  }
  template <typename StartedByT = Aws::String>
  AwsEcsTaskDetails& WithStartedBy(StartedByT&& value) {
    SetStartedBy(std::forward<StartedByT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the task group that's associated with the task. </p>
   */
  inline const Aws::String& GetGroup() const { return m_group; }
  inline bool GroupHasBeenSet() const { return m_groupHasBeenSet; }
  template <typename GroupT = Aws::String>
  void SetGroup(GroupT&& value) {
    m_groupHasBeenSet = true;
    m_group = std::forward<GroupT>(value);
  }
  template <typename GroupT = Aws::String>
  AwsEcsTaskDetails& WithGroup(GroupT&& value) {
    SetGroup(std::forward<GroupT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Details about the data volume that is used in a task definition. </p>
   */
  inline const Aws::Vector<AwsEcsTaskVolumeDetails>& GetVolumes() const { return m_volumes; }
  inline bool VolumesHasBeenSet() const { return m_volumesHasBeenSet; }
  template <typename VolumesT = Aws::Vector<AwsEcsTaskVolumeDetails>>
  void SetVolumes(VolumesT&& value) {
    m_volumesHasBeenSet = true;
    m_volumes = std::forward<VolumesT>(value);
  }
  template <typename VolumesT = Aws::Vector<AwsEcsTaskVolumeDetails>>
  AwsEcsTaskDetails& WithVolumes(VolumesT&& value) {
    SetVolumes(std::forward<VolumesT>(value));
    return *this;
  }
  template <typename VolumesT = AwsEcsTaskVolumeDetails>
  AwsEcsTaskDetails& AddVolumes(VolumesT&& value) {
    m_volumesHasBeenSet = true;
    m_volumes.emplace_back(std::forward<VolumesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The containers that are associated with the task. </p>
   */
  inline const Aws::Vector<AwsEcsContainerDetails>& GetContainers() const { return m_containers; }
  inline bool ContainersHasBeenSet() const { return m_containersHasBeenSet; }
  template <typename ContainersT = Aws::Vector<AwsEcsContainerDetails>>
  void SetContainers(ContainersT&& value) {
    m_containersHasBeenSet = true;
    m_containers = std::forward<ContainersT>(value);
  }
  template <typename ContainersT = Aws::Vector<AwsEcsContainerDetails>>
  AwsEcsTaskDetails& WithContainers(ContainersT&& value) {
    SetContainers(std::forward<ContainersT>(value));
    return *this;
  }
  template <typename ContainersT = AwsEcsContainerDetails>
  AwsEcsTaskDetails& AddContainers(ContainersT&& value) {
    m_containersHasBeenSet = true;
    m_containers.emplace_back(std::forward<ContainersT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_clusterArn;

  Aws::String m_taskDefinitionArn;

  Aws::String m_version;

  Aws::String m_createdAt;

  Aws::String m_startedAt;

  Aws::String m_startedBy;

  Aws::String m_group;

  Aws::Vector<AwsEcsTaskVolumeDetails> m_volumes;

  Aws::Vector<AwsEcsContainerDetails> m_containers;
  bool m_clusterArnHasBeenSet = false;
  bool m_taskDefinitionArnHasBeenSet = false;
  bool m_versionHasBeenSet = false;
  bool m_createdAtHasBeenSet = false;
  bool m_startedAtHasBeenSet = false;
  bool m_startedByHasBeenSet = false;
  bool m_groupHasBeenSet = false;
  bool m_volumesHasBeenSet = false;
  bool m_containersHasBeenSet = false;
};

}  // namespace Model
}  // namespace SecurityHub
}  // namespace Aws
