﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/schemas/Schemas_EXPORTS.h>
#include <aws/schemas/model/RegistrySummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Schemas {
namespace Model {
class ListRegistriesResult {
 public:
  AWS_SCHEMAS_API ListRegistriesResult() = default;
  AWS_SCHEMAS_API ListRegistriesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SCHEMAS_API ListRegistriesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The token that specifies the next page of results to return. To request the
   * first page, leave NextToken empty. The token will expire in 24 hours, and cannot
   * be shared with other accounts.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListRegistriesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An array of registry summaries.</p>
   */
  inline const Aws::Vector<RegistrySummary>& GetRegistries() const { return m_registries; }
  template <typename RegistriesT = Aws::Vector<RegistrySummary>>
  void SetRegistries(RegistriesT&& value) {
    m_registriesHasBeenSet = true;
    m_registries = std::forward<RegistriesT>(value);
  }
  template <typename RegistriesT = Aws::Vector<RegistrySummary>>
  ListRegistriesResult& WithRegistries(RegistriesT&& value) {
    SetRegistries(std::forward<RegistriesT>(value));
    return *this;
  }
  template <typename RegistriesT = RegistrySummary>
  ListRegistriesResult& AddRegistries(RegistriesT&& value) {
    m_registriesHasBeenSet = true;
    m_registries.emplace_back(std::forward<RegistriesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListRegistriesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<RegistrySummary> m_registries;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_registriesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Schemas
}  // namespace Aws
