﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/eventbridge/EventBridge_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace EventBridge {
namespace Model {

/**
 * <p>The details about an event generated by an SaaS partner.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/eventbridge-2015-10-07/PutPartnerEventsRequestEntry">AWS
 * API Reference</a></p>
 */
class PutPartnerEventsRequestEntry {
 public:
  AWS_EVENTBRIDGE_API PutPartnerEventsRequestEntry() = default;
  AWS_EVENTBRIDGE_API PutPartnerEventsRequestEntry(Aws::Utils::Json::JsonView jsonValue);
  AWS_EVENTBRIDGE_API PutPartnerEventsRequestEntry& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_EVENTBRIDGE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The date and time of the event.</p>
   */
  inline const Aws::Utils::DateTime& GetTime() const { return m_time; }
  inline bool TimeHasBeenSet() const { return m_timeHasBeenSet; }
  template <typename TimeT = Aws::Utils::DateTime>
  void SetTime(TimeT&& value) {
    m_timeHasBeenSet = true;
    m_time = std::forward<TimeT>(value);
  }
  template <typename TimeT = Aws::Utils::DateTime>
  PutPartnerEventsRequestEntry& WithTime(TimeT&& value) {
    SetTime(std::forward<TimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The event source that is generating the entry.</p>  <p>
   * <code>Detail</code>, <code>DetailType</code>, and <code>Source</code> are
   * required for EventBridge to successfully send an event to an event bus. If you
   * include event entries in a request that do not include each of those properties,
   * EventBridge fails that entry. If you submit a request in which <i>none</i> of
   * the entries have each of these properties, EventBridge fails the entire request.
   * </p>
   */
  inline const Aws::String& GetSource() const { return m_source; }
  inline bool SourceHasBeenSet() const { return m_sourceHasBeenSet; }
  template <typename SourceT = Aws::String>
  void SetSource(SourceT&& value) {
    m_sourceHasBeenSet = true;
    m_source = std::forward<SourceT>(value);
  }
  template <typename SourceT = Aws::String>
  PutPartnerEventsRequestEntry& WithSource(SourceT&& value) {
    SetSource(std::forward<SourceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Amazon Web Services resources, identified by Amazon Resource Name (ARN),
   * which the event primarily concerns. Any number, including zero, may be
   * present.</p>
   */
  inline const Aws::Vector<Aws::String>& GetResources() const { return m_resources; }
  inline bool ResourcesHasBeenSet() const { return m_resourcesHasBeenSet; }
  template <typename ResourcesT = Aws::Vector<Aws::String>>
  void SetResources(ResourcesT&& value) {
    m_resourcesHasBeenSet = true;
    m_resources = std::forward<ResourcesT>(value);
  }
  template <typename ResourcesT = Aws::Vector<Aws::String>>
  PutPartnerEventsRequestEntry& WithResources(ResourcesT&& value) {
    SetResources(std::forward<ResourcesT>(value));
    return *this;
  }
  template <typename ResourcesT = Aws::String>
  PutPartnerEventsRequestEntry& AddResources(ResourcesT&& value) {
    m_resourcesHasBeenSet = true;
    m_resources.emplace_back(std::forward<ResourcesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A free-form string, with a maximum of 128 characters, used to decide what
   * fields to expect in the event detail.</p>  <p> <code>Detail</code>,
   * <code>DetailType</code>, and <code>Source</code> are required for EventBridge to
   * successfully send an event to an event bus. If you include event entries in a
   * request that do not include each of those properties, EventBridge fails that
   * entry. If you submit a request in which <i>none</i> of the entries have each of
   * these properties, EventBridge fails the entire request. </p>
   */
  inline const Aws::String& GetDetailType() const { return m_detailType; }
  inline bool DetailTypeHasBeenSet() const { return m_detailTypeHasBeenSet; }
  template <typename DetailTypeT = Aws::String>
  void SetDetailType(DetailTypeT&& value) {
    m_detailTypeHasBeenSet = true;
    m_detailType = std::forward<DetailTypeT>(value);
  }
  template <typename DetailTypeT = Aws::String>
  PutPartnerEventsRequestEntry& WithDetailType(DetailTypeT&& value) {
    SetDetailType(std::forward<DetailTypeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A valid JSON string. There is no other schema imposed. The JSON string may
   * contain fields and nested sub-objects.</p>  <p> <code>Detail</code>,
   * <code>DetailType</code>, and <code>Source</code> are required for EventBridge to
   * successfully send an event to an event bus. If you include event entries in a
   * request that do not include each of those properties, EventBridge fails that
   * entry. If you submit a request in which <i>none</i> of the entries have each of
   * these properties, EventBridge fails the entire request. </p>
   */
  inline const Aws::String& GetDetail() const { return m_detail; }
  inline bool DetailHasBeenSet() const { return m_detailHasBeenSet; }
  template <typename DetailT = Aws::String>
  void SetDetail(DetailT&& value) {
    m_detailHasBeenSet = true;
    m_detail = std::forward<DetailT>(value);
  }
  template <typename DetailT = Aws::String>
  PutPartnerEventsRequestEntry& WithDetail(DetailT&& value) {
    SetDetail(std::forward<DetailT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_time{};
  bool m_timeHasBeenSet = false;

  Aws::String m_source;
  bool m_sourceHasBeenSet = false;

  Aws::Vector<Aws::String> m_resources;
  bool m_resourcesHasBeenSet = false;

  Aws::String m_detailType;
  bool m_detailTypeHasBeenSet = false;

  Aws::String m_detail;
  bool m_detailHasBeenSet = false;
};

}  // namespace Model
}  // namespace EventBridge
}  // namespace Aws
