/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.util.regex;

import ai.grazie.rules.util.regex.Regex;
import ai.grazie.rules.util.regex.RegexPath;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RegexMatcher {
    private static final Hash.Strategy<String> CASE_INSENSITIVE_STRATEGY = new Hash.Strategy<String>(){

        public int hashCode(String s) {
            int hash = 0;
            for (int i = 0; i < s.length(); ++i) {
                hash = 31 * hash + Character.toLowerCase(s.charAt(i));
            }
            return hash;
        }

        public boolean equals(String s1, String s2) {
            return s1.equalsIgnoreCase(s2);
        }
    };

    private RegexMatcher() {
    }

    public abstract boolean matches(String var1);

    @Nullable
    public abstract Set<String> possibleValues();

    @NotNull
    static RegexMatcher create(Regex regex, boolean caseSensitive) {
        return RegexMatcher.create(regex, caseSensitive, Integer.MAX_VALUE);
    }

    @NotNull
    public static RegexMatcher create(Regex regex, final boolean caseSensitive, int maxPossibleValues) {
        Set<String> values = regex.possibleValues(maxPossibleValues);
        if (values != null) {
            if (values.size() == 1) {
                final String singleValue = values.iterator().next();
                return new RegexMatcher(){

                    @Override
                    public boolean matches(String text) {
                        return caseSensitive ? text.equals(singleValue) : text.equalsIgnoreCase(singleValue);
                    }

                    @Override
                    public Set<String> possibleValues() {
                        return Set.of(singleValue);
                    }
                };
            }
            ObjectOpenHashSet set = caseSensitive ? new ObjectOpenHashSet(values) : new ObjectOpenCustomHashSet(values, CASE_INSENSITIVE_STRATEGY);
            return new RegexMatcher((Set)set){
                final /* synthetic */ Set val$set;
                {
                    this.val$set = set;
                }

                @Override
                public boolean matches(String text) {
                    return this.val$set.contains(text);
                }

                @Override
                public Set<String> possibleValues() {
                    return this.val$set;
                }
            };
        }
        Set<RegexPath> paths = regex.term.enumerate(1);
        final Function<String, Boolean> fastMatcher = paths.size() == 1 ? paths.iterator().next().matcher(caseSensitive) : null;
        final Pattern pattern = Pattern.compile(regex.pattern, caseSensitive ? 0 : 66);
        return new RegexMatcher(){

            @Override
            public boolean matches(String text) {
                Boolean fast = fastMatcher == null ? null : (Boolean)fastMatcher.apply(text);
                return fast != null ? fast.booleanValue() : pattern.matcher(text).matches();
            }

            @Override
            @Nullable
            public Set<String> possibleValues() {
                return null;
            }
        };
    }
}

