/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStructuralType
implements PyType {
    @NotNull
    private final Set<String> myAttributes;
    private final boolean myInferredFromUsages;

    public PyStructuralType(@NotNull Set<String> attributes, boolean inferredFromUsages) {
        if (attributes == null) {
            PyStructuralType.$$$reportNull$$$0(0);
        }
        this.myAttributes = new LinkedHashSet<String>(attributes);
        this.myInferredFromUsages = inferredFromUsages;
    }

    @Nullable
    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        if (name == null) {
            PyStructuralType.$$$reportNull$$$0(1);
        }
        if (direction == null) {
            PyStructuralType.$$$reportNull$$$0(2);
        }
        if (resolveContext == null) {
            PyStructuralType.$$$reportNull$$$0(3);
        }
        return Collections.emptyList();
    }

    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        ArrayList<LookupElementBuilder> variants = new ArrayList<LookupElementBuilder>();
        for (String attribute : this.myAttributes) {
            if (attribute.equals(completionPrefix)) continue;
            variants.add(LookupElementBuilder.create((String)attribute).withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Field)));
        }
        return variants.toArray();
    }

    @Nullable
    public String getName() {
        return "{" + StringUtil.join(this.myAttributes, (String)", ") + "}";
    }

    public boolean isBuiltin() {
        return false;
    }

    public void assertValid(String message) {
    }

    public String toString() {
        return "PyStructuralType(" + StringUtil.join(this.myAttributes, (String)", ") + ")";
    }

    public boolean isInferredFromUsages() {
        return this.myInferredFromUsages;
    }

    @NotNull
    public Set<String> getAttributeNames() {
        Set<String> set = Collections.unmodifiableSet(this.myAttributes);
        if (set == null) {
            PyStructuralType.$$$reportNull$$$0(4);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyStructuralType type = (PyStructuralType)o;
        return this.myInferredFromUsages == type.myInferredFromUsages && Objects.equals(this.myAttributes, type.myAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.myAttributes, this.myInferredFromUsages);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyStructuralType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyStructuralType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveMember";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

