/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.facet.labels;

import org.apache.lucene.facet.range.Range;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.sandbox.facet.labels.OrdToLabel;

public class RangeOrdToLabel
implements OrdToLabel {
    private final Range[] ranges;

    public RangeOrdToLabel(Range[] inputRanges) {
        this.ranges = inputRanges;
    }

    @Override
    public FacetLabel getLabel(int ordinal) {
        if (ordinal >= 0 && ordinal < this.ranges.length) {
            return new FacetLabel(new String[]{this.ranges[ordinal].label});
        }
        return null;
    }

    @Override
    public FacetLabel[] getLabels(int[] ordinals) {
        FacetLabel[] facetLabels = new FacetLabel[ordinals.length];
        for (int i = 0; i < ordinals.length; ++i) {
            facetLabels[i] = this.getLabel(ordinals[i]);
        }
        return facetLabels;
    }
}

