/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxEventHandlerReference;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxPropertyReference;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxScopeEnlarger;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxStaticPropertyReference;
import org.jetbrains.plugins.javaFX.refactoring.JavaFxPropertyElement;

public final class JavaFxMethodSearcher
implements QueryExecutor<PsiReference, ReferencesSearch.SearchParameters> {
    public boolean execute(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        JavaFxPropertyElement propertyElement;
        JavaFxPropertyReference propertyReference;
        PsiMethod staticSetter;
        PsiElement elementToSearch;
        if (queryParameters == null) {
            JavaFxMethodSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaFxMethodSearcher.$$$reportNull$$$0(1);
        }
        if ((elementToSearch = queryParameters.getElementToSearch()) instanceof PsiMethod) {
            JavaFxMethodSearcher.searchMethod((PsiMethod)elementToSearch, queryParameters, consumer);
        }
        if (elementToSearch instanceof JavaFxPropertyElement && (staticSetter = (propertyReference = (propertyElement = (JavaFxPropertyElement)elementToSearch).getPropertyReference()).getStaticSetter()) != null) {
            JavaFxMethodSearcher.searchMethod(staticSetter, queryParameters, consumer);
        }
        return true;
    }

    private static void searchMethod(@NotNull PsiMethod psiMethod, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        if (psiMethod == null) {
            JavaFxMethodSearcher.$$$reportNull$$$0(2);
        }
        if (queryParameters == null) {
            JavaFxMethodSearcher.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            JavaFxMethodSearcher.$$$reportNull$$$0(4);
        }
        Project project = PsiUtilCore.getProjectInReadAction((PsiElement)psiMethod);
        SearchScope scope = (SearchScope)ReadAction.compute(() -> ((ReferencesSearch.SearchParameters)queryParameters).getEffectiveSearchScope());
        if (scope instanceof LocalSearchScope) {
            VirtualFile[] vFiles;
            for (VirtualFile vFile : vFiles = ((LocalSearchScope)scope).getVirtualFiles()) {
                Boolean goOn;
                PsiFile psiFile;
                if (JavaFxFileTypeFactory.isFxml(vFile) && (psiFile = PsiManager.getInstance((Project)project).findFile(vFile)) != null && !(goOn = (Boolean)ReadAction.compute(() -> JavaFxMethodSearcher.searchMethodInFile(psiMethod, psiFile, consumer))).booleanValue()) break;
            }
        } else if (scope instanceof GlobalSearchScope) {
            String propertyName = (String)ReadAction.compute(() -> PropertyUtilBase.getPropertyName((String)psiMethod.getName()));
            if (propertyName == null) {
                return;
            }
            String className = (String)ReadAction.compute(() -> {
                PsiClass psiClass = psiMethod.getContainingClass();
                return psiClass != null ? psiClass.getName() : null;
            });
            if (className == null) {
                return;
            }
            JavaFxScopeEnlarger.GlobalFxmlSearchScope fxmlScope = new JavaFxScopeEnlarger.GlobalFxmlSearchScope((GlobalSearchScope)scope);
            Object[] filteredFiles = (VirtualFile[])ReadAction.compute(() -> JavaFxMethodSearcher.lambda$searchMethod$3(project, className, (GlobalSearchScope)fxmlScope));
            if (ArrayUtil.isEmpty((Object[])filteredFiles)) {
                return;
            }
            ReadAction.run(() -> JavaFxMethodSearcher.lambda$searchMethod$5(project, (VirtualFile[])filteredFiles, psiMethod, consumer, propertyName));
        }
    }

    private static boolean searchMethodInFile(final @NotNull PsiMethod psiMethod, @NotNull PsiFile file, final @NotNull Processor<? super PsiReference> consumer) {
        if (psiMethod == null) {
            JavaFxMethodSearcher.$$$reportNull$$$0(5);
        }
        if (file == null) {
            JavaFxMethodSearcher.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            JavaFxMethodSearcher.$$$reportNull$$$0(7);
        }
        final Ref stopped = new Ref((Object)false);
        file.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlElement(@NotNull XmlElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((Boolean)stopped.get()).booleanValue()) {
                    return;
                }
                super.visitXmlElement(element);
            }

            public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
                PsiReference[] references;
                if (attribute == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (((Boolean)stopped.get()).booleanValue()) {
                    return;
                }
                for (PsiReference reference : references = attribute.getReferences()) {
                    if (!(reference instanceof JavaFxStaticPropertyReference) && !(reference instanceof JavaFxEventHandlerReference) || !reference.isReferenceTo((PsiElement)psiMethod) || consumer.process((Object)reference)) continue;
                    stopped.set((Object)true);
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attribute";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitXmlAttribute";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return (Boolean)stopped.get() == false;
    }

    private static /* synthetic */ void lambda$searchMethod$5(Project project, VirtualFile[] filteredFiles, PsiMethod psiMethod, Processor consumer, String propertyName) throws RuntimeException {
        GlobalSearchScope filteredScope = GlobalSearchScope.filesScope((Project)project, (Collection)ContainerUtil.newHashSet((Object[])filteredFiles));
        CacheManager.getInstance((Project)project).processFilesWithWord(file -> JavaFxMethodSearcher.searchMethodInFile(psiMethod, file, (Processor<? super PsiReference>)consumer), propertyName, (short)16, filteredScope, true);
    }

    private static /* synthetic */ VirtualFile[] lambda$searchMethod$3(Project project, String className, GlobalSearchScope fxmlScope) throws RuntimeException {
        return CacheManager.getInstance((Project)project).getVirtualFilesWithWord(className, (short)16, fxmlScope, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxMethodSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "searchMethod";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "searchMethodInFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

