/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl;

import java.util.regex.Pattern;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.WCWidth;

public class DefaultHighlighter
implements Highlighter {
    protected Pattern errorPattern;
    protected int errorIndex = -1;

    @Override
    public AttributedString highlight(LineReader reader, String buffer) {
        int underlineStart = -1;
        int underlineEnd = -1;
        int negativeStart = -1;
        int negativeEnd = -1;
        String search = reader.getSearchTerm();
        if (search != null && search.length() > 0 && (underlineStart = buffer.indexOf(search)) >= 0) {
            underlineEnd = underlineStart + search.length() - 1;
        }
        if (reader.getRegionActive() != LineReader.RegionType.NONE) {
            negativeStart = reader.getRegionMark();
            if (negativeStart > (negativeEnd = reader.getBuffer().cursor())) {
                int x2 = negativeEnd;
                negativeEnd = negativeStart;
                negativeStart = x2;
            }
            if (reader.getRegionActive() == LineReader.RegionType.LINE) {
                while (negativeStart > 0 && reader.getBuffer().atChar(negativeStart - 1) != 10) {
                    --negativeStart;
                }
                while (negativeEnd < reader.getBuffer().length() - 1 && reader.getBuffer().atChar(negativeEnd + 1) != 10) {
                    ++negativeEnd;
                }
            }
        }
        AttributedStringBuilder sb = new AttributedStringBuilder();
        for (int i2 = 0; i2 < buffer.length(); ++i2) {
            char c2;
            if (i2 == underlineStart) {
                sb.style(AttributedStyle::underline);
            }
            if (i2 == negativeStart) {
                sb.style(AttributedStyle::inverse);
            }
            if (i2 == this.errorIndex) {
                sb.style(AttributedStyle::inverse);
            }
            if ((c2 = buffer.charAt(i2)) == '\t' || c2 == '\n') {
                sb.append(c2);
            } else if (c2 < ' ') {
                sb.style(AttributedStyle::inverseNeg).append('^').append((char)(c2 + 64)).style(AttributedStyle::inverseNeg);
            } else {
                int w2 = WCWidth.wcwidth(c2);
                if (w2 > 0) {
                    sb.append(c2);
                }
            }
            if (i2 == underlineEnd) {
                sb.style(AttributedStyle::underlineOff);
            }
            if (i2 == negativeEnd) {
                sb.style(AttributedStyle::inverseOff);
            }
            if (i2 != this.errorIndex) continue;
            sb.style(AttributedStyle::inverseOff);
        }
        if (this.errorPattern != null) {
            sb.styleMatches(this.errorPattern, AttributedStyle.INVERSE);
        }
        return sb.toAttributedString();
    }
}

