/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureAgent;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CaptureStorage {
    public static final String GENERATED_INSERT_METHOD_POSTFIX = "$$$capture";
    private static final ConcurrentIdentityWeakHashMap<Object, CapturedStack> STORAGE_GENERAL = new ConcurrentIdentityWeakHashMap();
    private static final ConcurrentIdentityWeakHashMap<Throwable, CapturedStack> STORAGE_THROWABLES = new ConcurrentIdentityWeakHashMap();
    private static final ConcurrentIdentityWeakHashMap<Thread, Deque<CapturedStack>> THREAD_TO_STACKS_MAP = new ConcurrentIdentityWeakHashMap();
    private static final ThreadLocal<Deque<CapturedStack>> CURRENT_STACKS = new ThreadLocal<Deque<CapturedStack>>(){

        @Override
        protected Deque<CapturedStack> initialValue() {
            return new LinkedList<CapturedStack>();
        }
    };
    private static final boolean storeAsyncStackTracesForAllThreads = Boolean.parseBoolean(System.getProperty("debugger.async.stack.trace.for.all.threads", "false"));
    private static final ThreadLocal<Boolean> THROWABLE_CAPTURE_DISABLED = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    public static boolean DEBUG;
    private static boolean ENABLED;
    private static final StackTraceElement ASYNC_STACK_ELEMENT;
    private static final ConcurrentIdentityWeakHashMap<ClassLoader, Method> COROUTINE_GET_CALLER_FRAME_METHODS;

    private static Deque<CapturedStack> getStacksForCurrentThread() {
        if (storeAsyncStackTracesForAllThreads) {
            Thread currentThread = Thread.currentThread();
            Deque<CapturedStack> capturedStacks = THREAD_TO_STACKS_MAP.get(currentThread);
            if (capturedStacks == null) {
                capturedStacks = new LinkedList<CapturedStack>();
                THREAD_TO_STACKS_MAP.put(currentThread, capturedStacks);
            }
            return capturedStacks;
        }
        return CURRENT_STACKS.get();
    }

    public static void capture(final Object key) {
        if (!ENABLED) {
            return;
        }
        CaptureStorage.withoutThrowableCapture(new Runnable(){

            @Override
            public void run() {
                try {
                    if (DEBUG) {
                        System.out.println("captureGeneral " + CaptureStorage.getCallerDescriptorForLogging() + " - " + CaptureStorage.getKeyText(key));
                    }
                    CapturedStack stack = (CapturedStack)CaptureStorage.getStacksForCurrentThread().peekLast();
                    STORAGE_GENERAL.put(key, CaptureStorage.createCapturedStack(new Throwable(), stack));
                }
                catch (AssertionError | Exception e) {
                    CaptureStorage.handleException((Throwable)e);
                }
            }
        });
    }

    public static void captureThrowable(final Throwable throwable) {
        if (!ENABLED || THROWABLE_CAPTURE_DISABLED.get().booleanValue()) {
            return;
        }
        CaptureStorage.withoutThrowableCapture(new Runnable(){

            @Override
            public void run() {
                try {
                    CapturedStack stack;
                    if (DEBUG) {
                        System.out.println("captureThrowable " + CaptureStorage.getCallerDescriptorForLogging() + " - " + CaptureStorage.getKeyText(throwable));
                    }
                    if ((stack = (CapturedStack)CaptureStorage.getStacksForCurrentThread().peekLast()) != null) {
                        assert (!(stack instanceof ExceptionCapturedStack) || ((ExceptionCapturedStack)stack).myException != throwable);
                        STORAGE_THROWABLES.put(throwable, stack);
                    }
                }
                catch (AssertionError | Exception e) {
                    CaptureStorage.handleException((Throwable)e);
                }
            }
        });
    }

    public static void insertEnter(final Object key) {
        if (!ENABLED) {
            return;
        }
        CaptureStorage.withoutThrowableCapture(new Runnable(){

            @Override
            public void run() {
                try {
                    CapturedStack stack = (CapturedStack)STORAGE_GENERAL.get(key);
                    Deque currentStacks = CaptureStorage.getStacksForCurrentThread();
                    currentStacks.add(stack);
                    if (DEBUG) {
                        System.out.println("insert " + CaptureStorage.getCallerDescriptorForLogging() + " -> " + CaptureStorage.getKeyText(key) + ", stack saved (" + currentStacks.size() + ")");
                    }
                }
                catch (Exception e) {
                    CaptureStorage.handleException(e);
                }
            }
        });
    }

    public static void insertExit(final Object key) {
        if (!ENABLED) {
            return;
        }
        CaptureStorage.withoutThrowableCapture(new Runnable(){

            @Override
            public void run() {
                try {
                    Deque currentStacks = CaptureStorage.getStacksForCurrentThread();
                    currentStacks.pollLast();
                    if (DEBUG) {
                        System.out.println("insert " + CaptureStorage.getCallerDescriptorForLogging() + " <- " + CaptureStorage.getKeyText(key) + ", stack removed (" + currentStacks.size() + ")");
                    }
                }
                catch (Exception e) {
                    CaptureStorage.handleException(e);
                }
            }
        });
    }

    public static Object coroutineOwner(final Object key) {
        if (!ENABLED) {
            return key;
        }
        return CaptureStorage.withoutThrowableCapture(new Callable<Object>(){

            @Override
            public Object call() {
                try {
                    Method getCallerFrameMethod = CaptureStorage.getGetCallerFrameMethod(key);
                    Object res = key;
                    while (true) {
                        Object caller;
                        if ((caller = getCallerFrameMethod.invoke(res, new Object[0])) == null) {
                            return res;
                        }
                        if ("kotlinx.coroutines.debug.internal.DebugProbesImpl$CoroutineOwner".equals(caller.getClass().getName())) {
                            return caller;
                        }
                        res = caller;
                    }
                }
                catch (Exception e) {
                    CaptureStorage.handleException(e);
                    return key;
                }
            }
        });
    }

    public static StackTraceElement[] getAsyncStackTrace(final Throwable throwable) {
        if (!ENABLED) {
            return throwable.getStackTrace();
        }
        return CaptureStorage.withoutThrowableCapture(new Callable<StackTraceElement[]>(){

            @Override
            public StackTraceElement[] call() {
                try {
                    CapturedStack stack = (CapturedStack)STORAGE_THROWABLES.get(throwable);
                    if (stack != null) {
                        CapturedStack capturedStack = CaptureStorage.createCapturedStack(throwable, stack);
                        ArrayList stackTrace = CaptureStorage.getStackTrace(capturedStack, CaptureAgent.throwableAsyncStackDepthLimit());
                        return stackTrace.toArray(new StackTraceElement[0]);
                    }
                }
                catch (Exception e) {
                    CaptureStorage.handleException(e);
                }
                return throwable.getStackTrace();
            }
        });
    }

    private static void withoutThrowableCapture(final Runnable runnable) {
        CaptureStorage.withoutThrowableCapture(new Callable<Void>(){

            @Override
            public Void call() {
                runnable.run();
                return null;
            }
        });
    }

    private static <T> T withoutThrowableCapture(Callable<T> action) {
        Boolean oldValue = THROWABLE_CAPTURE_DISABLED.get();
        THROWABLE_CAPTURE_DISABLED.set(true);
        try {
            T t = action.call();
            return t;
        }
        finally {
            THROWABLE_CAPTURE_DISABLED.set(oldValue);
        }
    }

    private static Method getGetCallerFrameMethod(Object key) throws NoSuchMethodException, ClassNotFoundException {
        ClassLoader classLoader = key.getClass().getClassLoader();
        Method getCallerFrameMethod = COROUTINE_GET_CALLER_FRAME_METHODS.get(classLoader);
        if (getCallerFrameMethod == null) {
            getCallerFrameMethod = Class.forName("kotlin.coroutines.jvm.internal.CoroutineStackFrame", false, classLoader).getDeclaredMethod("getCallerFrame", new Class[0]);
            COROUTINE_GET_CALLER_FRAME_METHODS.put(classLoader, getCallerFrameMethod);
        }
        return getCallerFrameMethod;
    }

    private static CapturedStack createCapturedStack(Throwable exception, CapturedStack insertMatch) {
        if (insertMatch != null) {
            CapturedStack stack = new DeepCapturedStack(exception, insertMatch);
            if (stack.getRecursionDepth() > 100) {
                ArrayList<StackTraceElement> trace = CaptureStorage.getStackTrace(stack, 500);
                trace.trimToSize();
                stack = new UnwindCapturedStack(trace);
            }
            return stack;
        }
        return new ExceptionCapturedStack(exception);
    }

    public static String getCurrentCapturedStack(int limit) throws IOException {
        return CaptureStorage.wrapInString(CaptureStorage.getStacksForCurrentThread().peekLast(), limit);
    }

    public static String getCapturedStackForThread(int limit, Thread thread) throws IOException {
        Deque<CapturedStack> capturedStacks;
        Deque<CapturedStack> deque = storeAsyncStackTracesForAllThreads ? THREAD_TO_STACKS_MAP.get(thread) : (capturedStacks = thread == Thread.currentThread() ? CURRENT_STACKS.get() : null);
        if (capturedStacks == null) {
            return null;
        }
        return CaptureStorage.wrapInString(capturedStacks.peekLast(), limit);
    }

    public static Map<Thread, String> getAllCapturedStacks(int limit) throws IOException {
        HashMap<Thread, String> threadToStacks = new HashMap<Thread, String>();
        if (storeAsyncStackTracesForAllThreads) {
            for (Map.Entry entry : ((ConcurrentIdentityWeakHashMap)THREAD_TO_STACKS_MAP).map.entrySet()) {
                Thread thread = (Thread)((ConcurrentIdentityWeakHashMap.Key)entry.getKey()).get();
                if (entry.getValue() == null || ((Deque)entry.getValue()).isEmpty() || !thread.isAlive()) continue;
                String capturedStack = CaptureStorage.wrapInString((CapturedStack)((Deque)entry.getValue()).peekLast(), limit);
                threadToStacks.put(thread, capturedStack);
            }
        } else {
            Deque<CapturedStack> capturedStacks = CURRENT_STACKS.get();
            if (capturedStacks != null) {
                threadToStacks.put(Thread.currentThread(), CaptureStorage.wrapInString(capturedStacks.peekLast(), limit));
            }
        }
        return threadToStacks;
    }

    public static Object[][] getRelatedStack(Object key, int limit) {
        return CaptureStorage.wrapInArray(STORAGE_GENERAL.get(key), limit);
    }

    private static String wrapInString(CapturedStack stack, int limit) throws IOException {
        if (stack == null) {
            return null;
        }
        ByteArrayOutputStream bas = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bas);
        for (StackTraceElement elem : CaptureStorage.getStackTrace(stack, limit)) {
            if (elem == ASYNC_STACK_ELEMENT) {
                dos.writeBoolean(false);
                continue;
            }
            dos.writeBoolean(true);
            dos.writeUTF(elem.getClassName());
            dos.writeUTF(elem.getMethodName());
            dos.writeInt(elem.getLineNumber());
        }
        return bas.toString("ISO-8859-1");
    }

    private static Object[][] wrapInArray(CapturedStack stack, int limit) {
        if (stack == null) {
            return null;
        }
        ArrayList<StackTraceElement> stackTrace = CaptureStorage.getStackTrace(stack, limit);
        Object[][] res = new Object[stackTrace.size()][];
        for (int i = 0; i < stackTrace.size(); ++i) {
            StackTraceElement elem = (StackTraceElement)stackTrace.get(i);
            res[i] = elem == ASYNC_STACK_ELEMENT ? null : new Object[]{elem.getClassName(), elem.getFileName(), elem.getMethodName(), String.valueOf(elem.getLineNumber())};
        }
        return res;
    }

    private static List<StackTraceElement> trimInitAgentFrames(List<StackTraceElement> elements) {
        int firstNotAgent = 0;
        for (int i = 0; i < elements.size(); ++i) {
            if (!CaptureStorage.isNotAgentFrame(elements.get(i))) continue;
            firstNotAgent = i;
            break;
        }
        return elements.subList(firstNotAgent, elements.size());
    }

    private static ArrayList<StackTraceElement> getStackTrace(CapturedStack stack, int limit) {
        ArrayList<StackTraceElement> res = new ArrayList<StackTraceElement>();
        while (stack != null && res.size() <= limit) {
            List<StackTraceElement> stackTrace = CaptureStorage.trimInitAgentFrames(stack.getStackTrace());
            if (stack instanceof DeepCapturedStack) {
                int size = stackTrace.size();
                int newEnd = Integer.MAX_VALUE;
                for (int i = 0; i < size; ++i) {
                    StackTraceElement elem = stackTrace.get(i);
                    if (elem.getMethodName().endsWith(GENERATED_INSERT_METHOD_POSTFIX)) {
                        newEnd = i + 2;
                        break;
                    }
                    if (elem != ASYNC_STACK_ELEMENT) continue;
                    newEnd = i;
                    break;
                }
                if (newEnd > size) {
                    stack = null;
                } else {
                    stackTrace = stackTrace.subList(0, newEnd);
                    stack = ((DeepCapturedStack)stack).myInsertMatch;
                }
            } else {
                stack = null;
            }
            res.addAll(stackTrace);
            if (stack == null) continue;
            res.add(ASYNC_STACK_ELEMENT);
        }
        return res;
    }

    public static void setEnabled(boolean enabled) {
        ENABLED = enabled;
    }

    private static void handleException(Throwable e) {
        ENABLED = false;
        System.err.println("Critical error in IDEA Async Stacktraces instrumenting agent. Agent is now disabled. Please report to IDEA support:");
        e.printStackTrace();
    }

    private static boolean isNotAgentFrame(StackTraceElement elem) {
        return !elem.getClassName().startsWith(CaptureStorage.class.getPackage().getName());
    }

    private static String getCallerDescriptorForLogging() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 1; i < stackTrace.length; ++i) {
            StackTraceElement elem = stackTrace[i];
            if (!CaptureStorage.isNotAgentFrame(elem)) continue;
            return elem.getClassName() + "." + elem.getMethodName();
        }
        return "unknown";
    }

    private static String getKeyText(Object key) {
        String res = key.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(key));
        try {
            return res + "(" + key + ")";
        }
        catch (RuntimeException runtimeException) {
            return res;
        }
    }

    static {
        ENABLED = true;
        ASYNC_STACK_ELEMENT = new StackTraceElement("--- Async", "Stack.Trace --- ", "captured by IntelliJ IDEA debugger", -1);
        COROUTINE_GET_CALLER_FRAME_METHODS = new ConcurrentIdentityWeakHashMap();
    }

    private static class DeepCapturedStack
    extends ExceptionCapturedStack {
        final CapturedStack myInsertMatch;
        final int myRecursionDepth;

        DeepCapturedStack(Throwable exception, CapturedStack insertMatch) {
            super(exception);
            this.myInsertMatch = insertMatch;
            this.myRecursionDepth = insertMatch.getRecursionDepth() + 1;
        }

        @Override
        public int getRecursionDepth() {
            return this.myRecursionDepth;
        }
    }

    private static class ExceptionCapturedStack
    implements CapturedStack {
        final Throwable myException;

        private ExceptionCapturedStack(Throwable exception) {
            this.myException = exception;
        }

        @Override
        public List<StackTraceElement> getStackTrace() {
            return Arrays.asList(this.myException.getStackTrace());
        }

        @Override
        public int getRecursionDepth() {
            return 0;
        }
    }

    private static class UnwindCapturedStack
    implements CapturedStack {
        final List<StackTraceElement> myStackTraceElements;

        UnwindCapturedStack(List<StackTraceElement> elements) {
            this.myStackTraceElements = elements;
        }

        @Override
        public List<StackTraceElement> getStackTrace() {
            return this.myStackTraceElements;
        }

        @Override
        public int getRecursionDepth() {
            return 0;
        }
    }

    private static interface CapturedStack {
        public List<StackTraceElement> getStackTrace();

        public int getRecursionDepth();
    }

    private static class ConcurrentIdentityWeakHashMap<K, V> {
        private final ReferenceQueue<K> referenceQueue = new ReferenceQueue();
        private final ConcurrentMap<Key<K>, V> map = new ConcurrentHashMap<Key<K>, V>();

        private ConcurrentIdentityWeakHashMap() {
        }

        public V put(K key, V value) {
            this.processQueue();
            return this.map.put(new WeakKey<K>(key, this.referenceQueue), value);
        }

        public V get(K key) {
            return this.map.get(new HardKey<K>(key));
        }

        private void processQueue() {
            WeakKey key;
            while ((key = (WeakKey)this.referenceQueue.poll()) != null) {
                this.map.remove(key);
            }
        }

        private static boolean equalKeys(Key<?> x, Key<?> y) {
            if (x == y) {
                return true;
            }
            Object kx = x.get();
            Object ky = y.get();
            return kx != null && kx == ky;
        }

        private static class WeakKey<K>
        extends WeakReference<K>
        implements Key<K> {
            private final int myHash;

            WeakKey(K key, ReferenceQueue<K> q) {
                super(key, q);
                this.myHash = System.identityHashCode(key);
            }

            public boolean equals(Object o) {
                return o instanceof Key && ConcurrentIdentityWeakHashMap.equalKeys(this, (Key)o);
            }

            public int hashCode() {
                return this.myHash;
            }
        }

        private static class HardKey<K>
        implements Key<K> {
            private final K myKey;
            private final int myHash;

            HardKey(K key) {
                this.myKey = key;
                this.myHash = System.identityHashCode(key);
            }

            @Override
            public K get() {
                return this.myKey;
            }

            public boolean equals(Object o) {
                return o instanceof Key && ConcurrentIdentityWeakHashMap.equalKeys(this, (Key)o);
            }

            public int hashCode() {
                return this.myHash;
            }
        }

        private static interface Key<K> {
            public K get();
        }
    }

    private static interface Callable<T> {
        public T call();
    }
}

