/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.eel.impl.fs;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.ReadResult;
import com.intellij.platform.eel.fs.EelFileInfo;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFsError;
import com.intellij.platform.eel.fs.EelOpenedFile;
import com.intellij.platform.eel.fs.EelPosixFileInfo;
import com.intellij.platform.eel.fs.EelPosixFileInfoImpl;
import com.intellij.platform.eel.fs.EelWindowsFileInfo;
import com.intellij.platform.eel.impl.fs.EelFsResultImpl;
import com.intellij.platform.eel.impl.fs.NioBasedEelFileSystemApi;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.NotLinkException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.spi.FileSystemProvider;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u00a2\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u001aD\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\u0006\u0010\r\u001a\u00020\fH\u0002\u001aD\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0002\u001aL\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00110\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0002\u001a4\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00170\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bH\u0002\u001a,\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a \u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002\u001a\f\u0010\"\u001a\u00020#*\u00020$H\u0002\u001a\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002\u001a\u0018\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002\u001a\u0010\u0010-\u001a\u00020.2\u0006\u0010'\u001a\u00020(H\u0002\u001a\u0016\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002\u00a8\u00064"}, d2={"doRead", "Lcom/intellij/platform/eel/EelResult;", "Lcom/intellij/platform/eel/ReadResult;", "Lcom/intellij/platform/eel/fs/EelOpenedFile$Reader$ReadError;", "eelFs", "Lcom/intellij/platform/eel/impl/fs/NioBasedEelFileSystemApi;", "byteChannel", "Ljava/nio/channels/SeekableByteChannel;", "buf", "Ljava/nio/ByteBuffer;", "isClosed", "Ljava/util/concurrent/atomic/AtomicReference;", "", "autoCloseAfterLastChunk", "offset", "", "doSeek", "Lcom/intellij/platform/eel/fs/EelOpenedFile$SeekError;", "path", "Lcom/intellij/platform/eel/path/EelPath;", "whence", "Lcom/intellij/platform/eel/fs/EelOpenedFile$SeekWhence;", "doTell", "Lcom/intellij/platform/eel/fs/EelOpenedFile$TellError;", "doClose", "", "Lcom/intellij/platform/eel/fs/EelOpenedFile$CloseError;", "copyTimes", "oldAttrs", "Ljava/nio/file/attribute/BasicFileAttributes;", "options", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$ChangeAttributesOptions;", "view", "Ljava/nio/file/attribute/BasicFileAttributeView;", "toFileTime", "Ljava/nio/file/attribute/FileTime;", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$TimeSinceEpoch;", "getFileAttributes", "Lcom/intellij/platform/eel/fs/EelFileInfo;", "child", "Ljava/nio/file/Path;", "symlinkPolicy", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$SymlinkPolicy;", "getPosixFileAttributes", "Lcom/intellij/platform/eel/fs/EelPosixFileInfo;", "getWindowsFileAttributes", "Lcom/intellij/platform/eel/fs/EelWindowsFileInfo;", "convertPermissionsToMask", "", "permissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "intellij.platform.eel.impl"})
@SourceDebugExtension(value={"SMAP\nLocalEelFileSystemApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalEelFileSystemApi.kt\ncom/intellij/platform/eel/impl/fs/LocalEelFileSystemApiKt\n+ 2 LocalEelFileSystemApi.kt\ncom/intellij/platform/eel/impl/fs/NioBasedEelFileSystemApi\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1029:1\n54#2,28:1030\n54#2,28:1058\n54#2,28:1086\n54#2,28:1114\n51#2,31:1142\n1#3:1173\n*S KotlinDebug\n*F\n+ 1 LocalEelFileSystemApi.kt\ncom/intellij/platform/eel/impl/fs/LocalEelFileSystemApiKt\n*L\n377#1:1030,28\n396#1:1058,28\n412#1:1086,28\n427#1:1114,28\n436#1:1142,31\n*E\n"})
public final class LocalEelFileSystemApiKt {
    /*
     * WARNING - void declaration
     */
    private static final EelResult<ReadResult, EelOpenedFile.Reader.ReadError> doRead(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, ByteBuffer buf, AtomicReference<Boolean> isClosed, boolean autoCloseAfterLastChunk) {
        EelResult eelResult;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = eelFs;
        AtomicReference<Boolean> isClosed$iv = isClosed;
        boolean $i$f$wrapIntoEelResult = false;
        try {
            boolean bl = false;
            int read = byteChannel.read(buf);
            ReadResult result2 = ReadResult.Companion.fromNumberOfReadBytes(read);
            if (autoCloseAfterLastChunk) {
                switch (WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
                    case 1: {
                        isClosed.set(true);
                        break;
                    }
                    case 2: {
                        isClosed.set(false);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            ReadResult readResult = result2;
            EelFsResultImpl.Ok<ReadResult> result$iv = new EelFsResultImpl.Ok<ReadResult>(readResult);
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.updateAndGet(NioBasedEelFileSystemApi.wrapIntoEelResult.1.INSTANCE);
            }
            eelResult = (EelResult)result$iv;
        }
        catch (FileSystemException err$iv) {
            EelFsError eelFsError;
            EelFsError err$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.set(true);
            }
            try {
                eelPath = EelPath.Companion.parse(err$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv;
                Iterable<Path> iterable = this_$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv = eelPath;
            FileSystemException fileSystemException = err$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            }
            if (!((eelFsError2 = (err$iv2 = eelFsError3)) instanceof EelOpenedFile.Reader.ReadError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelOpenedFile.Reader.ReadError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelOpenedFile.Reader.ReadError)new EelFsResultImpl.Other(path$iv, err$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final EelResult<ReadResult, EelOpenedFile.Reader.ReadError> doRead(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, long offset, ByteBuffer buf, AtomicReference<Boolean> isClosed) {
        EelResult eelResult;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = eelFs;
        AtomicReference<Boolean> isClosed$iv = isClosed;
        boolean $i$f$wrapIntoEelResult = false;
        try {
            boolean bl = false;
            long oldPosition = byteChannel.position();
            byteChannel.position(offset);
            int read = byteChannel.read(buf);
            byteChannel.position(oldPosition);
            ReadResult readResult = ReadResult.Companion.fromNumberOfReadBytes(read);
            EelFsResultImpl.Ok<ReadResult> result$iv = new EelFsResultImpl.Ok<ReadResult>(readResult);
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.updateAndGet(NioBasedEelFileSystemApi.wrapIntoEelResult.1.INSTANCE);
            }
            eelResult = (EelResult)result$iv;
        }
        catch (FileSystemException err$iv) {
            EelFsError eelFsError;
            EelFsError err$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.set(true);
            }
            try {
                eelPath = EelPath.Companion.parse(err$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv;
                Iterable<Path> iterable = this_$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv = eelPath;
            FileSystemException fileSystemException = err$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            }
            if (!((eelFsError2 = (err$iv2 = eelFsError3)) instanceof EelOpenedFile.Reader.ReadError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelOpenedFile.Reader.ReadError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelOpenedFile.Reader.ReadError)new EelFsResultImpl.Other(path$iv, err$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final EelResult<Long, EelOpenedFile.SeekError> doSeek(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, EelPath path, EelOpenedFile.SeekWhence whence, long offset, AtomicReference<Boolean> isClosed) {
        EelResult eelResult;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = eelFs;
        AtomicReference<Boolean> isClosed$iv = isClosed;
        boolean $i$f$wrapIntoEelResult = false;
        try {
            boolean bl = false;
            long newPosition = switch (WhenMappings.$EnumSwitchMapping$1[whence.ordinal()]) {
                case 1 -> offset;
                case 2 -> byteChannel.position() + offset;
                case 3 -> byteChannel.size() - offset;
                default -> throw new NoWhenBranchMatchedException();
            };
            byteChannel.position(newPosition);
            Long l = newPosition;
            EelFsResultImpl.Ok<Long> result$iv = new EelFsResultImpl.Ok<Long>(l);
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.updateAndGet(NioBasedEelFileSystemApi.wrapIntoEelResult.1.INSTANCE);
            }
            eelResult = (EelResult)result$iv;
        }
        catch (FileSystemException err$iv) {
            EelFsError eelFsError;
            EelFsError err$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.set(true);
            }
            try {
                eelPath = EelPath.Companion.parse(err$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv;
                Iterable<Path> iterable = this_$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv = eelPath;
            FileSystemException fileSystemException = err$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            }
            if (!((eelFsError2 = (err$iv2 = eelFsError3)) instanceof EelOpenedFile.SeekError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelOpenedFile.SeekError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelOpenedFile.SeekError)new EelFsResultImpl.Other(path$iv, err$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final EelResult<Long, EelOpenedFile.TellError> doTell(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, AtomicReference<Boolean> isClosed) {
        EelResult eelResult;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = eelFs;
        AtomicReference<Boolean> isClosed$iv = isClosed;
        boolean $i$f$wrapIntoEelResult = false;
        try {
            boolean bl = false;
            Long l = byteChannel.position();
            EelFsResultImpl.Ok<Long> result$iv = new EelFsResultImpl.Ok<Long>(l);
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.updateAndGet(NioBasedEelFileSystemApi.wrapIntoEelResult.1.INSTANCE);
            }
            eelResult = (EelResult)result$iv;
        }
        catch (FileSystemException err$iv) {
            EelFsError eelFsError;
            EelFsError err$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            AtomicReference<Boolean> atomicReference = isClosed$iv;
            if (atomicReference != null) {
                atomicReference.set(true);
            }
            try {
                eelPath = EelPath.Companion.parse(err$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv;
                Iterable<Path> iterable = this_$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv = eelPath;
            FileSystemException fileSystemException = err$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            } else {
                String string = err$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv, string);
            }
            if (!((eelFsError2 = (err$iv2 = eelFsError3)) instanceof EelOpenedFile.TellError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelOpenedFile.TellError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelOpenedFile.TellError)new EelFsResultImpl.Other(path$iv, err$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    /*
     * WARNING - void declaration
     */
    private static final EelResult<Unit, EelOpenedFile.CloseError> doClose(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, EelPath path) {
        EelResult eelResult;
        NioBasedEelFileSystemApi this_$iv = eelFs;
        boolean $i$f$wrapIntoEelResult = false;
        NioBasedEelFileSystemApi nioBasedEelFileSystemApi = this_$iv;
        Object isClosed$iv$iv = null;
        boolean $i$f$wrapIntoEelResult2 = false;
        try {
            boolean bl = false;
            byteChannel.close();
            Unit unit = Unit.INSTANCE;
            EelFsResultImpl.Ok<Unit> result$iv$iv = new EelFsResultImpl.Ok<Unit>(unit);
            eelResult = (EelResult)result$iv$iv;
        }
        catch (FileSystemException err$iv$iv) {
            EelFsError eelFsError;
            EelFsError err$iv$iv2;
            EelFsError eelFsError2;
            EelFsError eelFsError3;
            EelPath eelPath;
            try {
                eelPath = EelPath.Companion.parse(err$iv$iv.getFile().toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            catch (EelPathException eelPathException) {
                void this_$iv$iv;
                Iterable<Path> iterable = this_$iv$iv.getFs().getRootDirectories();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"getRootDirectories(...)");
                eelPath = EelPath.Companion.parse(CollectionsKt.first(iterable).toString(), (EelDescriptor)LocalEelDescriptor.INSTANCE);
            }
            EelPath path$iv$iv = eelPath;
            FileSystemException fileSystemException = err$iv$iv;
            if (fileSystemException instanceof AccessDeniedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.PermissionDenied(path$iv$iv, string);
            } else if (fileSystemException instanceof NoSuchFileException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.DoesNotExist(path$iv$iv, string);
            } else if (fileSystemException instanceof FileAlreadyExistsException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.AlreadyExists(path$iv$iv, string);
            } else if (fileSystemException instanceof NotDirectoryException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.NotDirectory(path$iv$iv, string);
            } else if (fileSystemException instanceof NotLinkException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof FileSystemLoopException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof DirectoryNotEmptyException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else if (fileSystemException instanceof AtomicMoveNotSupportedException) {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            } else {
                String string = err$iv$iv.getMessage();
                Intrinsics.checkNotNull((Object)string);
                eelFsError3 = (EelFsError)new EelFsResultImpl.Other(path$iv$iv, string);
            }
            if (!((eelFsError2 = (err$iv$iv2 = eelFsError3)) instanceof EelOpenedFile.CloseError)) {
                eelFsError2 = null;
            }
            if ((eelFsError = (EelFsError)((EelOpenedFile.CloseError)eelFsError2)) == null) {
                eelFsError = (EelFsError)((EelOpenedFile.CloseError)new EelFsResultImpl.Other(path$iv$iv, err$iv$iv2.getMessage()));
            }
            eelResult = (EelResult)new EelFsResultImpl.Error<EelFsError>(eelFsError);
        }
        return eelResult;
    }

    private static final void copyTimes(BasicFileAttributes oldAttrs, EelFileSystemApi.ChangeAttributesOptions options, BasicFileAttributeView view) {
        Object object;
        Object mtime;
        FileTime ctime = oldAttrs.creationTime();
        Object object2 = options.getModificationTime();
        if (object2 == null || (object2 = LocalEelFileSystemApiKt.toFileTime(object2)) == null) {
            object2 = mtime = oldAttrs.lastModifiedTime();
        }
        if ((object = options.getAccessTime()) == null || (object = LocalEelFileSystemApiKt.toFileTime(object)) == null) {
            object = oldAttrs.lastAccessTime();
        }
        Object atime = object;
        view.setTimes(ctime, (FileTime)mtime, (FileTime)atime);
    }

    private static final FileTime toFileTime(EelFileSystemApi.TimeSinceEpoch $this$toFileTime) {
        FileTime fileTime = FileTime.from(Instant.ofEpochSecond($this$toFileTime.getSeconds-s-VKNKU(), (long)$this$toFileTime.getNanoseconds-pVg5ArA() & 0xFFFFFFFFL));
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"from(...)");
        return fileTime;
    }

    private static final EelFileInfo getFileAttributes(Path child, EelFileSystemApi.SymlinkPolicy symlinkPolicy) {
        return SystemInfoRt.isWindows ? (EelFileInfo)LocalEelFileSystemApiKt.getWindowsFileAttributes(child) : (EelFileInfo)LocalEelFileSystemApiKt.getPosixFileAttributes(child, symlinkPolicy);
    }

    private static final EelPosixFileInfo getPosixFileAttributes(Path child, EelFileSystemApi.SymlinkPolicy symlinkPolicy) {
        Object it;
        FileSystemProvider fileSystemProvider = child.getFileSystem().provider();
        LinkOption[] linkOptionArray = switch (WhenMappings.$EnumSwitchMapping$2[symlinkPolicy.ordinal()]) {
            case 1 -> {
                LinkOption[] var6_2 = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};
                yield var6_2;
            }
            case 2, 3 -> new LinkOption[]{};
            default -> throw new NoWhenBranchMatchedException();
        };
        PosixFileAttributes s = fileSystemProvider.readAttributes(child, PosixFileAttributes.class, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        EelPosixFileInfo.Type type = s.isRegularFile() ? (EelPosixFileInfo.Type)new EelPosixFileInfoImpl.Regular(s.size()) : (s.isDirectory() ? (EelPosixFileInfo.Type)new EelPosixFileInfoImpl.Directory(EelFileInfo.CaseSensitivity.SENSITIVE) : (s.isSymbolicLink() ? (EelPosixFileInfo.Type)EelPosixFileInfoImpl.SymlinkUnresolved.INSTANCE : (EelPosixFileInfo.Type)EelPosixFileInfoImpl.Other.INSTANCE));
        Object object = Files.getAttribute(child, "unix:uid", new LinkOption[0]);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int n = (Integer)object;
        Object object2 = Files.getAttribute(child, "unix:gid", new LinkOption[0]);
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
        int n2 = (Integer)object2;
        Set<PosixFilePermission> set = s.permissions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"permissions(...)");
        Object object3 = Files.getAttribute(child, "unix:dev", new LinkOption[0]);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(s.lastAccessTime().toInstant(), ZoneId.systemDefault());
        ZonedDateTime zonedDateTime2 = ZonedDateTime.ofInstant(s.lastModifiedTime().toInstant(), ZoneId.systemDefault());
        ZonedDateTime zonedDateTime3 = ZonedDateTime.ofInstant(s.creationTime().toInstant(), ZoneId.systemDefault());
        EelPosixFileInfo.Permissions permissions2 = (EelPosixFileInfo.Permissions)new EelPosixFileInfoImpl.Permissions(n, n2, LocalEelFileSystemApiKt.convertPermissionsToMask(set));
        EelPosixFileInfo.Type type2 = type;
        boolean bl = false;
        Long l = it instanceof Long ? (Long)it : null;
        long l2 = l != null ? l : 0L;
        it = Files.getAttribute(child, "unix:ino", new LinkOption[0]);
        boolean bl2 = false;
        Long l3 = it instanceof Long ? (Long)it : null;
        long l4 = l3 != null ? l3 : 0L;
        long l5 = l4;
        long l6 = l2;
        ZonedDateTime zonedDateTime4 = zonedDateTime;
        ZonedDateTime zonedDateTime5 = zonedDateTime2;
        ZonedDateTime zonedDateTime6 = zonedDateTime3;
        EelPosixFileInfo.Permissions permissions3 = permissions2;
        EelPosixFileInfo.Type type3 = type2;
        return (EelPosixFileInfo)new EelPosixFileInfoImpl(type3, permissions3, zonedDateTime6, zonedDateTime5, zonedDateTime4, l6, l5);
    }

    private static final EelWindowsFileInfo getWindowsFileAttributes(Path child) {
        DosFileAttributes s = Files.readAttributes(child, DosFileAttributes.class, new LinkOption[0]);
        return new EelWindowsFileInfo(s){
            private final EelWindowsFileInfo.Permissions permissions;
            private final EelFileInfo.Type type;
            private final ZonedDateTime creationTime;
            private final ZonedDateTime lastModifiedTime;
            private final ZonedDateTime lastAccessTime;
            {
                this.permissions = new EelWindowsFileInfo.Permissions($s){
                    private final boolean isReadOnly;
                    private final boolean isHidden;
                    private final boolean isArchive;
                    private final boolean isSystem;
                    {
                        this.isReadOnly = $s.isReadOnly();
                        this.isHidden = $s.isHidden();
                        this.isArchive = $s.isArchive();
                        this.isSystem = $s.isSystem();
                    }

                    public boolean isReadOnly() {
                        return this.isReadOnly;
                    }

                    public boolean isHidden() {
                        return this.isHidden;
                    }

                    public boolean isArchive() {
                        return this.isArchive;
                    }

                    public boolean isSystem() {
                        return this.isSystem;
                    }
                };
                this.type = $s.isRegularFile() ? (EelFileInfo.Type)new EelPosixFileInfoImpl.Regular($s.size()) : ($s.isDirectory() ? (EelFileInfo.Type)new EelPosixFileInfoImpl.Directory(EelFileInfo.CaseSensitivity.SENSITIVE) : (EelFileInfo.Type)EelPosixFileInfoImpl.Other.INSTANCE);
                this.creationTime = ZonedDateTime.ofInstant($s.creationTime().toInstant(), ZoneId.systemDefault());
                this.lastModifiedTime = ZonedDateTime.ofInstant($s.lastModifiedTime().toInstant(), ZoneId.systemDefault());
                this.lastAccessTime = ZonedDateTime.ofInstant($s.lastAccessTime().toInstant(), ZoneId.systemDefault());
            }

            public EelWindowsFileInfo.Permissions getPermissions() {
                return this.permissions;
            }

            public EelFileInfo.Type getType() {
                return this.type;
            }

            public ZonedDateTime getCreationTime() {
                return this.creationTime;
            }

            public ZonedDateTime getLastModifiedTime() {
                return this.lastModifiedTime;
            }

            public ZonedDateTime getLastAccessTime() {
                return this.lastAccessTime;
            }
        };
    }

    private static final int convertPermissionsToMask(Set<? extends PosixFilePermission> permissions2) {
        int mask = 0;
        if (permissions2.contains((Object)PosixFilePermission.OWNER_READ)) {
            mask |= 0x100;
        }
        if (permissions2.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            mask |= 0x80;
        }
        if (permissions2.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            mask |= 0x40;
        }
        if (permissions2.contains((Object)PosixFilePermission.GROUP_READ)) {
            mask |= 0x20;
        }
        if (permissions2.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            mask |= 0x10;
        }
        if (permissions2.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            mask |= 8;
        }
        if (permissions2.contains((Object)PosixFilePermission.OTHERS_READ)) {
            mask |= 4;
        }
        if (permissions2.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            mask |= 2;
        }
        if (permissions2.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            mask |= 1;
        }
        return mask;
    }

    public static final /* synthetic */ EelFileInfo access$getFileAttributes(Path child, EelFileSystemApi.SymlinkPolicy symlinkPolicy) {
        return LocalEelFileSystemApiKt.getFileAttributes(child, symlinkPolicy);
    }

    public static final /* synthetic */ EelResult access$doClose(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, EelPath path) {
        return LocalEelFileSystemApiKt.doClose(eelFs, byteChannel, path);
    }

    public static final /* synthetic */ EelResult access$doRead(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, ByteBuffer buf, AtomicReference isClosed, boolean autoCloseAfterLastChunk) {
        return LocalEelFileSystemApiKt.doRead(eelFs, byteChannel, buf, isClosed, autoCloseAfterLastChunk);
    }

    public static final /* synthetic */ EelResult access$doRead(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, long offset, ByteBuffer buf, AtomicReference isClosed) {
        return LocalEelFileSystemApiKt.doRead(eelFs, byteChannel, offset, buf, isClosed);
    }

    public static final /* synthetic */ EelResult access$doTell(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, AtomicReference isClosed) {
        return LocalEelFileSystemApiKt.doTell(eelFs, byteChannel, isClosed);
    }

    public static final /* synthetic */ EelResult access$doSeek(NioBasedEelFileSystemApi eelFs, SeekableByteChannel byteChannel, EelPath path, EelOpenedFile.SeekWhence whence, long offset, AtomicReference isClosed) {
        return LocalEelFileSystemApiKt.doSeek(eelFs, byteChannel, path, whence, offset, isClosed);
    }

    public static final /* synthetic */ int access$convertPermissionsToMask(Set permissions2) {
        return LocalEelFileSystemApiKt.convertPermissionsToMask(permissions2);
    }

    public static final /* synthetic */ void access$copyTimes(BasicFileAttributes oldAttrs, EelFileSystemApi.ChangeAttributesOptions options, BasicFileAttributeView view) {
        LocalEelFileSystemApiKt.copyTimes(oldAttrs, options, view);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ReadResult.values().length];
            try {
                nArray[ReadResult.EOF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadResult.NOT_EOF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[EelOpenedFile.SeekWhence.values().length];
            try {
                nArray[EelOpenedFile.SeekWhence.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelOpenedFile.SeekWhence.CURRENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelOpenedFile.SeekWhence.END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[EelFileSystemApi.SymlinkPolicy.values().length];
            try {
                nArray[EelFileSystemApi.SymlinkPolicy.DO_NOT_RESOLVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelFileSystemApi.SymlinkPolicy.JUST_RESOLVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelFileSystemApi.SymlinkPolicy.RESOLVE_AND_FOLLOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

