/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.index;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.nexus.index.ArtifactContext;
import org.sonatype.nexus.index.ArtifactInfo;
import org.sonatype.nexus.index.IndexerEngine;
import org.sonatype.nexus.index.context.IndexingContext;

@Component(role=IndexerEngine.class)
public class DefaultIndexerEngine
extends AbstractLogEnabled
implements IndexerEngine {
    public void index(IndexingContext context, ArtifactContext ac) throws IOException {
        Document d;
        if (ac != null && ac.getGav() != null && (d = ac.createDocument(context)) != null) {
            context.getIndexWriter().addDocument(d);
            context.updateTimestamp();
        }
    }

    public void update(IndexingContext context, ArtifactContext ac) throws IOException {
        Document d = ac.createDocument(context);
        if (d != null) {
            IndexWriter w = context.getIndexWriter();
            w.updateDocument(new Term(ArtifactInfo.UINFO, ac.getArtifactInfo().getUinfo()), d);
            this.updateGroups(context, ac);
            w.commit();
            context.updateTimestamp();
        }
    }

    private void updateGroups(IndexingContext context, ArtifactContext ac) throws IOException {
        Set<String> allGroups;
        String rootGroup = ac.getArtifactInfo().getRootGroup();
        Set<String> rootGroups = context.getRootGroups();
        if (!rootGroups.contains(rootGroup)) {
            rootGroups.add(rootGroup);
            context.setRootGroups(rootGroups);
        }
        if (!(allGroups = context.getAllGroups()).contains(ac.getArtifactInfo().groupId)) {
            allGroups.add(ac.getArtifactInfo().groupId);
            context.setAllGroups(allGroups);
        }
    }

    public void remove(IndexingContext context, ArtifactContext ac) throws IOException {
        if (ac != null) {
            String uinfo = ac.getArtifactInfo().getUinfo();
            Document doc = new Document();
            doc.add((Fieldable)new Field(ArtifactInfo.DELETED, uinfo, Field.Store.YES, Field.Index.NO));
            doc.add((Fieldable)new Field(ArtifactInfo.LAST_MODIFIED, Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.NO));
            IndexWriter w = context.getIndexWriter();
            w.addDocument(doc);
            w.deleteDocuments(new Term(ArtifactInfo.UINFO, uinfo));
            w.commit();
            context.updateTimestamp();
        }
    }
}

