/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.arrow;

import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.util.PythonUtils;
import sun.misc.Unsafe;

public class ArrowArray {
    private static final Unsafe unsafe = PythonUtils.initUnsafe();
    public static final byte[] CAPSULE_NAME = PyCapsule.capsuleName("arrow_array");
    public static final byte NULL = 0;
    private static final byte SIZE_OF = 80;
    private static final long LENGTH_INDEX = 0L;
    private static final long NULL_COUNT_INDEX = 8L;
    private static final long OFFSET_INDEX = 16L;
    private static final long N_BUFFERS_INDEX = 24L;
    private static final long N_CHILDREN_INDEX = 32L;
    private static final long BUFFERS_INDEX = 40L;
    private static final long CHILDREN_INDEX = 48L;
    private static final long DICTIONARY_INDEX = 56L;
    private static final long RELEASE_CALLBACK_INDEX = 64L;
    private static final long PRIVATE_DATA_INDEX = 72L;
    private final long memoryAddr;

    private ArrowArray(long memoryAddr) {
        this.memoryAddr = memoryAddr;
    }

    public static ArrowArray allocate(long length, long nullCount, long offset, long nBuffers, long nChildren, long buffers, long children, long dictionary, long release, long privateData) {
        long memoryAddr = unsafe.allocateMemory(80L);
        unsafe.putLong(memoryAddr + 0L, length);
        unsafe.putLong(memoryAddr + 8L, nullCount);
        unsafe.putLong(memoryAddr + 16L, offset);
        unsafe.putLong(memoryAddr + 24L, nBuffers);
        unsafe.putLong(memoryAddr + 32L, nChildren);
        unsafe.putLong(memoryAddr + 40L, buffers);
        unsafe.putLong(memoryAddr + 48L, children);
        unsafe.putLong(memoryAddr + 56L, dictionary);
        unsafe.putLong(memoryAddr + 64L, release);
        unsafe.putLong(memoryAddr + 72L, privateData);
        return new ArrowArray(memoryAddr);
    }

    public long memoryAddress() {
        return this.memoryAddr;
    }

    public long releaseCallback() {
        return unsafe.getLong(this.memoryAddr + 64L);
    }

    public static ArrowArray wrap(long arrowArrayPointer) {
        return new ArrowArray(arrowArrayPointer);
    }

    public boolean isReleased() {
        return this.releaseCallback() == 0L;
    }
}

