/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.GraalPythonModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltinRegistry;
import com.oracle.graal.python.builtins.modules.cext.PythonCextTypeBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeClass;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGCSupport;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonClassNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToJavaNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CConstants;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.memoryview.MemoryViewNodes;
import com.oracle.graal.python.builtins.objects.memoryview.NativeBufferLifecycleManager;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.mmap.PMMap;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.HiddenAttr;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.frame.GetCurrentFrameRef;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.nfi.api.SignatureLibrary;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import org.graalvm.collections.Pair;

public final class PythonCextBuiltins {
    private static final TruffleLogger LOGGER = CApiContext.getLogger(PythonCextBuiltins.class);
    private static final int TRACE_MEM = 1;
    private static final int LOG_INFO = 2;
    private static final int LOG_CONFIG = 4;
    private static final int LOG_FINE = 8;
    private static final int LOG_FINER = 16;
    private static final int LOG_FINEST = 32;
    private static final int DEBUG_CAPI = 64;
    private static final int PYTHON_GC = 128;

    public static PException checkThrowableBeforeNative(Throwable t, String where1, Object where2) {
        if (t instanceof PException) {
            PException pe = (PException)((Object)t);
            throw pe;
        }
        if (t instanceof ThreadDeath) {
            ThreadDeath td = (ThreadDeath)t;
            throw td;
        }
        if (t instanceof StackOverflowError) {
            StackOverflowError soe = (StackOverflowError)t;
            CompilerDirectives.transferToInterpreter();
            PythonContext context = PythonContext.get(null);
            context.ensureGilAfterFailure();
            PBaseException newException = PFactory.createBaseException(context.getLanguage(), PythonBuiltinClassType.RecursionError, ErrorMessages.MAXIMUM_RECURSION_DEPTH_EXCEEDED, PythonUtils.EMPTY_OBJECT_ARRAY);
            throw ExceptionUtils.wrapJavaException(soe, null, newException);
        }
        if (t instanceof OutOfMemoryError) {
            OutOfMemoryError oome = (OutOfMemoryError)t;
            CompilerDirectives.transferToInterpreter();
            PBaseException newException = PFactory.createBaseException(PythonLanguage.get(null), PythonBuiltinClassType.MemoryError);
            throw ExceptionUtils.wrapJavaException(oome, null, newException);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        PNodeWithContext.printStack();
        PythonContext context = PythonContext.get(null);
        PrintStream out = context != null ? new PrintStream(context.getEnv().err()) : System.err;
        out.println("should not throw exceptions apart from PException");
        out.println("while executing " + where1 + " " + String.valueOf(where2));
        ExceptionUtils.printPythonLikeStackTrace(new PrintWriter(out), t);
        t.printStackTrace(out);
        if (context == null) {
            out.println("ERROR: Native API called without Truffle context. This can happen when called from C-level atexit, C++ global destructor or an unregistered native thread");
        }
        out.flush();
        throw PRaiseNode.raiseStatic(null, PythonBuiltinClassType.SystemError, ErrorMessages.INTERNAL_EXCEPTION_OCCURED);
    }

    static abstract class GraalPyPrivate_GetMMapData
    extends CApiUnaryBuiltinNode {
        GraalPyPrivate_GetMMapData() {
        }

        @Specialization
        Object get(PMMap object, @Bind Node inliningTarget, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib, @Cached PConstructAndRaiseNode.Lazy raiseNode) {
            try {
                return posixLib.mmapGetPointer(this.getPosixSupport(), object.getPosixSupportHandle());
            }
            catch (PosixSupportLibrary.UnsupportedPosixFeatureException e) {
                throw raiseNode.get(inliningTarget).raiseOSErrorUnsupported(null, e);
            }
        }
    }

    static abstract class GraalPyPrivate_InitBuiltinTypesAndStructs
    extends CApiUnaryBuiltinNode {
        GraalPyPrivate_InitBuiltinTypesAndStructs() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object doGeneric(Object builtinTypesArrayPointer) {
            LinkedList<Pair> builtinTypes = new LinkedList<Pair>();
            PythonContext context = this.getContext();
            CStructAccess.ReadPointerNode readPointerNode = CStructAccess.ReadPointerNode.getUncached();
            try {
                InteropLibrary lib = null;
                int i = 0;
                while (true) {
                    Object typeStructPtr = readPointerNode.readArrayElement(builtinTypesArrayPointer, i);
                    if (lib == null || !lib.accepts(typeStructPtr)) {
                        lib = InteropLibrary.getUncached((Object)typeStructPtr);
                    }
                    if (lib.isNull(typeStructPtr)) break;
                    Object namePtr = readPointerNode.readArrayElement(builtinTypesArrayPointer, i + 1);
                    TruffleString name = CExtNodesFactory.FromCharPointerNodeGen.getUncached().execute(namePtr, false);
                    PythonManagedClass clazz = GraalPyPrivate_InitBuiltinTypesAndStructs.lookupBuiltinTypeWithName(context, name);
                    LOGGER.fine(() -> "setting type store for built-in class " + String.valueOf(name) + " to " + PythonUtils.formatPointer(typeStructPtr));
                    PythonClassNativeWrapper.wrapNative(clazz, TypeNodes.GetNameNode.executeUncached(clazz), typeStructPtr);
                    builtinTypes.add(Pair.create((Object)clazz, (Object)typeStructPtr));
                    i += 2;
                }
                for (Pair pair : builtinTypes) {
                    LOGGER.fine(() -> "initializing built-in class " + String.valueOf(TypeNodes.GetNameNode.executeUncached(pair.getLeft())));
                    PythonClassNativeWrapper.initNative((PythonManagedClass)pair.getLeft(), pair.getRight());
                }
                return PNone.NO_VALUE;
            }
            catch (PException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)((Object)e));
            }
        }

        private static PythonManagedClass lookupBuiltinTypeWithName(PythonContext context, TruffleString tsName) {
            Python3Core core = context.getCore();
            PythonManagedClass clazz = null;
            String name = tsName.toJavaStringUncached();
            int index = name.indexOf(46);
            if (index == -1) {
                for (PythonBuiltinClassType type : PythonBuiltinClassType.VALUES) {
                    if (!type.getName().equalsUncached((AbstractTruffleString)tsName, PythonUtils.TS_ENCODING)) continue;
                    clazz = core.lookupType(type);
                    break;
                }
            } else {
                Object attribute;
                String module = name.substring(0, index);
                name = name.substring(index + 1);
                PythonModule moduleObject = core.lookupBuiltinModule(PythonUtils.toTruffleStringUncached(module));
                if (moduleObject == null) {
                    moduleObject = AbstractImportNode.importModule(PythonUtils.toTruffleStringUncached(module));
                }
                if ((attribute = PyObjectGetAttr.getUncached().execute(null, moduleObject, PythonUtils.toTruffleStringUncached(name))) != PNone.NO_VALUE) {
                    if (attribute instanceof PythonBuiltinClassType) {
                        PythonBuiltinClassType builtinType = (PythonBuiltinClassType)((Object)attribute);
                        clazz = core.lookupType(builtinType);
                    } else {
                        clazz = (PythonManagedClass)attribute;
                    }
                }
            }
            if (clazz == null) {
                throw CompilerDirectives.shouldNotReachHere((String)("cannot find class " + name));
            }
            return clazz;
        }
    }

    static abstract class GraalPyPrivate_ToNative
    extends CApiUnaryBuiltinNode {
        GraalPyPrivate_ToNative() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int doIt(Object object) {
            if (!((Boolean)PythonOptions.EnableDebuggingBuiltins.getValue(this.getContext().getEnv().getOptions())).booleanValue()) {
                String message = "GraalPyPrivate_ToNative is not enabled - enable with --python.EnableDebuggingBuiltins\n";
                try {
                    this.getContext().getEnv().out().write(message.getBytes());
                }
                catch (IOException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                return 1;
            }
            InteropLibrary.getUncached().toNative(object);
            return 0;
        }
    }

    static abstract class GraalPyPrivate_Debug
    extends CApiUnaryBuiltinNode {
        GraalPyPrivate_Debug() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doIt(Object arg, @Cached GraalPythonModuleBuiltins.DebugNode debugNode) {
            debugNode.execute(new Object[]{arg});
            return 0;
        }
    }

    static abstract class GraalPyPrivate_DebugTrace
    extends CApiNullaryBuiltinNode {
        GraalPyPrivate_DebugTrace() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object trace() {
            final PrintStream out = new PrintStream(this.getContext().getEnv().out());
            if (this.getContext().getOption(PythonOptions.EnableDebuggingBuiltins).booleanValue()) {
                out.println("\n\nJava Stacktrace:");
                new RuntimeException().printStackTrace(out);
                out.println("\n\nTruffle Stacktrace:");
                GraalPyPrivate_DebugTrace.printStack();
                out.println("\n\nFrames:");
                Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<Void>(){
                    final /* synthetic */ GraalPyPrivate_DebugTrace this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Void visitFrame(FrameInstance frame) {
                        out.println("  ===========================");
                        out.println("  call: " + String.valueOf(frame.getCallNode()));
                        out.println("  target: " + String.valueOf(frame.getCallTarget()));
                        Frame f = frame.getFrame(FrameInstance.FrameAccess.READ_ONLY);
                        out.println("  args: " + String.valueOf(Arrays.asList(f.getArguments())));
                        return null;
                    }
                });
            } else {
                out.println("\n\nDEBUG TRACE (enable details via --python.EnableDebuggingBuiltins)");
            }
            return PNone.NO_VALUE;
        }
    }

    static abstract class GraalPyPrivate_LogString
    extends CApiBinaryBuiltinNode {
        GraalPyPrivate_LogString() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object log(int level, TruffleString message) {
            String msg = message.toJavaStringUncached();
            switch (level) {
                case 2: {
                    LOGGER.info(msg);
                    break;
                }
                case 4: {
                    LOGGER.config(msg);
                    break;
                }
                case 8: {
                    LOGGER.fine(msg);
                    break;
                }
                case 16: {
                    LOGGER.finer(msg);
                    break;
                }
                case 32: {
                    LOGGER.finest(msg);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere((String)("unknown log level: " + level));
                }
            }
            return PNone.NO_VALUE;
        }
    }

    static abstract class GraalPyPrivate_Native_Options
    extends CApiNullaryBuiltinNode {
        GraalPyPrivate_Native_Options() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        int getNativeOptions() {
            int options = 0;
            PythonLanguage language = PythonLanguage.get(null);
            if (language.getEngineOption(PythonOptions.TraceNativeMemory).booleanValue()) {
                options |= 1;
            }
            if (LOGGER.isLoggable(Level.INFO)) {
                options |= 2;
            }
            if (LOGGER.isLoggable(Level.CONFIG)) {
                options |= 4;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                options |= 8;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                options |= 0x10;
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                options |= 0x20;
            }
            if (PythonContext.DEBUG_CAPI) {
                options |= 0x40;
            }
            if (language.getEngineOption(PythonOptions.PythonGC).booleanValue()) {
                options |= 0x80;
            }
            return options;
        }
    }

    static abstract class GraalPyPrivate_DisableReferneceQueuePolling
    extends CApiNullaryBuiltinNode {
        GraalPyPrivate_DisableReferneceQueuePolling() {
        }

        @Specialization
        static int doGeneric(@Bind Node inliningTarget) {
            assert (PythonLanguage.get(inliningTarget).getEngineOption(PythonOptions.PythonGC).booleanValue());
            CApiTransitions.HandleContext handleContext = PythonContext.get((Node)inliningTarget).nativeContext;
            return PInt.intValue(CApiTransitions.disableReferenceQueuePolling(handleContext));
        }
    }

    static abstract class GraalPyPrivate_EnableReferneceQueuePolling
    extends CApiNullaryBuiltinNode {
        GraalPyPrivate_EnableReferneceQueuePolling() {
        }

        @Specialization
        static Object doGeneric(@Bind Node inliningTarget) {
            assert (PythonLanguage.get(inliningTarget).getEngineOption(PythonOptions.PythonGC).booleanValue());
            CApiTransitions.HandleContext handleContext = PythonContext.get((Node)inliningTarget).nativeContext;
            CApiTransitions.enableReferenceQueuePolling(handleContext);
            return PNone.NO_VALUE;
        }
    }

    static abstract class GraalPyPrivate_IsReferencedFromManaged
    extends CApiUnaryBuiltinNode {
        GraalPyPrivate_IsReferencedFromManaged() {
        }

        @Specialization(guards={"isNativeAccessAllowed()"})
        static int doNative(Object pointer, @Bind Node inliningTarget, @Cached CExtCommonNodes.CoerceNativePointerToLongNode coerceToLongNode, @Cached CApiTransitions.GcNativePtrToPythonNode gcNativePtrToPythonNode) {
            assert (PythonContext.get(inliningTarget).isNativeAccessAllowed());
            assert (PythonLanguage.get(inliningTarget).getEngineOption(PythonOptions.PythonGC).booleanValue());
            long lPointer = coerceToLongNode.execute(inliningTarget, pointer);
            assert (!CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(lPointer));
            Object object = gcNativePtrToPythonNode.execute(inliningTarget, lPointer);
            return PInt.intValue(object != null);
        }

        @Specialization(guards={"!isNativeAccessAllowed()"})
        static Object doManaged(Object pointer) {
            return PInt.intValue(false);
        }
    }

    static abstract class GraalPyPrivate_Object_GC_EnsureWeak
    extends CApiUnaryBuiltinNode {
        GraalPyPrivate_Object_GC_EnsureWeak() {
        }

        @Specialization(guards={"isNativeAccessAllowed()"})
        static Object doNative(Object weakCandidates, @Bind Node inliningTarget, @Cached CExtCommonNodes.CoerceNativePointerToLongNode coerceToLongNode, @Cached CStructAccess.ReadI64Node readI64Node, @Cached CStructAccess.WriteLongNode writeLongNode, @Cached CApiTransitions.NativePtrToPythonWrapperNode nativePtrToPythonWrapperNode, @Cached CApiTransitions.UpdateStrongRefNode updateRefNode) {
            assert (PythonContext.get(inliningTarget).isNativeAccessAllowed());
            assert (PythonLanguage.get(inliningTarget).getEngineOption(PythonOptions.PythonGC).booleanValue());
            long head = coerceToLongNode.execute(inliningTarget, weakCandidates);
            assert (!CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(head));
            long gc = readI64Node.read(head, CFields.PyGC_Head___gc_next);
            assert ((gc & 1L) == 0L);
            while (gc != head) {
                assert ((gc & 1L) == 0L);
                long op = gc + (long)CStructs.PyGC_Head.size();
                PythonNativeWrapper wrapper = nativePtrToPythonWrapperNode.execute(inliningTarget, op, true);
                if (wrapper instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                    PythonNativeWrapper.PythonAbstractObjectNativeWrapper abstractObjectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)wrapper;
                    if (CApiContext.GC_LOGGER.isLoggable(Level.FINE)) {
                        CApiContext.GC_LOGGER.fine(PythonUtils.formatJString("Transitioning to weak reference to break a reference cycle for %s, refcount=%d", abstractObjectNativeWrapper.ref, abstractObjectNativeWrapper.getRefCount()));
                    }
                    updateRefNode.clearStrongRef(inliningTarget, abstractObjectNativeWrapper);
                }
                long gcUntagged = CApiTransitions.HandlePointerConverter.pointerToStub(gc);
                long nextTaggedWithMask = readI64Node.read(gcUntagged, CFields.PyGC_Head___gc_next);
                long next = nextTaggedWithMask & 0xFFFFFFFFFFFFFFFEL;
                assert (next == head || (nextTaggedWithMask & 1L) != 0L);
                writeLongNode.write(gcUntagged, CFields.PyGC_Head___gc_next, 0L);
                writeLongNode.write(gcUntagged, CFields.PyGC_Head___gc_prev, 0L);
                gc = next;
            }
            return PNone.NO_VALUE;
        }

        @Specialization(guards={"!isNativeAccessAllowed()"})
        static Object doNative(Object weakCandidates) {
            return PNone.NO_VALUE;
        }
    }

    static abstract class GraalPyPrivate_Object_ReplicateNativeReferences
    extends CApiTernaryBuiltinNode {
        private static final Level LEVEL = Level.FINER;

        GraalPyPrivate_Object_ReplicateNativeReferences() {
        }

        @Specialization(guards={"isNativeAccessAllowed()"})
        static Object doGeneric(Object pointer, Object listHead, int n, @Bind Node inliningTarget, @Cached CStructAccess.ReadObjectNode readObjectNode, @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached CExtCommonNodes.CoerceNativePointerToLongNode coerceNativePointerToLongNode, @Cached CApiTransitions.GcNativePtrToPythonNode gcNativePtrToPythonNode) {
            Object object;
            assert (PythonLanguage.get(inliningTarget).getEngineOption(PythonOptions.PythonGC).booleanValue());
            boolean loggable = CApiContext.GC_LOGGER.isLoggable(LEVEL);
            long lPointer = coerceNativePointerToLongNode.execute(inliningTarget, pointer);
            assert (lPointer != 0L);
            Object repr = object = gcNativePtrToPythonNode.execute(inliningTarget, lPointer);
            Object[] referents = null;
            if (object instanceof PythonAbstractNativeObject || object instanceof PythonModule || GraalPyPrivate_Object_ReplicateNativeReferences.isTupleWithNativeStorage(object) || GraalPyPrivate_Object_ReplicateNativeReferences.isListWithNativeStorage(object)) {
                Object[] oldReferents;
                referents = new Object[n];
                if (object instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject nativeObject = (PythonAbstractNativeObject)object;
                    if (loggable) {
                        repr = nativeObject.toStringWithContext();
                    }
                    oldReferents = nativeObject.getReplicatedNativeReferences();
                    nativeObject.setReplicatedNativeReferences(referents);
                } else if (object instanceof PythonModule) {
                    PythonModule module = (PythonModule)object;
                    oldReferents = module.getReplicatedNativeReferences();
                    module.setReplicatedNativeReferences(referents);
                } else {
                    assert (GraalPyPrivate_Object_ReplicateNativeReferences.isTupleWithNativeStorage(object) || GraalPyPrivate_Object_ReplicateNativeReferences.isListWithNativeStorage(object));
                    NativeSequenceStorage nativeSequenceStorage = GraalPyPrivate_Object_ReplicateNativeReferences.getNativeSequenceStorage(object);
                    oldReferents = nativeSequenceStorage.getReplicatedNativeReferences();
                    nativeSequenceStorage.setReplicatedNativeReferences(referents);
                }
                Object cur = listHead;
                for (int i = 0; i < n; ++i) {
                    referents[i] = readObjectNode.read(cur, CFields.GraalPyGC_CycleNode__item);
                    cur = readPointerNode.read(cur, CFields.GraalPyGC_CycleNode__next);
                }
                Reference.reachabilityFence(oldReferents);
                if (loggable) {
                    CApiContext.GC_LOGGER.log(LEVEL, PythonUtils.formatJString("Replicated native refs of %s to managed: %s", repr, GraalPyPrivate_Object_ReplicateNativeReferences.arraysToString(referents)));
                }
            } else if (object == null && loggable) {
                CApiContext.GC_LOGGER.log(LEVEL, PythonUtils.formatJString("Did not replicate native refs of %s: no wrapper", CApiContext.asHex(lPointer)));
            }
            return PNone.NO_VALUE;
        }

        private static NativeSequenceStorage getNativeSequenceStorage(Object object) {
            NativeSequenceStorage nativeSequenceStorage;
            if (object instanceof PTuple) {
                PTuple tuple = (PTuple)object;
                nativeSequenceStorage = (NativeSequenceStorage)tuple.getSequenceStorage();
            } else {
                assert (object instanceof PList);
                nativeSequenceStorage = (NativeSequenceStorage)((PList)object).getSequenceStorage();
            }
            return nativeSequenceStorage;
        }

        @Specialization(guards={"!isNativeAccessAllowed()"})
        static Object doManaged(Object pointer, Object listHead, int n) {
            return PNone.NO_VALUE;
        }

        @CompilerDirectives.TruffleBoundary
        private static String arraysToString(Object[] arr) {
            return Arrays.toString(arr);
        }

        private static boolean isTupleWithNativeStorage(Object object) {
            PTuple tuple;
            return object instanceof PTuple && (tuple = (PTuple)object).getSequenceStorage() instanceof NativeSequenceStorage;
        }

        private static boolean isListWithNativeStorage(Object object) {
            PList list;
            return object instanceof PList && (list = (PList)object).getSequenceStorage() instanceof NativeSequenceStorage;
        }
    }

    static abstract class GraalPyPrivate_Object_GC_Track
    extends GraalPyPrivate_GcTracingNode {
        GraalPyPrivate_Object_GC_Track() {
        }

        @Override
        protected void trace(PythonContext context, Object ptr, PFrame.Reference ref, TruffleString className) {
            CApiContext.GC_LOGGER.finer(() -> PythonUtils.formatJString("Tracking container object at %s", CApiContext.asHex(ptr)));
            context.getCApiContext().trackObject(ptr, ref, className);
        }
    }

    static abstract class GraalPyPrivate_Object_GC_UnTrack
    extends GraalPyPrivate_GcTracingNode {
        GraalPyPrivate_Object_GC_UnTrack() {
        }

        @Override
        protected void trace(PythonContext context, Object ptr, PFrame.Reference ref, TruffleString className) {
            CApiContext.GC_LOGGER.finer(() -> PythonUtils.formatJString("Untracking container object at %s", CApiContext.asHex(ptr)));
            context.getCApiContext().untrackObject(ptr, ref, className);
        }
    }

    @GenerateCached(value=false)
    static abstract class GraalPyPrivate_GcTracingNode
    extends CApiUnaryBuiltinNode {
        GraalPyPrivate_GcTracingNode() {
        }

        @Specialization(guards={"!traceMem(language)"})
        static Object doNothing(Object ptr, @Bind PythonLanguage language) {
            return PNone.NO_VALUE;
        }

        @Fallback
        Object doNativeWrapper(Object ptr, @Bind Node inliningTarget, @Bind PythonContext context, @Cached GetCurrentFrameRef getCurrentFrameRef, @CachedLibrary(limit="3") InteropLibrary lib) {
            PFrame.Reference ref = null;
            if (context.getOption(PythonOptions.TraceNativeMemoryCalls).booleanValue()) {
                ref = getCurrentFrameRef.execute(null, inliningTarget);
            }
            this.trace(context, CApiContext.asPointer(ptr, lib), ref, null);
            return PNone.NO_VALUE;
        }

        @Idempotent
        boolean traceMem(PythonLanguage language) {
            return language.getEngineOption(PythonOptions.TraceNativeMemory);
        }

        protected abstract void trace(PythonContext var1, Object var2, PFrame.Reference var3, TruffleString var4);
    }

    static abstract class GraalPyPrivate_TraceMalloc_Untrack
    extends CApiBinaryBuiltinNode {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(GraalPyPrivate_TraceMalloc_Untrack.class);

        GraalPyPrivate_TraceMalloc_Untrack() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doCachedDomainIdx(int domain, long ptrVal) {
            LOGGER.fine(() -> PythonUtils.formatJString("Untracking memory (domain: %d): %s", domain, CApiContext.asHex(ptrVal)));
            return PNone.NO_VALUE;
        }
    }

    static abstract class GraalPyPrivate_TraceMalloc_Track
    extends CApiTernaryBuiltinNode {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(GraalPyPrivate_TraceMalloc_Track.class);

        GraalPyPrivate_TraceMalloc_Track() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doCachedDomainIdx(int domain, long ptrVal, long size) {
            if (ptrVal != 0L) {
                LOGGER.fine(() -> PythonUtils.formatJString("Tracking memory (domain: %d, size: %d): %s", domain, size, CApiContext.asHex(ptrVal)));
            }
            return PNone.NO_VALUE;
        }
    }

    static abstract class GraalPyPrivate_ManagedObject_GC_Del
    extends CApiUnaryBuiltinNode {
        GraalPyPrivate_ManagedObject_GC_Del() {
        }

        @Specialization(limit="3")
        static PNone doObject(Object ptr, @Bind Node inliningTarget, @Cached CApiGCSupport.PyObjectGCDelNode pyObjectGCDelNode, @CachedLibrary(value="ptr") InteropLibrary lib) {
            assert (CApiTransitions.isBackendPointerObject(ptr));
            if (lib.isPointer(ptr)) {
                try {
                    pyObjectGCDelNode.execute(inliningTarget, lib.asPointer(ptr));
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return PNone.NO_VALUE;
        }
    }

    static abstract class GraalPyPrivate_TriggerGC
    extends CApiUnaryBuiltinNode {
        GraalPyPrivate_TriggerGC() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object trigger(long delay) {
            LOGGER.fine("full GC due to native memory");
            PythonUtils.forceFullGC();
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
            }
            CApiTransitions.pollReferenceQueue();
            PythonContext.triggerAsyncActions(this);
            return PNone.NO_VALUE;
        }
    }

    static abstract class GraalPyPrivate_GetInitialNativeMemory
    extends CApiNullaryBuiltinNode {
        GraalPyPrivate_GetInitialNativeMemory() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        long get() {
            return (Long)PythonOptions.InitialNativeMemory.getValue(this.getContext().getEnv().getOptions());
        }
    }

    static abstract class GraalPyPrivate_GetMaxNativeMemory
    extends CApiNullaryBuiltinNode {
        GraalPyPrivate_GetMaxNativeMemory() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        long get() {
            return (Long)PythonOptions.MaxNativeMemory.getValue(this.getContext().getEnv().getOptions());
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ReportPolymorphism
    static abstract class CastKwargsNode
    extends PNodeWithContext {
        CastKwargsNode() {
        }

        public abstract PKeyword[] execute(Node var1, Object var2);

        @Specialization(guards={"isNoValue(kwargs)"})
        static PKeyword[] doNoKeywords(Object kwargs) {
            return PKeyword.EMPTY_KEYWORDS;
        }

        @Specialization(guards={"!isNoValue(kwargs)"})
        static PKeyword[] doKeywords(Node inliningTarget, Object kwargs, @Cached ExpandKeywordStarargsNode expandKwargsNode) {
            return expandKwargsNode.execute(inliningTarget, kwargs);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ReportPolymorphism
    static abstract class CastArgsNode
    extends PNodeWithContext {
        CastArgsNode() {
        }

        public abstract Object[] execute(VirtualFrame var1, Node var2, Object var3);

        @Specialization(guards={"isNoValue(args)"})
        static Object[] doNull(PNone args) {
            return PythonUtils.EMPTY_OBJECT_ARRAY;
        }

        @Specialization(guards={"!isNoValue(args)"})
        static Object[] doNotNull(VirtualFrame frame, Object args, @Cached(inline=false) ExecutePositionalStarargsNode expandArgsNode) {
            return expandArgsNode.executeWith((Frame)frame, args);
        }
    }

    static abstract class GraalPyPrivate_MemoryViewFromBuffer
    extends CApi11BuiltinNode {
        GraalPyPrivate_MemoryViewFromBuffer() {
        }

        @Specialization
        static Object wrap(Object bufferStructPointer, Object ownerObj, long lenObj, Object readonlyObj, Object itemsizeObj, TruffleString format, Object ndimObj, Object bufPointer, Object shapePointer, Object stridesPointer, Object suboffsetsPointer, @Bind Node inliningTarget, @Cached InlinedConditionProfile zeroDimProfile, @Cached CStructAccess.ReadI64Node readShapeNode, @Cached CStructAccess.ReadI64Node readStridesNode, @Cached CStructAccess.ReadI64Node readSuboffsetsNode, @Cached MemoryViewNodes.InitFlagsNode initFlagsNode, @CachedLibrary(limit="2") InteropLibrary lib, @Cached CastToJavaIntExactNode castToIntNode, @Cached TruffleString.CodePointLengthNode lengthNode, @Cached TruffleString.CodePointAtIndexNode atIndexNode, @Bind PythonLanguage language) {
            int ndim = castToIntNode.execute(inliningTarget, ndimObj);
            int itemsize = castToIntNode.execute(inliningTarget, itemsizeObj);
            int len = castToIntNode.execute(inliningTarget, lenObj);
            boolean readonly = castToIntNode.execute(inliningTarget, readonlyObj) != 0;
            Object owner = PGuards.isNullOrZero(ownerObj, lib) ? null : ownerObj;
            int[] shape = null;
            int[] strides = null;
            int[] suboffsets = null;
            if (zeroDimProfile.profile(inliningTarget, ndim > 0)) {
                if (!lib.isNull(shapePointer)) {
                    shape = readShapeNode.readLongAsIntArray(shapePointer, ndim);
                } else {
                    assert (ndim == 1);
                    shape = new int[]{len / itemsize};
                }
                strides = !lib.isNull(stridesPointer) ? readStridesNode.readLongAsIntArray(stridesPointer, ndim) : PMemoryView.initStridesFromShape(ndim, itemsize, shape);
                if (!lib.isNull(suboffsetsPointer)) {
                    suboffsets = readSuboffsetsNode.readLongAsIntArray(suboffsetsPointer, ndim);
                }
            }
            NativeByteSequenceStorage buffer = NativeByteSequenceStorage.create(bufPointer, len, len, false);
            int flags = initFlagsNode.execute(inliningTarget, ndim, itemsize, shape, strides, suboffsets);
            NativeBufferLifecycleManager.NativeBufferLifecycleManagerFromType bufferLifecycleManager = null;
            if (!lib.isNull(bufferStructPointer)) {
                bufferLifecycleManager = new NativeBufferLifecycleManager.NativeBufferLifecycleManagerFromType(bufferStructPointer);
            }
            return PFactory.createMemoryView(language, PythonContext.get(inliningTarget), bufferLifecycleManager, buffer, owner, len, readonly, itemsize, BufferFormat.forMemoryView(format, lengthNode, atIndexNode), format, ndim, bufPointer, 0, shape, strides, suboffsets, flags);
        }
    }

    static abstract class PyFrame_New
    extends CApiQuaternaryBuiltinNode {
        PyFrame_New() {
        }

        @Specialization
        static Object newFrame(Object threadState, PCode code, PythonObject globals, Object locals, @Bind PythonLanguage language) {
            Object frameLocals = locals == null || PGuards.isPNone(locals) ? PFactory.createDict(language) : locals;
            return PFactory.createPFrame(language, threadState, code, globals, frameLocals);
        }
    }

    static abstract class GraalPyPrivate_AddInheritedSlots
    extends CApiUnaryBuiltinNode {
        private static final int INDEX_GETSETS = 0;
        private static final int INDEX_MEMBERS = 1;

        GraalPyPrivate_AddInheritedSlots() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static Object addInheritedSlots(PythonAbstractNativeObject pythonClass, @Bind Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary lib, @Cached CStructAccess.ReadObjectNode readNativeDict, @Cached CStructAccess.ReadPointerNode readPointer, @Cached CStructAccess.ReadI32Node readI32, @Cached CStructAccess.ReadI64Node readI64, @Cached CExtNodes.FromCharPointerNode fromCharPointer, @Cached PythonCextTypeBuiltins.GraalPyPrivate_Type_AddGetSet addGetSet, @Cached PythonCextTypeBuiltins.GraalPyPrivate_Type_AddMember addMember, @Cached TypeNodes.GetMroStorageNode getMroStorageNode) {
            TruffleString name;
            Object namePtr;
            int i;
            pythonClass.setTpSlots(TpSlots.fromNative(pythonClass, GraalPyPrivate_AddInheritedSlots.getCApiContext(inliningTarget).getContext()));
            Object[] getsets = GraalPyPrivate_AddInheritedSlots.collect(getMroStorageNode.execute(inliningTarget, pythonClass), 0);
            Object[] members = GraalPyPrivate_AddInheritedSlots.collect(getMroStorageNode.execute(inliningTarget, pythonClass), 1);
            PDict dict = (PDict)readNativeDict.readFromObj(pythonClass, CFields.PyTypeObject__tp_dict);
            for (Object getset : getsets) {
                if (PGuards.isNullOrZero(getset, lib)) continue;
                i = 0;
                while (!PGuards.isNullOrZero(namePtr = readPointer.readStructArrayElement(getset, i, CFields.PyGetSetDef__name), lib)) {
                    name = fromCharPointer.execute(namePtr);
                    Object getter = readPointer.readStructArrayElement(getset, i, CFields.PyGetSetDef__get);
                    Object setter = readPointer.readStructArrayElement(getset, i, CFields.PyGetSetDef__set);
                    Object docPtr = readPointer.readStructArrayElement(getset, i, CFields.PyGetSetDef__doc);
                    PNone doc = PGuards.isNullOrZero(docPtr, lib) ? PNone.NO_VALUE : fromCharPointer.execute(docPtr);
                    Object closure = readPointer.readStructArrayElement(getset, i, CFields.PyGetSetDef__closure);
                    addGetSet.execute(pythonClass, dict, name, getter, setter, doc, closure);
                    ++i;
                }
            }
            for (Object member : members) {
                if (PGuards.isNullOrZero(member, lib)) continue;
                i = 0;
                while (!PGuards.isNullOrZero(namePtr = readPointer.readStructArrayElement(member, i, CFields.PyMemberDef__name), lib)) {
                    name = fromCharPointer.execute(namePtr);
                    int type = readI32.readStructArrayElement(member, i, CFields.PyMemberDef__type);
                    long offset = readI64.readStructArrayElement(member, i, CFields.PyMemberDef__offset);
                    int flags = readI32.readStructArrayElement(member, i, CFields.PyMemberDef__flags);
                    Object docPtr = readPointer.readStructArrayElement(member, i, CFields.PyMemberDef__doc);
                    PNone doc = PGuards.isNullOrZero(docPtr, lib) ? PNone.NO_VALUE : fromCharPointer.execute(docPtr);
                    boolean canSet = (flags & CConstants.READONLY.intValue()) == 0;
                    addMember.execute(pythonClass, dict, name, type, offset, canSet ? 1 : 0, doc);
                    ++i;
                }
            }
            return PNone.NO_VALUE;
        }

        @CompilerDirectives.TruffleBoundary
        private static Object[] collect(MroSequenceStorage mro, int idx) {
            ArrayList<Object> l = new ArrayList<Object>();
            int mroLength = mro.length();
            for (int i = 0; i < mroLength; ++i) {
                PythonAbstractClass kls = mro.getPythonClassItemNormalized(i);
                Object value = HiddenAttr.ReadNode.executeUncached((PythonAbstractObject)((Object)kls), HiddenAttr.NATIVE_SLOTS, null);
                if (value == null) continue;
                Object[] tuple = (Object[])value;
                assert (tuple.length == 2);
                l.add(tuple[idx]);
            }
            return l.toArray();
        }
    }

    static abstract class GraalPyPrivate_Set_Native_Slots
    extends CApiTernaryBuiltinNode {
        GraalPyPrivate_Set_Native_Slots() {
        }

        @Specialization
        static int doPythonClass(PythonClass pythonClass, Object nativeGetSets, Object nativeMembers, @Bind Node inliningTarget, @Cached HiddenAttr.WriteNode writeAttrNode) {
            writeAttrNode.execute(inliningTarget, pythonClass, HiddenAttr.NATIVE_SLOTS, new Object[]{nativeGetSets, nativeMembers});
            return 0;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class PyObjectSetAttrNode
    extends PNodeWithContext {
        PyObjectSetAttrNode() {
        }

        abstract void execute(Node var1, Object var2, TruffleString var3, Object var4);

        @Specialization
        static void doBuiltinClass(PythonBuiltinClass object, TruffleString key, Object value, @Cached.Exclusive @Cached(value="createForceType()", inline=false) WriteAttributeToObjectNode writeAttrNode) {
            writeAttrNode.execute(object, key, value);
        }

        @Specialization
        static void doNativeClass(PythonNativeClass object, TruffleString key, Object value, @Cached.Exclusive @Cached(value="createForceType()", inline=false) WriteAttributeToObjectNode writeAttrNode) {
            writeAttrNode.execute(object, key, value);
        }

        @Specialization(guards={"!isPythonBuiltinClass(object)"})
        static void doObject(PythonObject object, TruffleString key, Object value, @Cached.Exclusive @Cached(inline=false) WriteAttributeToPythonObjectNode writeAttrToPythonObjectNode) {
            writeAttrToPythonObjectNode.execute(object, key, value);
        }
    }

    static abstract class GraalPyPrivate_Type
    extends CApiUnaryBuiltinNode {
        private static final TruffleString[] LOOKUP_MODULES = new TruffleString[]{BuiltinNames.T__WEAKREF, BuiltinNames.T_BUILTINS};

        GraalPyPrivate_Type() {
        }

        @Specialization
        static Object doI(TruffleString typeName, @Bind Node inliningTarget, @Cached TruffleString.EqualNode eqNode, @Cached PRaiseNode raiseNode) {
            PythonContext core = PythonContext.get(inliningTarget);
            for (PythonBuiltinClassType pythonBuiltinClassType : PythonBuiltinClassType.VALUES) {
                if (!eqNode.execute((AbstractTruffleString)pythonBuiltinClassType.getName(), (AbstractTruffleString)typeName, PythonUtils.TS_ENCODING)) continue;
                return core.lookupType(pythonBuiltinClassType);
            }
            for (PythonBuiltinClassType pythonBuiltinClassType : LOOKUP_MODULES) {
                Object attribute = core.lookupBuiltinModule((TruffleString)pythonBuiltinClassType).getAttribute(typeName);
                if (attribute == PNone.NO_VALUE) continue;
                return attribute;
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.KeyError, ErrorMessages.APOSTROPHE_S, typeName);
        }
    }

    static abstract class GraalPyPrivate_FileSystemDefaultEncoding
    extends CApiNullaryBuiltinNode {
        GraalPyPrivate_FileSystemDefaultEncoding() {
        }

        @Specialization
        static TruffleString encoding() {
            return SysModuleBuiltins.GetFileSystemEncodingNode.getFileSystemEncoding();
        }
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.SOURCE)
    @Repeatable(value=CApiBuiltins.class)
    public static @interface CApiBuiltin {
        public String name() default "";

        public ArgDescriptor ret();

        public ArgDescriptor[] args() default {};

        public boolean inlined() default false;

        public boolean acquireGil() default true;

        public CApiCallPath call();

        public String comment() default "";
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CApiBuiltins {
        public CApiBuiltin[] value();
    }

    public static enum CApiCallPath {
        Direct,
        CImpl,
        NotImplemented,
        Ignored;

    }

    static final class UncachedExecuteCApiBuiltinNode
    extends ExecuteCApiBuiltinNode {
        static final UncachedExecuteCApiBuiltinNode INSTANCE = new UncachedExecuteCApiBuiltinNode();

        UncachedExecuteCApiBuiltinNode() {
        }

        public boolean isAdoptable() {
            return false;
        }

        @Override
        Object execute(CApiBuiltinExecutable self, Object[] arguments) {
            return IndirectCallNode.getUncached().call(self.getCallTarget(), arguments);
        }
    }

    static final class CachedExecuteCApiBuiltinNode
    extends ExecuteCApiBuiltinNode {
        private final CApiBuiltinExecutable cachedSelf;
        @Node.Child
        private GilNode gilNode = GilNode.create();
        @Node.Child
        private CExtToNativeNode retNode;
        @Node.Children
        private final CExtToJavaNode[] argNodes;
        @Node.Child
        private CApiBuiltinNode builtinNode;
        @Node.Child
        private CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode;

        CachedExecuteCApiBuiltinNode(CApiBuiltinExecutable cachedSelf) {
            assert (cachedSelf.ret.createCheckResultNode() == null) : "primitive result check types are only intended for ExternalFunctionInvokeNode";
            this.cachedSelf = cachedSelf;
            this.retNode = cachedSelf.createRetNode();
            this.argNodes = cachedSelf.createArgNodes();
            this.builtinNode = cachedSelf.createBuiltinNode();
        }

        @Override
        Object execute(CApiBuiltinExecutable self, Object[] arguments) {
            boolean wasAcquired = self.acquireGil() && this.gilNode.acquire();
            CApiTiming.enter();
            try {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(() -> "CAPI-" + self.name + " " + Arrays.toString(arguments));
                }
                assert (this.cachedSelf == self);
                assert (arguments.length == this.argNodes.length);
                Object[] argCast = new Object[this.argNodes.length];
                this.castArguments(arguments, argCast);
                Object result = this.builtinNode.execute(argCast);
                if (this.retNode != null) {
                    result = this.retNode.execute(result);
                }
                CApiTransitions.maybeGCALot();
                Object object = result;
                return object;
            }
            catch (Throwable t) {
                try {
                    throw PythonCextBuiltins.checkThrowableBeforeNative(t, "CApiBuiltin", self.name);
                }
                catch (PException e) {
                    if (this.transformExceptionToNativeNode == null) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.transformExceptionToNativeNode = (CExtCommonNodes.TransformExceptionToNativeNode)this.insert(CExtCommonNodesFactory.TransformExceptionToNativeNodeGen.create());
                    }
                    this.transformExceptionToNativeNode.executeCached(e);
                    if (this.cachedSelf.getRetDescriptor().isIntType()) {
                        Integer n = -1;
                        return n;
                    }
                    if (this.cachedSelf.getRetDescriptor().isPyObjectOrPointer()) {
                        NativePointer nativePointer = PythonContext.get(this).getNativeNull();
                        return nativePointer;
                    }
                    if (this.cachedSelf.getRetDescriptor().isFloatType()) {
                        Double d = -1.0;
                        return d;
                    }
                    if (this.cachedSelf.getRetDescriptor().isVoid()) {
                        PNone pNone = PNone.NO_VALUE;
                        return pNone;
                    }
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("return type while handling PException: " + String.valueOf((Object)this.cachedSelf.getRetDescriptor()) + " in " + self.name));
                }
            }
            finally {
                this.gilNode.release(wasAcquired);
                CApiTiming.exit(self.timing);
            }
        }

        @ExplodeLoop
        private void castArguments(Object[] arguments, Object[] argCast) {
            for (int i = 0; i < this.argNodes.length; ++i) {
                argCast[i] = this.argNodes[i] == null ? arguments[i] : this.argNodes[i].execute(arguments[i]);
            }
        }
    }

    @GenerateUncached
    static abstract class ExecuteCApiBuiltinNode
    extends Node {
        ExecuteCApiBuiltinNode() {
        }

        abstract Object execute(CApiBuiltinExecutable var1, Object[] var2);

        public static ExecuteCApiBuiltinNode create(CApiBuiltinExecutable self) {
            try {
                return new CachedExecuteCApiBuiltinNode(self);
            }
            catch (Throwable t) {
                PNodeWithContext.printStack();
                LOGGER.logp(Level.SEVERE, "ExecuteCApiBuiltinNode", "create", "while creating CApiBuiltin " + self.name, t);
                throw t;
            }
        }

        public static ExecuteCApiBuiltinNode getUncached(CApiBuiltinExecutable self) {
            return UncachedExecuteCApiBuiltinNode.INSTANCE;
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static final class CApiBuiltinExecutable
    implements TruffleObject {
        private final CApiTiming timing;
        private final ArgDescriptor ret;
        private final ArgDescriptor[] args;
        private final boolean acquireGil;
        @CompilerDirectives.CompilationFinal
        private CallTarget callTarget;
        private final CApiCallPath call;
        private final String name;
        private final int id;

        public CApiBuiltinExecutable(String name, CApiCallPath call, ArgDescriptor ret, ArgDescriptor[] args, boolean acquireGil, int id) {
            this.timing = CApiTiming.create(false, name);
            this.name = name;
            this.call = call;
            this.ret = ret;
            this.args = args;
            this.acquireGil = acquireGil;
            this.id = id;
        }

        CallTarget getCallTarget() {
            if (this.callTarget == null) {
                throw CompilerDirectives.shouldNotReachHere((String)"call target slow path not implemented");
            }
            return this.callTarget;
        }

        @ExportMessage
        public boolean isExecutable() {
            return true;
        }

        public CApiCallPath call() {
            return this.call;
        }

        public String name() {
            return this.name;
        }

        public boolean acquireGil() {
            return this.acquireGil;
        }

        CExtToNativeNode createRetNode() {
            return this.ret.createPythonToNativeNode();
        }

        ArgDescriptor getRetDescriptor() {
            return this.ret;
        }

        CExtToJavaNode[] createArgNodes() {
            return ArgDescriptor.createNativeToPython(this.args);
        }

        public CApiBuiltinNode createBuiltinNode() {
            CApiBuiltinNode node = PythonCextBuiltinRegistry.createBuiltinNode(this.id);
            node.ret = this.ret;
            return node;
        }

        public CApiBuiltinNode getUncachedNode() {
            throw CompilerDirectives.shouldNotReachHere((String)("not supported - uncached for " + this.name));
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        boolean isPointer() {
            long pointer = PythonContext.get(null).getCApiContext().getClosurePointer(this);
            return pointer != -1L;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        long asPointer() throws UnsupportedMessageException {
            long pointer = PythonContext.get(null).getCApiContext().getClosurePointer(this);
            if (pointer == -1L) {
                throw UnsupportedMessageException.create();
            }
            return pointer;
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        void toNative() {
            PythonContext context = PythonContext.get(null);
            long pointer = context.getCApiContext().getClosurePointer(this);
            if (pointer == -1L) {
                if (context.signatureContainer == null) {
                    context.signatureContainer = new SignatureContainerRootNode().getCallTarget();
                }
                try {
                    SignatureContainerRootNode container = (SignatureContainerRootNode)context.signatureContainer.getRootNode();
                    boolean panama = (Boolean)PythonOptions.UsePanama.getValue(context.getEnv().getOptions());
                    StringBuilder signature = new StringBuilder(panama ? "with panama (" : "(");
                    for (int i = 0; i < this.args.length; ++i) {
                        signature.append(i == 0 ? "" : ",");
                        signature.append(this.args[i].getNFISignature());
                    }
                    signature.append("):").append(this.ret.getNFISignature());
                    Object nfiSignature = context.getEnv().parseInternal(Source.newBuilder((String)"nfi", (CharSequence)signature.toString(), (String)"exec").build(), new String[0]).call(new Object[0]);
                    Object closure = container.getLibrary(this.name).createClosure(nfiSignature, (Object)this);
                    InteropLibrary lib = InteropLibrary.getUncached((Object)closure);
                    lib.toNative(closure);
                    try {
                        pointer = lib.asPointer(closure);
                    }
                    catch (UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                    }
                    context.getCApiContext().setClosurePointer(closure, null, this, pointer);
                    LOGGER.finer(CApiBuiltinExecutable.class.getSimpleName() + " toNative: " + this.id + " / " + this.name() + " -> " + pointer);
                }
                catch (Throwable t) {
                    t.printStackTrace(new PrintStream(context.getEnv().err()));
                    throw t;
                }
            }
        }

        public String toString() {
            return "CApiBuiltin(" + this.name + " / " + this.id + ")";
        }

        private static final class SignatureContainerRootNode
        extends RootNode {
            final HashMap<String, SignatureLibrary> libs = new HashMap();

            protected SignatureContainerRootNode() {
                super(null);
            }

            public Object execute(VirtualFrame frame) {
                throw CompilerDirectives.shouldNotReachHere((String)"not meant to be executed");
            }

            public SignatureLibrary getLibrary(String name) {
                return this.libs.computeIfAbsent(name, n -> {
                    SignatureLibrary lib = (SignatureLibrary)SignatureLibrary.getFactory().createDispatched(3);
                    this.insert((Node)lib);
                    return lib;
                });
            }
        }

        @ExportMessage
        static final class Execute {
            Execute() {
            }

            @Specialization(guards={"self == cachedSelf"}, limit="3")
            public static Object doExecute(CApiBuiltinExecutable self, Object[] arguments, @Cached(value="self") CApiBuiltinExecutable cachedSelf, @Cached(parameters={"cachedSelf"}) ExecuteCApiBuiltinNode call) {
                try {
                    return call.execute(cachedSelf, arguments);
                }
                catch (ThreadDeath t) {
                    CompilerDirectives.transferToInterpreter();
                    throw t;
                }
                catch (Throwable t) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    t.printStackTrace();
                    throw CompilerDirectives.shouldNotReachHere((Throwable)t);
                }
            }

            @Specialization
            public static Object doFallback(CApiBuiltinExecutable self, Object[] arguments) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)("shouldn't hit generic case of " + Execute.class.getName()));
            }
        }
    }

    public static abstract class CApi18BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, Object var10, Object var11, Object var12, Object var13, Object var14, Object var15, Object var16, Object var17, Object var18);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15], args[16], args[17]);
        }
    }

    public static abstract class CApi17BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, Object var10, Object var11, Object var12, Object var13, Object var14, Object var15, Object var16, Object var17);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15], args[16]);
        }
    }

    public static abstract class CApi16BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, Object var10, Object var11, Object var12, Object var13, Object var14, Object var15, Object var16);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14], args[15]);
        }
    }

    public static abstract class CApi15BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, Object var10, Object var11, Object var12, Object var13, Object var14, Object var15);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10], args[11], args[12], args[13], args[14]);
        }
    }

    public static abstract class CApi11BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, Object var10, Object var11);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9], args[10]);
        }
    }

    public static abstract class CApi10BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9, Object var10);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8], args[9]);
        }
    }

    public static abstract class CApi9BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8, Object var9);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7], args[8]);
        }
    }

    public static abstract class CApi8BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7, Object var8);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6], args[7]);
        }
    }

    public static abstract class CApi7BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6, Object var7);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
        }
    }

    public static abstract class CApi6BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5, Object var6);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4], args[5]);
        }
    }

    public static abstract class CApi5BuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4]);
        }
    }

    public static abstract class CApiQuaternaryBuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3]);
        }
    }

    public static abstract class CApiTernaryBuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2]);
        }
    }

    public static abstract class CApiBinaryBuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1, Object var2);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1]);
        }
    }

    public static abstract class CApiUnaryBuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute(Object var1);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0]);
        }
    }

    public static abstract class CApiNullaryBuiltinNode
    extends CApiBuiltinNode {
        public abstract Object execute();

        @Override
        public final Object execute(Object[] args) {
            return this.execute();
        }
    }

    public static abstract class CApiBuiltinNode
    extends PNodeWithContext {
        @CompilerDirectives.CompilationFinal
        private ArgDescriptor ret;

        public abstract Object execute(Object[] var1);

        protected final NativePointer getNativeNull() {
            return this.getContext().getNativeNull();
        }

        protected static NativePointer getNativeNull(Node inliningTarget) {
            return PythonContext.get(inliningTarget).getNativeNull();
        }

        protected final Object getNULL() {
            return this.getContext().getNativeNull();
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected static ByteBuffer wrap(byte[] data) {
            return ByteBuffer.wrap(data);
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        protected static ByteBuffer wrap(byte[] data, int offset, int length) {
            return ByteBuffer.wrap(data, offset, length);
        }

        public final Python3Core getCore() {
            return this.getContext();
        }

        protected static CApiContext getCApiContext(Node inliningTarget) {
            return PythonContext.get(inliningTarget).getCApiContext();
        }

        protected final CApiContext getCApiContext() {
            return this.getContext().getCApiContext();
        }

        protected final PException badInternalCall(String argName) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.SystemError, ErrorMessages.S_S_BAD_ARG_TO_INTERNAL_FUNC, this.getName(), argName);
        }

        @NonIdempotent
        protected final boolean isNativeAccessAllowed() {
            return this.getContext().isNativeAccessAllowed();
        }

        private String getName() {
            Class<?> c = ((Object)((Object)this)).getClass();
            while (c.getSimpleName().endsWith("NodeGen")) {
                c = c.getSuperclass();
            }
            String name = c.getSimpleName();
            return name;
        }

        @CompilerDirectives.TruffleBoundary
        protected PException raiseFallback(Object obj, PythonBuiltinClassType type) {
            if (obj == PNone.NO_VALUE) {
                throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC_S, this.getName());
            }
            if (IsSubtypeNode.getUncached().execute(GetClassNode.executeUncached(obj), (Object)type)) {
                throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.NotImplementedError, ErrorMessages.NATIVE_S_SUBTYPES_NOT_IMPLEMENTED, type.getName());
            }
            throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.SystemError, ErrorMessages.EXPECTED_S_NOT_P, type.getName(), obj);
        }

        @CompilerDirectives.TruffleBoundary
        protected PException raiseFallback(Object obj, PythonBuiltinClassType type1, PythonBuiltinClassType type2) {
            if (obj == PNone.NO_VALUE) {
                throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC_S, this.getName());
            }
            Object objType = GetClassNode.executeUncached(obj);
            if (IsSubtypeNode.getUncached().execute(objType, (Object)type1) || IsSubtypeNode.getUncached().execute(objType, (Object)type2)) {
                throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.NotImplementedError, ErrorMessages.NATIVE_S_SUBTYPES_NOT_IMPLEMENTED, type1.getName());
            }
            throw PRaiseNode.raiseStatic(this, PythonBuiltinClassType.SystemError, ErrorMessages.EXPECTED_S_NOT_P, type1.getName(), obj);
        }

        protected final ArgDescriptor getRetDescriptor() {
            return this.ret;
        }

        protected final int castToInt(long elementSize) {
            if (elementSize == (long)((int)elementSize)) {
                return (int)elementSize;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.SystemError, ErrorMessages.INDEX_OUT_OF_RANGE);
        }

        protected static void checkNonNullArg(Node inliningTarget, Object obj, PRaiseNode raiseNode) {
            if (obj == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.NULL_ARG_INTERNAL);
            }
        }

        protected static void checkNonNullArg(Node inliningTarget, Object obj1, Object obj2, PRaiseNode raiseNode) {
            if (obj1 == PNone.NO_VALUE || obj2 == PNone.NO_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.NULL_ARG_INTERNAL);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class PromoteBorrowedValue
    extends Node {
        public abstract Object execute(Node var1, Object var2);

        @Specialization
        static PString doString(TruffleString str, @Bind PythonLanguage language) {
            return PFactory.createString(language, str);
        }

        @Specialization
        static PythonBuiltinObject doInteger(int i, @Bind PythonLanguage language) {
            return PFactory.createInt(language, i);
        }

        @Specialization
        static PythonBuiltinObject doLong(long i, @Bind PythonLanguage language) {
            return PFactory.createInt(language, i);
        }

        @Specialization(guards={"!isNaN(d)"})
        static PythonBuiltinObject doDouble(double d, @Bind PythonLanguage language) {
            return PFactory.createFloat(language, d);
        }

        static boolean isNaN(double d) {
            return Double.isNaN(d);
        }

        @Fallback
        static PythonBuiltinObject doOther(Object value) {
            return null;
        }
    }
}

