/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={CallableStatement.class, PreparedStatement.class, Statement.class, OracleCallableStatement.class, OraclePreparedStatement.class, OracleStatement.class, oracle.jdbc.internal.OracleCallableStatement.class, oracle.jdbc.internal.OraclePreparedStatement.class, oracle.jdbc.internal.OracleStatement.class})
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class NonTxnReplayableStatement
extends NonTxnReplayableBase
implements Replayable {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;

    public NonTxnReplayableStatement() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$24, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$24, null, new Object[0]);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$24, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$24, null);
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$24, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$24, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$24, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void args;
            void receiver;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$0, this, method, object, objectArray);
            }
            super.preForAll((Method)m2, receiver, (Object[])args);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Pre
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected void preForExecute(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block21: {
                FailoverManagerImpl.ReplayLifecycle lifecycle;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$1, this, method, object, objectArray);
                }
                if ((lifecycle = this.failoverMngr.getReplayLifecycle()) != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$1, this);
                        ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$1, this, null);
                    }
                    return;
                }
                try {
                    void m2;
                    oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                    OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$1, Level.FINEST, this.getClass(), $$$methodRef$$$1, "On statement {0}, original SqlKind: {1}", new Object[]{this, sqlKind});
                    }
                    if (sqlKind.isSELECT() || sqlKind.isPlsqlOrCall() || sqlKind == OracleStatement.SqlKind.ALTER_SESSION || sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                        void args;
                        void receiver;
                        this.preForAll((Method)m2, receiver, (Object[])args);
                    } else if (sqlKind.isDML()) {
                        if (this.failoverMngr != null) {
                            this.failoverMngr.disableReplayInternal((Method)m2, 371, "Replay disabled because of active transaction", null);
                        } else if (bl) {
                            OracleLog.log($$$loggerRef$$$1, Level.SEVERE, this.getClass(), $$$methodRef$$$1, "On statement {0}, failover manager not set", this);
                        }
                    } else if (sqlKind.isOTHER()) {
                        if (this.failoverMngr != null) {
                            this.failoverMngr.disableReplayInternal((Method)m2, 372, "Replay disabled because of nonreplayable call", null);
                        } else if (bl) {
                            OracleLog.log($$$loggerRef$$$1, Level.SEVERE, this.getClass(), $$$methodRef$$$1, "On statement {0}, failover manager not set", this);
                        }
                    }
                }
                catch (SQLException sqlexc) {
                    if (!bl) break block21;
                    OracleLog.log($$$loggerRef$$$1, Level.WARNING, this.getClass(), $$$methodRef$$$1, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, sqlexc});
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Pre
    @Methods(signatures={@Signature(name="executeUpdate", args={}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected void preForExecuteUpdate(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block16: {
                FailoverManagerImpl.ReplayLifecycle lifecycle;
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$2, this, method, object, objectArray);
                }
                if ((lifecycle = this.failoverMngr.getReplayLifecycle()) != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$2, this);
                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$2, this, null);
                    }
                    return;
                }
                if (bl) {
                    OracleLog.log($$$loggerRef$$$2, Level.FINEST, this.getClass(), $$$methodRef$$$2, "On statement {0}, preForExecuteUpdate", this);
                }
                try {
                    void m2;
                    oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                    OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
                    if (bl) {
                        OracleLog.log($$$loggerRef$$$2, Level.FINEST, this.getClass(), $$$methodRef$$$2, "On statement {0}, original SqlKind: {1}", new Object[]{this, sqlKind});
                    }
                    if (sqlKind.isPlsqlOrCall()) {
                        void args;
                        void receiver;
                        this.preForAll((Method)m2, receiver, (Object[])args);
                    } else if (this.failoverMngr != null) {
                        this.failoverMngr.disableReplayInternal((Method)m2, 371, "Replay disabled because of active transaction", null);
                    } else if (bl) {
                        OracleLog.log($$$loggerRef$$$2, Level.SEVERE, this.getClass(), $$$methodRef$$$2, "On statement {0}, failover manager not set", this);
                    }
                }
                catch (SQLException sqlexc) {
                    if (!bl) break block16;
                    OracleLog.log($$$loggerRef$$$2, Level.WARNING, this.getClass(), $$$methodRef$$$2, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, sqlexc});
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Pre
    @Methods(signatures={@Signature(name="executeBatch", args={})})
    protected void preForExecuteBatch(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            FailoverManagerImpl.ReplayLifecycle lifecycle;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$3, this, method, object, objectArray);
            }
            if ((lifecycle = this.failoverMngr.getReplayLifecycle()) != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$3, this);
                    ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$3, this, null);
                }
                return;
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "On statement {0}, preForExecuteBatch", this);
            }
            if (this.failoverMngr != null) {
                void m2;
                this.failoverMngr.disableReplayInternal((Method)m2, 372, "Replay disabled because of nonreplayable call", null);
            } else if (bl) {
                OracleLog.log($$$loggerRef$$$3, Level.SEVERE, this.getClass(), $$$methodRef$$$3, "On statement {0}, failover manager not set", this);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Pre
    @Methods(signatures={@Signature(name="setAsciiStream", args={String.class, InputStream.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class}), @Signature(name="setNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="setAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="setBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="setCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class}), @Signature(name="setNCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="setUnicodeStream", args={int.class, InputStream.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setAsciiStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, int.class}), @Signature(name="setBinaryStreamAtName", args={String.class, InputStream.class, long.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, int.class}), @Signature(name="setCharacterStreamAtName", args={String.class, Reader.class, long.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class}), @Signature(name="setNCharacterStreamAtName", args={String.class, Reader.class, long.class}), @Signature(name="setUnicodeStreamAtName", args={String.class, InputStream.class})})
    protected void preForSetStreams(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            FailoverManagerImpl.ReplayLifecycle lifecycle;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$4, this, method, object, objectArray);
            }
            if ((lifecycle = this.failoverMngr.getReplayLifecycle()) != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$4, this);
                    ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$4, this, null);
                }
                return;
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$4, Level.FINEST, this.getClass(), $$$methodRef$$$4, "On statement {0}, preForSetStreams", this);
            }
            if (this.failoverMngr != null) {
                void m2;
                this.failoverMngr.disableReplayInternal((Method)m2, 372, "Replay disabled because of nonreplayable call", null);
            } else if (bl) {
                OracleLog.log($$$loggerRef$$$4, Level.SEVERE, this.getClass(), $$$methodRef$$$4, "On statement {0}, failover manager not set", this);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Pre
    @Methods(signatures={@Signature(name="setObject", args={String.class, Object.class}), @Signature(name="setObject", args={String.class, Object.class, int.class}), @Signature(name="setObject", args={String.class, Object.class, int.class, int.class}), @Signature(name="setObject", args={int.class, Object.class}), @Signature(name="setObject", args={int.class, Object.class, int.class}), @Signature(name="setObject", args={int.class, Object.class, int.class, int.class}), @Signature(name="setObjectAtName", args={String.class, Object.class}), @Signature(name="setObjectAtName", args={String.class, Object.class, int.class}), @Signature(name="setObjectAtName", args={String.class, Object.class, int.class, int.class})})
    protected void preForSetObjects(Method method, Object object, Object ... objectArray) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void args;
            FailoverManagerImpl.ReplayLifecycle lifecycle;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$5, this, method, object, objectArray);
            }
            if ((lifecycle = this.failoverMngr.getReplayLifecycle()) != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$5, this);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$5, this, null);
                }
                return;
            }
            if (bl) {
                OracleLog.log($$$loggerRef$$$5, Level.FINEST, this.getClass(), $$$methodRef$$$5, "On statement {0}, preForSetObjects", this);
            }
            if (args[1] instanceof InputStream || args[1] instanceof Reader) {
                if (this.failoverMngr != null) {
                    void m2;
                    this.failoverMngr.disableReplayInternal((Method)m2, 372, "Replay disabled because of nonreplayable call", null);
                } else if (bl) {
                    OracleLog.log($$$loggerRef$$$5, Level.SEVERE, this.getClass(), $$$methodRef$$$5, "On statement {0}, failover manager not set", this);
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void result;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$6, this, method, object);
            }
            Object object2 = super.postForAll((Method)m2, result);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$6, this, object2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$6, this, null);
            }
            return object2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected boolean postForExecute(Method method, boolean bl) {
        boolean bl2 = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void result;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$7, this, method, bl);
            }
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: 
                case REPLAYING_LASTCALL: {
                    void m2;
                    this.doPostWhenRecordingExecutes((Method)m2, (boolean)result, null);
                    break;
                }
                case INTERNALLY_FAILED: 
                case ALWAYS_DISABLED: 
                case INTERNALLY_DISABLED: 
                case EXTERNALLY_DISABLED: 
                case REPLAYING_CALLBACK: {
                    break;
                }
                case REPLAYING: {
                    void m2;
                    this.doPostWhenReplayingExecutes((Method)m2, (boolean)result, null);
                }
            }
            void var5_5 = result;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$7, this, (boolean)var5_5);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$7, this, null);
            }
            return (boolean)var5_5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    @Methods(signatures={@Signature(name="executeUpdate", args={}), @Signature(name="executeUpdate", args={String.class}), @Signature(name="executeUpdate", args={String.class, int.class}), @Signature(name="executeUpdate", args={String.class, int[].class}), @Signature(name="executeUpdate", args={String.class, String[].class})})
    protected int postForExecuteUpdate(Method method, int n2) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$8, this, method, n2);
            }
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: 
                case REPLAYING_LASTCALL: {
                    void m2;
                    this.doPostWhenRecordingExecutes((Method)m2, (int)result, null);
                    break;
                }
                case INTERNALLY_FAILED: 
                case ALWAYS_DISABLED: 
                case INTERNALLY_DISABLED: 
                case EXTERNALLY_DISABLED: 
                case REPLAYING_CALLBACK: {
                    break;
                }
                case REPLAYING: {
                    void m2;
                    this.doPostWhenReplayingExecutes((Method)m2, (int)result, null);
                }
            }
            void var5_5 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$8, this, (int)var5_5);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$8, this, null);
            }
            return (int)var5_5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    @Methods(signatures={@Signature(name="executeQuery", args={}), @Signature(name="executeQuery", args={String.class})})
    protected ResultSet postForExecuteQuery(Method method, ResultSet resultSet) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void result;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$9, this, method, resultSet);
            }
            if (result instanceof NonTxnReplayableBase) {
                NonTxnReplayableBase jdbcProxy = (NonTxnReplayableBase)result;
                jdbcProxy.setFailoverManager(this.getFailoverManager());
            }
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: 
                case REPLAYING_LASTCALL: {
                    void m2;
                    this.doPostWhenRecordingExecutes((Method)m2, result, null);
                    break;
                }
                case INTERNALLY_FAILED: 
                case ALWAYS_DISABLED: 
                case INTERNALLY_DISABLED: 
                case EXTERNALLY_DISABLED: 
                case REPLAYING_CALLBACK: {
                    break;
                }
                case REPLAYING: {
                    void m2;
                    this.doPostWhenReplayingExecutes((Method)m2, result, null);
                }
            }
            void var5_5 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$9, this, var5_5);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$9, this, null);
            }
            return var5_5;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method method) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$10, this, method);
            }
            FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: {
                    void m2;
                    this.doPostWhenRecordingClose((Method)m2, null);
                    break;
                }
                case INTERNALLY_FAILED: 
                case ALWAYS_DISABLED: 
                case INTERNALLY_DISABLED: 
                case EXTERNALLY_DISABLED: 
                case REPLAYING_CALLBACK: {
                    break;
                }
            }
            this.isClosedAndNoReplay = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$11, this, method, sQLException);
            }
            super.onErrorVoidForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void error;
            void m2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$12, this, method, sQLException);
            }
            Object object = super.onErrorForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$12, this, object);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$12, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="close", args={})})
    protected void onErrorVoidForClose(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            void error;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$13, this, method, sQLException);
            }
            if (error instanceof SQLRecoverableException) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$13, this);
                    ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$13, this, null);
                }
                return;
            }
            super.onErrorVoidForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="execute", args={}), @Signature(name="execute", args={String.class}), @Signature(name="execute", args={String.class, int.class}), @Signature(name="execute", args={String.class, int[].class}), @Signature(name="execute", args={String.class, String[].class})})
    protected boolean onErrorForExecute(Method method, SQLException sQLException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void m2;
            void error;
            block23: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$14, this, method, sQLException);
                }
                if (this.isClosedAndNoReplay) {
                    void var8_4 = error;
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$14, this, (Throwable)var8_4);
                    }
                    throw var8_4;
                }
                FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
                if (error instanceof SQLRecoverableException && lifecycle == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                    try {
                        oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                        OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$14, Level.FINEST, this.getClass(), $$$methodRef$$$14, "On statement {0}, original SqlKind: {1}", new Object[]{this, sqlKind});
                        }
                        if (sqlKind.isPlsqlOrCall()) {
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$14, Level.FINER, this.getClass(), $$$methodRef$$$14, "On proxy {0}, last call is PL/SQL", this);
                            }
                            this.failoverMngr.disableReplayInternal((Method)m2, 373, "Replay disabled because outage occurred during PL/SQL execution", null);
                        } else if (sqlKind.isDML()) {
                            if (this.failoverMngr != null) {
                                this.failoverMngr.disableReplayInternal((Method)m2, 371, "Replay disabled because of active transaction", null);
                            } else if (bl) {
                                OracleLog.log($$$loggerRef$$$14, Level.SEVERE, this.getClass(), $$$methodRef$$$14, "On statement {0}, failover manager not set", this);
                            }
                        } else if (sqlKind.isOTHER() && sqlKind != OracleStatement.SqlKind.ALTER_SESSION) {
                            if (this.failoverMngr != null) {
                                this.failoverMngr.disableReplayInternal((Method)m2, 372, "Replay disabled because of nonreplayable call", null);
                            } else if (bl) {
                                OracleLog.log($$$loggerRef$$$14, Level.SEVERE, this.getClass(), $$$methodRef$$$14, "On statement {0}, failover manager not set", this);
                            }
                        }
                    }
                    catch (SQLException sqlexc) {
                        if (!bl) break block23;
                        OracleLog.log($$$loggerRef$$$14, Level.WARNING, this.getClass(), $$$methodRef$$$14, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, sqlexc});
                    }
                }
            }
            boolean bl2 = (Boolean)super.onErrorForAll((Method)m2, (SQLException)error);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$14, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$14, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    /*
     * WARNING - void declaration
     */
    @Override
    public void fillInChecksum(FailoverManagerImpl.CallHistoryEntry callHistoryEntry) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void entry;
            String methodName;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$15, this, callHistoryEntry);
            }
            oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
            long checksum = ostmt.getChecksum();
            String string = methodName = entry == null || entry.method == null ? "NULL METHOD" : entry.method.getName();
            if (bl) {
                OracleLog.log($$$loggerRef$$$15, Level.FINEST, this.getClass(), $$$methodRef$$$15, "On proxy {0}, method {1}, filling in checksum: {2}", new Object[]{entry.jdbcProxy, methodName, checksum});
            }
            this.failoverMngr.update(this, (FailoverManagerImpl.CallHistoryEntry)entry, entry.result, entry.callStatus, checksum, entry.scn, entry.callException);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object replayOneCall(FailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            void origError;
            void entry;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$16, this, callHistoryEntry, sQLRecoverableException);
            }
            if (entry.scn != -1L) {
                String methodName;
                oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                ostmt.setSnapshotSCN(entry.scn);
                String string = methodName = entry == null || entry.method == null ? "NULL METHOD" : entry.method.getName();
                if (bl) {
                    OracleLog.log($$$loggerRef$$$16, Level.FINER, this.getClass(), $$$methodRef$$$16, "On proxy {0}, replaying method {1}, set original SCN: {2}", new Object[]{entry.jdbcProxy, methodName, entry.scn});
                }
            }
            Object object = super.replayOneCall((FailoverManagerImpl.CallHistoryEntry)entry, (SQLRecoverableException)origError);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$16, this, object);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$16, this, null);
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected void doPostWhenReplaying(Method method, Object object, SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block12: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$17, this, method, object, sQLException);
                }
                try {
                    FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
                    switch (lifecycle) {
                        case REPLAYING: {
                            String methodName;
                            if (this.replayingCallEntry.checksum == 0L) break;
                            oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                            long newChecksum = ostmt.getChecksum();
                            String string = methodName = this.replayingCallEntry == null || this.replayingCallEntry.method == null ? "NULL METHOD" : this.replayingCallEntry.method.getName();
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$17, Level.FINER, this.getClass(), $$$methodRef$$$17, "On proxy {0}, replaying method {1}, new checksum: {2}, original checksum: {3}", new Object[]{this.replayingCallEntry.jdbcProxy, methodName, newChecksum, this.replayingCallEntry.checksum});
                            }
                            if (this.replayingCallEntry.checksum != newChecksum) {
                                this.failoverMngr.disableReplayAndThrowException(this.replayingCallEntry.method, 388, "Replay failed because of checksum mismatch", this.originalError);
                            }
                            break;
                        }
                    }
                }
                catch (SQLException exc) {
                    if (!bl) break block12;
                    OracleLog.log($$$loggerRef$$$17, Level.WARNING, this.getClass(), $$$methodRef$$$17, "On statement {0}, doPostWhenReplaying exception: {1}", new Object[]{this, exc});
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$17, this);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$17, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$17, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doPostWhenReplayingExecutes(Method method, Object object, SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block12: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$18, this, method, object, sQLException);
                }
                try {
                    FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
                    switch (lifecycle) {
                        case REPLAYING: {
                            void sqlexc;
                            void result;
                            void m2;
                            this.doPostWhenReplaying((Method)m2, result, (SQLException)sqlexc);
                            break;
                        }
                        case REPLAYING_LASTCALL: {
                            oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                            OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
                            if (!sqlKind.isPlsqlOrCall()) break;
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$18, Level.FINER, this.getClass(), $$$methodRef$$$18, "On proxy {0}, last call is PL/SQL", this.replayingCallEntry.jdbcProxy);
                            }
                            this.failoverMngr.disableReplayInternal(this.replayingCallEntry.method, 373, "Replay disabled because outage occurred during PL/SQL execution", this.originalError);
                        }
                    }
                }
                catch (SQLException exc) {
                    if (!bl) break block12;
                    OracleLog.log($$$loggerRef$$$18, Level.WARNING, this.getClass(), $$$methodRef$$$18, "On statement {0}, doPostWhenReplayingExecutes exception: {1}", new Object[]{this, exc});
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$18, this);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$18, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$18, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean okToPurgeSameProxyList() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            boolean result;
            block18: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$19, this, new Object[0]);
                }
                result = false;
                try {
                    oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                    OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
                    if (sqlKind == OracleStatement.SqlKind.UNINITIALIZED) {
                        result = true;
                    } else if (sqlKind.isSELECT() && sqlKind != OracleStatement.SqlKind.SELECT_FOR_UPDATE) {
                        FailoverManagerImpl.CallHistoryEntry entry = this.headSameProxy;
                        while (entry != null) {
                            String methodName;
                            String string = methodName = entry.method == null ? "NULL METHOD" : entry.method.getName();
                            if (("execute".equals(methodName) || "executeQuery".equals(methodName)) && entry.scn > 0L) {
                                result = true;
                                break;
                            }
                            entry = entry.nextEntrySameProxy;
                        }
                    }
                    if (!bl) break block18;
                }
                catch (SQLException sqlexc) {
                    block19: {
                        try {
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$19, Level.FINEST, this.getClass(), $$$methodRef$$$19, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, sqlexc});
                            }
                            result = false;
                            if (!bl) break block19;
                        }
                        catch (Throwable throwable) {
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$19, Level.FINEST, this.getClass(), $$$methodRef$$$19, "On statement {0}, ok for implicit purge: {1}", new Object[]{this, result});
                            }
                            boolean bl2 = result;
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$19, this, bl2);
                                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$19, this, null);
                            }
                            return bl2;
                        }
                        OracleLog.log($$$loggerRef$$$19, Level.FINEST, this.getClass(), $$$methodRef$$$19, "On statement {0}, ok for implicit purge: {1}", new Object[]{this, result});
                    }
                    boolean bl3 = result;
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$19, this, bl3);
                        ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$19, this, null);
                    }
                    return bl3;
                }
                OracleLog.log($$$loggerRef$$$19, Level.FINEST, this.getClass(), $$$methodRef$$$19, "On statement {0}, ok for implicit purge: {1}", new Object[]{this, result});
            }
            boolean bl4 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$19, this, bl4);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$19, this, null);
            }
            return bl4;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$19, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void doPostWhenRecordingClose(Method method, SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$20, this, method, sQLException);
            }
            if (this.okToPurgeSameProxyList()) {
                this.purgeSameProxyList();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$20, this);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$20, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$20, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doPostWhenRecordingExecutes(Method method, Object object, SQLException sQLException) {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            block15: {
                if (bl) {
                    ClioSupport.entering($$$loggerRef$$$21, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$21, this, method, object, sQLException);
                }
                try {
                    void sqlexc;
                    void result;
                    void m2;
                    String methodName;
                    oracle.jdbc.internal.OracleStatement ostmt = (oracle.jdbc.internal.OracleStatement)this.getDelegate();
                    OracleConnection oconn = (OracleConnection)ostmt.getConnection();
                    OracleStatement.SqlKind sqlKind = ostmt.getSqlKind();
                    long checksum = 0L;
                    long SCN = -1L;
                    String string = methodName = m2 == null ? "NULL METHOD" : m2.getName();
                    if (sqlKind.isSELECT() || sqlKind.isPlsqlOrCall() || sqlKind == OracleStatement.SqlKind.ALTER_SESSION) {
                        EnumSet<OracleConnection.TransactionState> eocs = oconn.getTransactionState();
                        if (bl) {
                            OracleLog.log($$$loggerRef$$$21, Level.FINER, this.getClass(), $$$methodRef$$$21, "On proxy {0}, method {1}, transaction state: {2}", new Object[]{this, methodName, eocs});
                        }
                        if (eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_INTENTION) || eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !eocs.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
                            this.failoverMngr.disableReplayInternal((Method)m2, 371, "Replay disabled because of transaction", null);
                        } else {
                            checksum = 0L;
                            if (!this.failoverMngr.isReplayInCurrentMode() && sqlKind.isPlsqlOrCall()) {
                                this.failoverMngr.setReplayInCurrentMode();
                            }
                            long l2 = SCN = this.failoverMngr.isReplayInCurrentMode() ? -1L : oconn.getCurrentSCN();
                            if (bl) {
                                OracleLog.log($$$loggerRef$$$21, Level.FINER, this.getClass(), $$$methodRef$$$21, "On proxy {0}, method {1}, SCN to record: {2}", new Object[]{this, methodName, SCN});
                            }
                        }
                        if (this.failoverMngr.getReplayLifecycle() == FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                            this.failoverMngr.update(this, null, result, "completed", checksum, SCN, (SQLException)sqlexc);
                        }
                    } else {
                        this.failoverMngr.update(this, null, result, "completed", checksum, SCN, (SQLException)sqlexc);
                        this.failoverMngr.disableReplayInternal((Method)m2, 372, "Replay disabled because of nonreplayable call", null);
                    }
                }
                catch (SQLException exc) {
                    if (!bl) break block15;
                    OracleLog.log($$$loggerRef$$$21, Level.WARNING, this.getClass(), $$$methodRef$$$21, "On statement {0}, could not get original SqlKind: {1}", new Object[]{this, exc});
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$21, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$21, this);
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$21, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$21, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$21, this, throwable2);
            }
            throw throwable;
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getConnection() {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$22, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$22, this, new Object[0]);
            }
            Connection connection = (Connection)this.getCreator();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$22, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$22, this, connection);
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$22, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$22, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$22, this, throwable2);
            }
            throw throwable;
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        boolean bl = (0x100000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$23, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$23, this, clazz);
            }
            Object object = this.getDelegate();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$23, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$23, this, object);
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$23, this, null);
            }
            return (T)object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$23, Level.FINEST, NonTxnReplayableStatement.class, $$$methodRef$$$23, this, throwable2);
            }
            throw throwable;
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract ResultSet executeQuery(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract ResultSet executeQuery() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract ParameterMetaData getParameterMetaData() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Array getArray(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Array getArray(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Blob getBlob(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Blob getBlob(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Clob getClob(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Clob getClob(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract NClob getNClob(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract NClob getNClob(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Ref getRef(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Ref getRef(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract RowId getRowId(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract RowId getRowId(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Struct getStruct(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Struct getStruct(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract SQLXML getSQLXML(int var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract SQLXML getSQLXML(String var1) throws SQLException;

    static {
        try {
            $$$methodRef$$$24 = NonTxnReplayableStatement.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$23 = NonTxnReplayableStatement.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$22 = NonTxnReplayableStatement.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$21 = NonTxnReplayableStatement.class.getDeclaredMethod("doPostWhenRecordingExecutes", Method.class, Object.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = NonTxnReplayableStatement.class.getDeclaredMethod("doPostWhenRecordingClose", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = NonTxnReplayableStatement.class.getDeclaredMethod("okToPurgeSameProxyList", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = NonTxnReplayableStatement.class.getDeclaredMethod("doPostWhenReplayingExecutes", Method.class, Object.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = NonTxnReplayableStatement.class.getDeclaredMethod("doPostWhenReplaying", Method.class, Object.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = NonTxnReplayableStatement.class.getDeclaredMethod("replayOneCall", FailoverManagerImpl.CallHistoryEntry.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = NonTxnReplayableStatement.class.getDeclaredMethod("fillInChecksum", FailoverManagerImpl.CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = NonTxnReplayableStatement.class.getDeclaredMethod("onErrorForExecute", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = NonTxnReplayableStatement.class.getDeclaredMethod("onErrorVoidForClose", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = NonTxnReplayableStatement.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = NonTxnReplayableStatement.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = NonTxnReplayableStatement.class.getDeclaredMethod("postForClose", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = NonTxnReplayableStatement.class.getDeclaredMethod("postForExecuteQuery", Method.class, ResultSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = NonTxnReplayableStatement.class.getDeclaredMethod("postForExecuteUpdate", Method.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = NonTxnReplayableStatement.class.getDeclaredMethod("postForExecute", Method.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = NonTxnReplayableStatement.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = NonTxnReplayableStatement.class.getDeclaredMethod("preForSetObjects", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = NonTxnReplayableStatement.class.getDeclaredMethod("preForSetStreams", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = NonTxnReplayableStatement.class.getDeclaredMethod("preForExecuteBatch", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = NonTxnReplayableStatement.class.getDeclaredMethod("preForExecuteUpdate", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = NonTxnReplayableStatement.class.getDeclaredMethod("preForExecute", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = NonTxnReplayableStatement.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
    }
}

