/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form.validation;

import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.feedback.ContainerFeedbackMessageFilter;
import org.apache.wicket.feedback.FeedbackCollector;
import org.apache.wicket.feedback.IFeedback;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.border.Border;

public class FormComponentFeedbackBorder
extends Border
implements IFeedback {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_CSS_CLASS_KEY = CssUtils.key(FormComponentFeedbackBorder.class, "error");
    private boolean visible;

    public FormComponentFeedbackBorder(String id) {
        super(id);
        this.addToBorder(new ErrorIndicator("errorIndicator"));
    }

    @Override
    protected void onBeforeRender() {
        super.onBeforeRender();
        this.visible = new FeedbackCollector(this.getPage()).collect(this.getMessagesFilter()).size() > 0;
    }

    protected IFeedbackMessageFilter getMessagesFilter() {
        return new ContainerFeedbackMessageFilter(this);
    }

    private final class ErrorIndicator
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;

        public ErrorIndicator(String id) {
            super(id);
        }

        @Override
        public boolean isVisible() {
            return FormComponentFeedbackBorder.this.visible;
        }

        @Override
        protected void onComponentTag(ComponentTag tag) {
            super.onComponentTag(tag);
            tag.put("class", this.getString(ERROR_CSS_CLASS_KEY));
        }
    }
}

