/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.util.collections.MostRecentlyUsedMap;

class StoredResponsesMap
extends MostRecentlyUsedMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private final Duration lifetime;

    public StoredResponsesMap(int maxEntries, Duration lifetime) {
        super(maxEntries);
        this.lifetime = lifetime;
    }

    protected synchronized boolean removeEldestEntry(Map.Entry<String, Object> eldest) {
        Duration elapsedTime;
        Value value;
        boolean removed = super.removeEldestEntry(eldest);
        if (!removed && (value = (Value)eldest.getValue()) != null && this.lifetime.compareTo(elapsedTime = Duration.between(value.creationTime, Instant.now())) <= 0) {
            this.removedValue = value.response;
            removed = true;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedWebResponse put(String key, Object bufferedResponse) {
        Value oldValue;
        if (!(bufferedResponse instanceof BufferedWebResponse)) {
            throw new IllegalArgumentException(StoredResponsesMap.class.getSimpleName() + " can store only instances of " + BufferedWebResponse.class.getSimpleName());
        }
        Value value = new Value();
        value.creationTime = Instant.now();
        value.response = (BufferedWebResponse)bufferedResponse;
        StoredResponsesMap storedResponsesMap = this;
        synchronized (storedResponsesMap) {
            oldValue = (Value)super.put((Object)key, (Object)value);
        }
        return oldValue != null ? oldValue.response : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedWebResponse get(Object key) {
        Value value;
        BufferedWebResponse result = null;
        StoredResponsesMap storedResponsesMap = this;
        synchronized (storedResponsesMap) {
            value = (Value)super.get(key);
        }
        if (value != null) {
            Duration elapsedTime = Duration.between(value.creationTime, Instant.now());
            if (this.lifetime.compareTo(elapsedTime) > 0) {
                result = value.response;
            } else {
                this.remove(key);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedWebResponse remove(Object key) {
        Value removedValue;
        StoredResponsesMap storedResponsesMap = this;
        synchronized (storedResponsesMap) {
            removedValue = (Value)super.remove(key);
        }
        return removedValue != null ? removedValue.response : null;
    }

    public void putAll(Map<? extends String, ?> m) {
        throw new UnsupportedOperationException();
    }

    private static class Value {
        private BufferedWebResponse response;
        private Instant creationTime;

        private Value() {
        }
    }
}

