/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.processor;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.str.STRParser;

public class CertificateResult {
    private final X509Certificate[] certs;
    private final PublicKey publicKey;
    private final STRParser.REFERENCE_TYPE referenceType;

    protected CertificateResult(X509Certificate[] certs, PublicKey publicKey, STRParser.REFERENCE_TYPE referenceType) {
        this.certs = certs;
        this.publicKey = publicKey;
        this.referenceType = referenceType;
    }

    public X509Certificate[] getCerts() {
        return this.certs;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public STRParser.REFERENCE_TYPE getCertificatesReferenceType() {
        return this.referenceType;
    }

    static final class Builder {
        private X509Certificate[] certs;
        private PublicKey publicKey;
        private STRParser.REFERENCE_TYPE referenceType;

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Builder certificates(X509Certificate[] certs) {
            this.certs = certs;
            return this;
        }

        public Builder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public Builder certificatesReferenceType(STRParser.REFERENCE_TYPE referenceType) {
            this.referenceType = referenceType;
            return this;
        }

        public CertificateResult build() throws WSSecurityException {
            if (this.publicKey == null && (this.certs == null || this.certs.length < 1 || this.certs[0] == null)) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCertsFound", new Object[]{"decryption (KeyId)"});
            }
            if (this.certs != null && this.certs.length > 0) {
                this.publicKey = this.certs[0].getPublicKey();
            }
            return new CertificateResult(this.certs, this.publicKey, this.referenceType);
        }
    }
}

