/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.security.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.httpclient.HttpClientRequestContext;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.binding.security.impl.OperationContextEntityIDLookup;
import org.opensaml.saml.common.messaging.context.AbstractAuthenticatableSAMLEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.slf4j.Logger;

public class CheckAndRecordServerTLSEntityAuthenticationtHandler
extends AbstractMessageHandler {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(CheckAndRecordServerTLSEntityAuthenticationtHandler.class);
    @Nonnull
    private ContextDataLookupFunction<MessageContext, HttpClientContext> httpClientContextLookup = new DefaultHttpClientContextLookup();
    @Nullable
    private ContextDataLookupFunction<MessageContext, String> entityIDLookup = new OperationContextEntityIDLookup(this.entityContextClass);
    @Nonnull
    private Class<? extends AbstractAuthenticatableSAMLEntityContext> entityContextClass = SAMLPeerEntityContext.class;

    public void setHttpClientContextLookup(@Nonnull ContextDataLookupFunction<MessageContext, HttpClientContext> strategy) {
        this.checkSetterPreconditions();
        this.httpClientContextLookup = (ContextDataLookupFunction)Constraint.isNotNull(strategy, (String)"The HttpClientContext lookup strategy may not be null");
    }

    public void setEntityContextClass(@Nonnull Class<? extends AbstractAuthenticatableSAMLEntityContext> clazz) {
        this.checkSetterPreconditions();
        this.entityContextClass = (Class)Constraint.isNotNull(clazz, (String)"The SAML entity context class may not be null");
    }

    public void setEntityIDLookup(@Nullable ContextDataLookupFunction<MessageContext, String> strategy) {
        this.checkSetterPreconditions();
        this.entityIDLookup = strategy;
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        HttpClientContext clientContext = (HttpClientContext)this.httpClientContextLookup.apply((Object)messageContext);
        if (clientContext == null) {
            this.log.debug("Could not resolve HttpClientContext");
            return;
        }
        Boolean trusted = (Boolean)clientContext.getAttribute("opensaml.ServerTLSCredentialTrusted", Boolean.class);
        if (trusted == null) {
            this.log.debug("HttpClientContext attribute not found: {}", (Object)"opensaml.ServerTLSCredentialTrusted");
        } else if (trusted.booleanValue()) {
            this.log.debug("HttpClientContext indicates successful server TLS, storing result in entity context {}", (Object)this.entityContextClass.getName());
            AbstractAuthenticatableSAMLEntityContext entityContext = (AbstractAuthenticatableSAMLEntityContext)messageContext.ensureSubcontext(this.entityContextClass);
            entityContext.setAuthenticated(true);
            if (entityContext.getEntityId() == null && this.entityIDLookup != null) {
                this.log.debug("Context entityID was null, attempting to resolve");
                assert (this.entityIDLookup != null);
                String entityID = (String)this.entityIDLookup.apply((Object)messageContext);
                if (entityID != null) {
                    this.log.debug("Resolved authenticated entityID, populating on entity context: {}", (Object)entityID);
                    entityContext.setEntityId(entityID);
                } else {
                    this.log.debug("Unable to resolve authenticated entityID");
                }
            }
            this.log.debug("Current authenticated entityID is: {}", (Object)entityContext.getEntityId());
        } else {
            this.log.debug("HttpClientContext indicates non-successful server TLS");
        }
    }

    public class DefaultHttpClientContextLookup
    implements ContextDataLookupFunction<MessageContext, HttpClientContext> {
        public HttpClientContext apply(@Nullable MessageContext messageContext) {
            if (messageContext == null) {
                return null;
            }
            InOutOperationContext opContext = (InOutOperationContext)new RecursiveTypedParentContextLookup(InOutOperationContext.class).apply((BaseContext)messageContext);
            if (opContext == null) {
                return null;
            }
            MessageContext outboundMessageContext = opContext.getOutboundMessageContext();
            if (outboundMessageContext == null) {
                return null;
            }
            HttpClientRequestContext requestContext = (HttpClientRequestContext)outboundMessageContext.getSubcontext(HttpClientRequestContext.class);
            if (requestContext == null) {
                return null;
            }
            return requestContext.getHttpClientContext();
        }
    }
}

