/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.ext.DefaultMethod;
import org.apache.cxf.jaxrs.ext.xml.ElementClass;
import org.apache.cxf.jaxrs.ext.xml.XMLName;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.MethodDispatcher;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.ResourceTypes;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.model.UserOperation;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class ResourceUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(ResourceUtils.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ResourceUtils.class);
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String NOT_RESOURCE_METHOD_MESSAGE_ID = "NOT_RESOURCE_METHOD";
    private static final String NOT_SUSPENDED_ASYNC_MESSAGE_ID = "NOT_SUSPENDED_ASYNC_METHOD";
    private static final String NO_VOID_RETURN_ASYNC_MESSAGE_ID = "NO_VOID_RETURN_ASYNC_METHOD";
    private static final Set<String> SERVER_PROVIDER_CLASS_NAMES = new HashSet<String>();

    private ResourceUtils() {
    }

    private static Method[] getDeclaredMethods(final Class<?> c) {
        return AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return c.getDeclaredMethods();
            }
        });
    }

    public static Method findPostConstructMethod(Class<?> c) {
        return ResourceUtils.findPostConstructMethod(c, null);
    }

    public static Method findPostConstructMethod(Class<?> c, String name) {
        if (Object.class == c || null == c) {
            return null;
        }
        for (Method m : ResourceUtils.getDeclaredMethods(c)) {
            if (!(name != null ? m.getName().equals(name) : m.getAnnotation(PostConstruct.class) != null)) continue;
            return m;
        }
        Method m = ResourceUtils.findPostConstructMethod(c.getSuperclass(), name);
        if (m != null) {
            return m;
        }
        for (Class<?> i : c.getInterfaces()) {
            m = ResourceUtils.findPostConstructMethod(i, name);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    public static Method findPreDestroyMethod(Class<?> c) {
        return ResourceUtils.findPreDestroyMethod(c, null);
    }

    public static Method findPreDestroyMethod(Class<?> c, String name) {
        if (Object.class == c || null == c) {
            return null;
        }
        for (Method m : ResourceUtils.getDeclaredMethods(c)) {
            if (!(name != null ? m.getName().equals(name) : m.getAnnotation(PreDestroy.class) != null)) continue;
            return m;
        }
        Method m = ResourceUtils.findPreDestroyMethod(c.getSuperclass(), name);
        if (m != null) {
            return m;
        }
        for (Class<?> i : c.getInterfaces()) {
            m = ResourceUtils.findPreDestroyMethod(i, name);
            if (m == null) continue;
            return m;
        }
        return null;
    }

    public static ClassResourceInfo createClassResourceInfo(Map<String, UserResource> resources, UserResource model, Class<?> defaultClass, boolean isRoot, boolean enableStatic, Bus bus) {
        boolean isDefaultClass = defaultClass != null;
        Class<?> sClass = !isDefaultClass ? ResourceUtils.loadClass(model.getName()) : defaultClass;
        return ResourceUtils.createServiceClassResourceInfo(resources, model, sClass, isRoot, enableStatic, bus);
    }

    public static ClassResourceInfo createServiceClassResourceInfo(Map<String, UserResource> resources, UserResource model, Class<?> sClass, boolean isRoot, boolean enableStatic, Bus bus) {
        if (model == null) {
            throw new RuntimeException("Resource class " + sClass.getName() + " has no model info");
        }
        ClassResourceInfo cri = new ClassResourceInfo(sClass, sClass, isRoot, enableStatic, true, model.getConsumes(), model.getProduces(), bus);
        URITemplate t = URITemplate.createTemplate(model.getPath());
        cri.setURITemplate(t);
        MethodDispatcher md = new MethodDispatcher();
        Map<String, UserOperation> ops = model.getOperationsAsMap();
        Method defaultMethod = null;
        HashMap<String, Method> methodNames = new HashMap<String, Method>();
        for (Method m : cri.getServiceClass().getMethods()) {
            if (m.getAnnotation(DefaultMethod.class) != null) {
                defaultMethod = m;
            }
            methodNames.put(m.getName(), m);
        }
        for (Map.Entry entry : ops.entrySet()) {
            UserOperation op = (UserOperation)entry.getValue();
            Method actualMethod = (Method)methodNames.get(op.getName());
            if (actualMethod == null) {
                actualMethod = defaultMethod;
            }
            if (actualMethod == null) continue;
            OperationResourceInfo ori = new OperationResourceInfo(actualMethod, cri, URITemplate.createTemplate(op.getPath()), op.getVerb(), op.getConsumes(), op.getProduces(), op.getParameters(), op.isOneway());
            String rClassName = actualMethod.getReturnType().getName();
            if (op.getVerb() == null) {
                ClassResourceInfo subCri;
                if (!resources.containsKey(rClassName) || (subCri = rClassName.equals(model.getName()) ? cri : ResourceUtils.createServiceClassResourceInfo(resources, resources.get(rClassName), actualMethod.getReturnType(), false, enableStatic, bus)) == null) continue;
                cri.addSubClassResourceInfo(subCri);
                md.bind(ori, actualMethod);
                continue;
            }
            md.bind(ori, actualMethod);
        }
        cri.setMethodDispatcher(md);
        return ResourceUtils.checkMethodDispatcher(cri) ? cri : null;
    }

    public static ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, boolean root, boolean enableStatic) {
        return ResourceUtils.createClassResourceInfo(rClass, sClass, root, enableStatic, BusFactory.getThreadDefaultBus());
    }

    public static ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, boolean root, boolean enableStatic, Bus bus) {
        return ResourceUtils.createClassResourceInfo(rClass, sClass, null, root, enableStatic, bus);
    }

    public static ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, ClassResourceInfo parent, boolean root, boolean enableStatic, Bus bus) {
        return ResourceUtils.createClassResourceInfo(rClass, sClass, parent, root, enableStatic, bus, null, null);
    }

    public static ClassResourceInfo createClassResourceInfo(Class<?> rClass, Class<?> sClass, ClassResourceInfo parent, boolean root, boolean enableStatic, Bus bus, List<MediaType> defaultConsumes, List<MediaType> defaultProduces) {
        ClassResourceInfo cri = new ClassResourceInfo(rClass, sClass, root, enableStatic, bus, defaultConsumes, defaultProduces);
        cri.setParent(parent);
        if (root) {
            URITemplate t = URITemplate.createTemplate(cri.getPath());
            cri.setURITemplate(t);
        }
        ResourceUtils.evaluateResourceClass(cri, enableStatic);
        return ResourceUtils.checkMethodDispatcher(cri) ? cri : null;
    }

    private static void evaluateResourceClass(ClassResourceInfo cri, boolean enableStatic) {
        Method annotatedMethod;
        MethodDispatcher md = new MethodDispatcher();
        Class<?> serviceClass = cri.getServiceClass();
        HashMap<Method, Method> annotatedMethods = new HashMap<Method, Method>();
        for (Method m : serviceClass.getMethods()) {
            if (m.isBridge() || m.isSynthetic() || annotatedMethods.containsKey(annotatedMethod = AnnotationUtils.getAnnotatedMethod(serviceClass, m))) continue;
            ResourceUtils.evaluateResourceMethod(cri, enableStatic, md, m, annotatedMethod);
            annotatedMethods.put(annotatedMethod, m);
        }
        for (Method m : serviceClass.getMethods()) {
            if (!m.isBridge() && !m.isSynthetic()) continue;
            annotatedMethod = AnnotationUtils.getAnnotatedMethod(serviceClass, m);
            if (!annotatedMethods.containsKey(annotatedMethod)) {
                ResourceUtils.evaluateResourceMethod(cri, enableStatic, md, m, annotatedMethod);
                annotatedMethods.put(annotatedMethod, m);
                continue;
            }
            ResourceUtils.bindResourceMethod(md, m, (Method)annotatedMethods.get(annotatedMethod));
        }
        cri.setMethodDispatcher(md);
    }

    private static void bindResourceMethod(MethodDispatcher md, Method m, Method bound) {
        OperationResourceInfo ori = md.getOperationResourceInfo(bound);
        if (ori != null && !ori.getMethodToInvoke().equals(m)) {
            md.bind(ori, bound, m);
        }
    }

    private static void evaluateResourceMethod(ClassResourceInfo cri, boolean enableStatic, MethodDispatcher md, Method m, Method annotatedMethod) {
        String httpMethod = AnnotationUtils.getHttpMethodValue(annotatedMethod);
        Path path = AnnotationUtils.getMethodAnnotation(annotatedMethod, Path.class);
        if (httpMethod != null || path != null) {
            if (!ResourceUtils.checkAsyncResponse(annotatedMethod)) {
                return;
            }
            md.bind(ResourceUtils.createOperationInfo(m, annotatedMethod, cri, path, httpMethod), m);
            if (httpMethod == null) {
                Class<?> subClass = m.getReturnType();
                if (subClass == Class.class) {
                    subClass = InjectionUtils.getActualType(m.getGenericReturnType());
                }
                if (enableStatic) {
                    ClassResourceInfo subCri = cri.findResource(subClass, subClass);
                    if (subCri == null) {
                        ClassResourceInfo ancestor = ResourceUtils.getAncestorWithSameServiceClass(cri, subClass);
                        ClassResourceInfo classResourceInfo = subCri = ancestor != null ? ancestor : ResourceUtils.createClassResourceInfo(subClass, subClass, cri, false, enableStatic, cri.getBus());
                    }
                    if (subCri != null) {
                        cri.addSubClassResourceInfo(subCri);
                    }
                }
            }
        } else {
            ResourceUtils.reportInvalidResourceMethod(m, NOT_RESOURCE_METHOD_MESSAGE_ID, Level.FINE);
        }
    }

    private static void reportInvalidResourceMethod(Method m, String messageId, Level logLevel) {
        if (LOG.isLoggable(logLevel)) {
            LOG.log(logLevel, new org.apache.cxf.common.i18n.Message(messageId, BUNDLE, new Object[]{m.getDeclaringClass().getName(), m.getName()}).toString());
        }
    }

    private static boolean checkAsyncResponse(Method m) {
        Class<?>[] types = m.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != AsyncResponse.class) continue;
            if (AnnotationUtils.getAnnotation(m.getParameterAnnotations()[i], Suspended.class) == null) {
                ResourceUtils.reportInvalidResourceMethod(m, NOT_SUSPENDED_ASYNC_MESSAGE_ID, Level.FINE);
                return false;
            }
            if (m.getReturnType() == Void.TYPE || m.getReturnType() == Void.class) {
                return true;
            }
            ResourceUtils.reportInvalidResourceMethod(m, NO_VOID_RETURN_ASYNC_MESSAGE_ID, Level.WARNING);
            return false;
        }
        return true;
    }

    private static ClassResourceInfo getAncestorWithSameServiceClass(ClassResourceInfo parent, Class<?> subClass) {
        if (parent == null) {
            return null;
        }
        if (parent.getServiceClass() == subClass) {
            return parent;
        }
        return ResourceUtils.getAncestorWithSameServiceClass(parent.getParent(), subClass);
    }

    public static Constructor<?> findResourceConstructor(Class<?> resourceClass, boolean perRequest) {
        LinkedList cs = new LinkedList();
        for (Constructor<?> c : resourceClass.getConstructors()) {
            Class<?>[] params = c.getParameterTypes();
            Annotation[][] anns = c.getParameterAnnotations();
            boolean match = true;
            for (int i = 0; i < params.length; ++i) {
                if (!perRequest) {
                    if (AnnotationUtils.getAnnotation(anns[i], Context.class) != null) continue;
                    match = false;
                    break;
                }
                if (AnnotationUtils.isValidParamAnnotations(anns[i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            cs.add(c);
        }
        Collections.sort(cs, new Comparator<Constructor<?>>(){

            @Override
            public int compare(Constructor<?> c1, Constructor<?> c2) {
                int p2;
                int p1 = c1.getParameterTypes().length;
                return p1 > (p2 = c2.getParameterTypes().length) ? -1 : (p1 < p2 ? 1 : 0);
            }
        });
        return cs.isEmpty() ? null : (Constructor)cs.get(0);
    }

    public static List<Parameter> getParameters(Method resourceMethod) {
        Annotation[][] paramAnns = resourceMethod.getParameterAnnotations();
        if (paramAnns.length == 0) {
            return CastUtils.cast(Collections.emptyList(), Parameter.class);
        }
        Class<?>[] types = resourceMethod.getParameterTypes();
        ArrayList<Parameter> params = new ArrayList<Parameter>(paramAnns.length);
        for (int i = 0; i < paramAnns.length; ++i) {
            Parameter p = ResourceUtils.getParameter(i, paramAnns[i], types[i]);
            params.add(p);
        }
        return params;
    }

    public static Parameter getParameter(int index, Annotation[] anns, Class<?> type) {
        Context ctx = AnnotationUtils.getAnnotation(anns, Context.class);
        if (ctx != null) {
            return new Parameter(ParameterType.CONTEXT, index, null);
        }
        boolean isEncoded = AnnotationUtils.getAnnotation(anns, Encoded.class) != null;
        BeanParam bp = AnnotationUtils.getAnnotation(anns, BeanParam.class);
        if (bp != null) {
            return new Parameter(ParameterType.BEAN, index, null, isEncoded, null);
        }
        String dValue = AnnotationUtils.getDefaultParameterValue(anns);
        PathParam a = AnnotationUtils.getAnnotation(anns, PathParam.class);
        if (a != null) {
            return new Parameter(ParameterType.PATH, index, a.value(), isEncoded, dValue);
        }
        QueryParam q = AnnotationUtils.getAnnotation(anns, QueryParam.class);
        if (q != null) {
            return new Parameter(ParameterType.QUERY, index, q.value(), isEncoded, dValue);
        }
        MatrixParam m = AnnotationUtils.getAnnotation(anns, MatrixParam.class);
        if (m != null) {
            return new Parameter(ParameterType.MATRIX, index, m.value(), isEncoded, dValue);
        }
        FormParam f = AnnotationUtils.getAnnotation(anns, FormParam.class);
        if (f != null) {
            return new Parameter(ParameterType.FORM, index, f.value(), isEncoded, dValue);
        }
        HeaderParam h = AnnotationUtils.getAnnotation(anns, HeaderParam.class);
        if (h != null) {
            return new Parameter(ParameterType.HEADER, index, h.value(), isEncoded, dValue);
        }
        CookieParam c = AnnotationUtils.getAnnotation(anns, CookieParam.class);
        if (c != null) {
            return new Parameter(ParameterType.COOKIE, index, c.value(), isEncoded, dValue);
        }
        return new Parameter(ParameterType.REQUEST_BODY, index, null);
    }

    private static OperationResourceInfo createOperationInfo(Method m, Method annotatedMethod, ClassResourceInfo cri, Path path, String httpMethod) {
        OperationResourceInfo ori = new OperationResourceInfo(m, annotatedMethod, cri);
        URITemplate t = URITemplate.createTemplate(path);
        ori.setURITemplate(t);
        ori.setHttpMethod(httpMethod);
        return ori;
    }

    private static boolean checkMethodDispatcher(ClassResourceInfo cr) {
        if (cr.getMethodDispatcher().getOperationResourceInfos().isEmpty()) {
            LOG.warning(new org.apache.cxf.common.i18n.Message("NO_RESOURCE_OP_EXC", BUNDLE, new Object[]{cr.getServiceClass().getName()}).toString());
            return false;
        }
        return true;
    }

    private static Class<?> loadClass(String cName) {
        try {
            return ClassLoaderUtils.loadClass((String)cName.trim(), ResourceUtils.class);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("No class " + cName.trim() + " can be found", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<UserResource> getUserResources(String loc, Bus bus) {
        try (InputStream is = ResourceUtils.getResourceStream(loc, bus);){
            if (is == null) {
                List<UserResource> list2 = null;
                return list2;
            }
            List<UserResource> list = ResourceUtils.getUserResources(is);
            return list;
        }
        catch (Exception ex) {
            LOG.warning("Problem with processing a user model at " + loc);
            return null;
        }
    }

    public static InputStream getResourceStream(String loc, Bus bus) throws IOException {
        URL url = ResourceUtils.getResourceURL(loc, bus);
        return url == null ? null : url.openStream();
    }

    public static URL getResourceURL(String loc, Bus bus) throws IOException {
        URL url;
        block5: {
            if (loc.startsWith(CLASSPATH_PREFIX)) {
                String path = loc.substring(CLASSPATH_PREFIX.length());
                url = ResourceUtils.getClasspathResourceURL(path, ResourceUtils.class, bus);
            } else {
                try {
                    url = new URL(loc);
                }
                catch (Exception ex) {
                    File file;
                    url = ResourceUtils.getClasspathResourceURL(loc, ResourceUtils.class, bus);
                    if (url != null || !(file = new File(loc)).exists()) break block5;
                    url = file.toURI().toURL();
                }
            }
        }
        if (url == null) {
            LOG.warning("No resource " + loc + " is available");
        }
        return url;
    }

    public static InputStream getClasspathResourceStream(String path, Class<?> callingClass, Bus bus) {
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)path, callingClass);
        return is == null ? ResourceUtils.getResource(path, InputStream.class, bus) : is;
    }

    public static URL getClasspathResourceURL(String path, Class<?> callingClass, Bus bus) {
        URL url = ClassLoaderUtils.getResource((String)path, callingClass);
        return url == null ? ResourceUtils.getResource(path, URL.class, bus) : url;
    }

    public static <T> T getResource(String path, Class<T> resourceClass, Bus bus) {
        ResourceManager rm;
        if (bus != null && (rm = (ResourceManager)bus.getExtension(ResourceManager.class)) != null) {
            return (T)rm.resolveResource(path, resourceClass);
        }
        return null;
    }

    public static Properties loadProperties(String propertiesLocation, Bus bus) throws IOException {
        Properties props = new Properties();
        try (InputStream is = ResourceUtils.getResourceStream(propertiesLocation, bus);){
            props.load(is);
        }
        return props;
    }

    public static List<UserResource> getUserResources(String loc) {
        return ResourceUtils.getUserResources(loc, BusFactory.getThreadDefaultBus());
    }

    public static List<UserResource> getUserResources(InputStream is) throws Exception {
        Document doc = StaxUtils.read((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
        return ResourceUtils.getResourcesFromElement(doc.getDocumentElement());
    }

    public static List<UserResource> getResourcesFromElement(Element modelEl) {
        ArrayList<UserResource> resources = new ArrayList<UserResource>();
        List resourceEls = DOMUtils.findAllElementsByTagNameNS((Element)modelEl, (String)"http://cxf.apache.org/jaxrs", (String)"resource");
        for (Element e : resourceEls) {
            resources.add(ResourceUtils.getResourceFromElement(e));
        }
        return resources;
    }

    public static ResourceTypes getAllRequestResponseTypes(List<ClassResourceInfo> cris, boolean jaxbOnly) {
        return ResourceUtils.getAllRequestResponseTypes(cris, jaxbOnly, null);
    }

    public static ResourceTypes getAllRequestResponseTypes(List<ClassResourceInfo> cris, boolean jaxbOnly, MessageBodyWriter<?> jaxbWriter) {
        ResourceTypes types = new ResourceTypes();
        for (ClassResourceInfo resource : cris) {
            ResourceUtils.getAllTypesForResource(resource, types, jaxbOnly, jaxbWriter);
        }
        return types;
    }

    public static Class<?> getActualJaxbType(Class<?> type, Method resourceMethod, boolean inbound) {
        ElementClass element = resourceMethod.getAnnotation(ElementClass.class);
        if (element != null) {
            Class<?> cls;
            Class<?> clazz = cls = inbound ? element.request() : element.response();
            if (cls != Object.class) {
                return cls;
            }
        }
        return type;
    }

    private static void getAllTypesForResource(ClassResourceInfo resource, ResourceTypes types, boolean jaxbOnly, MessageBodyWriter<?> jaxbWriter) {
        Class jaxbElement = null;
        try {
            jaxbElement = ClassLoaderUtils.loadClass((String)"jakarta.xml.bind.JAXBElement", ResourceUtils.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        for (OperationResourceInfo ori : resource.getMethodDispatcher().getOperationResourceInfos()) {
            Method method = ori.getAnnotatedMethod() == null ? ori.getMethodToInvoke() : ori.getAnnotatedMethod();
            Class<?> realReturnType = method.getReturnType();
            Class<?> cls = realReturnType;
            if (cls == Response.class || ori.isAsync()) {
                cls = ResourceUtils.getActualJaxbType(cls, method, false);
            }
            Type type = method.getGenericReturnType();
            if (jaxbOnly) {
                ResourceUtils.checkJaxbType(resource.getServiceClass(), cls, realReturnType == Response.class || ori.isAsync() ? cls : type, types, method.getAnnotations(), jaxbWriter, jaxbElement);
            } else {
                types.getAllTypes().put(cls, type);
            }
            for (Parameter pm : ori.getParameters()) {
                Class<?> inType;
                if (pm.getType() != ParameterType.REQUEST_BODY || (inType = method.getParameterTypes()[pm.getIndex()]) == AsyncResponse.class) continue;
                Type paramType = method.getGenericParameterTypes()[pm.getIndex()];
                if (jaxbOnly) {
                    ResourceUtils.checkJaxbType(resource.getServiceClass(), inType, paramType, types, method.getParameterAnnotations()[pm.getIndex()], jaxbWriter, jaxbElement);
                    continue;
                }
                types.getAllTypes().put(inType, paramType);
            }
        }
        for (ClassResourceInfo sub : resource.getSubResources()) {
            if (ResourceUtils.isRecursiveSubResource(resource, sub)) continue;
            ResourceUtils.getAllTypesForResource(sub, types, jaxbOnly, jaxbWriter);
        }
    }

    private static boolean isRecursiveSubResource(ClassResourceInfo parent, ClassResourceInfo sub) {
        if (parent == null) {
            return false;
        }
        if (parent == sub) {
            return true;
        }
        return ResourceUtils.isRecursiveSubResource(parent.getParent(), sub);
    }

    private static void checkJaxbType(Class<?> serviceClass, Class<?> type, Type genericType, ResourceTypes types, Annotation[] anns, MessageBodyWriter<?> jaxbWriter, Class<?> jaxbElement) {
        boolean isCollection = false;
        if (InjectionUtils.isSupportedCollectionOrArray(type)) {
            type = InjectionUtils.getActualType(genericType);
            isCollection = true;
        }
        if (type == Object.class && !(genericType instanceof Class) || genericType instanceof TypeVariable) {
            Type theType = InjectionUtils.processGenericTypeIfNeeded(serviceClass, Object.class, genericType);
            type = InjectionUtils.getActualType(theType);
        }
        if (type == null || InjectionUtils.isPrimitive(type) || jaxbElement != null && jaxbElement.isAssignableFrom(type) || Response.class.isAssignableFrom(type) || type.isInterface()) {
            return;
        }
        MessageBodyWriter<?> writer = jaxbWriter;
        if (writer == null) {
            JAXBElementProvider defaultWriter = new JAXBElementProvider();
            defaultWriter.setMarshallAsJaxbElement(true);
            defaultWriter.setXmlTypeAsJaxbElementOnly(true);
            writer = defaultWriter;
        }
        if (writer.isWriteable(type, type, anns, MediaType.APPLICATION_XML_TYPE)) {
            XMLName name;
            QName qname;
            types.getAllTypes().put(type, type);
            Class<?> genCls = InjectionUtils.getActualType(genericType);
            if (genCls != type && genCls != null && genCls != Object.class && !InjectionUtils.isSupportedCollectionOrArray(genCls)) {
                types.getAllTypes().put(genCls, genCls);
            }
            QName qName = qname = (name = AnnotationUtils.getAnnotation(anns, XMLName.class)) != null ? JAXRSUtils.convertStringToQName(name.value()) : null;
            if (isCollection) {
                types.getCollectionMap().put(type, qname);
            } else {
                types.getXmlNameMap().put(type, qname);
            }
        }
    }

    private static UserResource getResourceFromElement(Element e) {
        UserResource resource = new UserResource();
        resource.setName(e.getAttribute("name"));
        resource.setPath(e.getAttribute("path"));
        resource.setConsumes(e.getAttribute("consumes"));
        resource.setProduces(e.getAttribute("produces"));
        List operEls = DOMUtils.findAllElementsByTagNameNS((Element)e, (String)"http://cxf.apache.org/jaxrs", (String)"operation");
        ArrayList<UserOperation> opers = new ArrayList<UserOperation>(operEls.size());
        for (Element operEl : operEls) {
            opers.add(ResourceUtils.getOperationFromElement(operEl));
        }
        resource.setOperations(opers);
        return resource;
    }

    private static UserOperation getOperationFromElement(Element e) {
        UserOperation op = new UserOperation();
        op.setName(e.getAttribute("name"));
        op.setVerb(e.getAttribute("verb"));
        op.setPath(e.getAttribute("path"));
        op.setOneway(Boolean.parseBoolean(e.getAttribute("oneway")));
        op.setConsumes(e.getAttribute("consumes"));
        op.setProduces(e.getAttribute("produces"));
        List paramEls = DOMUtils.findAllElementsByTagNameNS((Element)e, (String)"http://cxf.apache.org/jaxrs", (String)"param");
        ArrayList<Parameter> params = new ArrayList<Parameter>(paramEls.size());
        for (int i = 0; i < paramEls.size(); ++i) {
            Element paramEl = (Element)paramEls.get(i);
            Parameter p = new Parameter(paramEl.getAttribute("type"), i, paramEl.getAttribute("name"));
            p.setEncoded(Boolean.valueOf(paramEl.getAttribute("encoded")));
            p.setDefaultValue(paramEl.getAttribute("defaultValue"));
            String pClass = paramEl.getAttribute("class");
            if (!StringUtils.isEmpty((String)pClass)) {
                try {
                    p.setJavaType(ClassLoaderUtils.loadClass((String)pClass, ResourceUtils.class));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            params.add(p);
        }
        op.setParameters(params);
        return op;
    }

    public static Object[] createConstructorArguments(Constructor<?> c, Message m, boolean perRequest) {
        return ResourceUtils.createConstructorArguments(c, m, perRequest, null);
    }

    public static Object[] createConstructorArguments(Constructor<?> c, Message m, boolean perRequest, Map<Class<?>, Object> contextValues) {
        Class<?>[] params = c.getParameterTypes();
        Annotation[][] anns = c.getParameterAnnotations();
        Type[] genericTypes = c.getGenericParameterTypes();
        return ResourceUtils.createConstructorArguments(c, m, perRequest, contextValues, params, anns, genericTypes);
    }

    public static Object[] createConstructorArguments(Constructor<?> c, Message m, boolean perRequest, Map<Class<?>, Object> contextValues, Class<?>[] params, Annotation[][] anns, Type[] genericTypes) {
        if (m == null) {
            m = new MessageImpl();
        }
        MultivaluedMap templateValues = (MultivaluedMap)m.get((Object)"jaxrs.template.parameters");
        Object[] values = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            if (AnnotationUtils.getAnnotation(anns[i], Context.class) != null) {
                Object contextValue;
                Object object = contextValue = contextValues != null ? contextValues.get(params[i]) : null;
                if (contextValue == null) {
                    if (perRequest || InjectionUtils.VALUE_CONTEXTS.contains(params[i].getName())) {
                        values[i] = JAXRSUtils.createContextValue(m, genericTypes[i], params[i]);
                        continue;
                    }
                    values[i] = InjectionUtils.createThreadLocalProxy(params[i]);
                    continue;
                }
                values[i] = contextValue;
                continue;
            }
            Parameter p = ResourceUtils.getParameter(i, anns[i], params[i]);
            values[i] = JAXRSUtils.createHttpParameterValue(p, params[i], genericTypes[i], anns[i], m, (MultivaluedMap<String, String>)templateValues, null);
        }
        return values;
    }

    public static JAXRSServerFactoryBean createApplication(Application app, boolean ignoreAppPath, boolean staticSubresourceResolution, boolean useSingletonResourceProvider, Bus bus) {
        Object appPath;
        Set singletons = app.getSingletons();
        ResourceUtils.verifySingletons(singletons);
        ArrayList resourceClasses = new ArrayList();
        ArrayList<Object> providers = new ArrayList<Object>();
        ArrayList<Feature> features = new ArrayList<Feature>();
        HashMap map = new HashMap();
        for (Class cls : app.getClasses()) {
            if (!ResourceUtils.isValidApplicationClass(cls, singletons)) continue;
            if (ResourceUtils.isValidProvider(cls)) {
                providers.add(ResourceUtils.createProviderInstance(cls));
                continue;
            }
            if (Feature.class.isAssignableFrom(cls)) {
                features.add(ResourceUtils.createFeatureInstance(cls));
                continue;
            }
            resourceClasses.add(cls);
            if (useSingletonResourceProvider) {
                map.put(cls, new SingletonResourceProvider(ResourceUtils.createProviderInstance(cls)));
                continue;
            }
            map.put(cls, new PerRequestResourceProvider(cls));
        }
        for (Object o : singletons) {
            if (ResourceUtils.isValidProvider(o.getClass())) {
                providers.add(o);
                continue;
            }
            if (o instanceof Feature) {
                features.add((Feature)o);
                continue;
            }
            resourceClasses.add(o.getClass());
            map.put(o.getClass(), new SingletonResourceProvider(o));
        }
        JAXRSServerFactoryBean bean = new JAXRSServerFactoryBean();
        if (bus != null) {
            bean.setBus(bus);
        }
        Object address = "/";
        if (!ignoreAppPath && (appPath = ResourceUtils.locateApplicationPath(app.getClass())) != null) {
            address = appPath.value();
        }
        if (!((String)address).startsWith("/")) {
            address = "/" + (String)address;
        }
        bean.setAddress((String)address);
        bean.setStaticSubresourceResolution(staticSubresourceResolution);
        bean.setResourceClasses(resourceClasses);
        bean.setProviders(providers);
        bean.getFeatures().addAll(features);
        for (Map.Entry entry : map.entrySet()) {
            bean.setResourceProvider((Class)entry.getKey(), (ResourceProvider)entry.getValue());
        }
        Map appProps = app.getProperties();
        if (appProps != null) {
            bean.getProperties(true).putAll(appProps);
        }
        bean.setApplication(app);
        return bean;
    }

    public static Object createProviderInstance(Class<?> cls) {
        try {
            Constructor<?> c = ResourceUtils.findResourceConstructor(cls, false);
            if (c != null && c.getParameterTypes().length == 0) {
                return c.newInstance(new Object[0]);
            }
            return c;
        }
        catch (Throwable ex) {
            throw new RuntimeException("Provider " + cls.getName() + " can not be created", ex);
        }
    }

    public static Feature createFeatureInstance(Class<? extends Feature> cls) {
        try {
            Constructor<?> c = ResourceUtils.findResourceConstructor(cls, false);
            if (c == null) {
                throw new RuntimeException("No valid constructor found for " + cls.getName());
            }
            return (Feature)c.newInstance(new Object[0]);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Feature " + cls.getName() + " can not be created", ex);
        }
    }

    private static boolean isValidProvider(Class<?> c) {
        if (c == null || c == Object.class) {
            return false;
        }
        if (c.getAnnotation(Provider.class) != null) {
            return true;
        }
        for (Class<?> itf : c.getInterfaces()) {
            if (!SERVER_PROVIDER_CLASS_NAMES.contains(itf.getName())) continue;
            return true;
        }
        return ResourceUtils.isValidProvider(c.getSuperclass());
    }

    private static void verifySingletons(Set<Object> singletons) {
        if (singletons.isEmpty()) {
            return;
        }
        HashSet<String> map = new HashSet<String>();
        for (Object s : singletons) {
            if (map.contains(s.getClass().getName())) {
                throw new RuntimeException("More than one instance of the same singleton class " + s.getClass().getName() + " is available");
            }
            map.add(s.getClass().getName());
        }
    }

    public static boolean isValidResourceClass(Class<?> c) {
        if (c.isInterface() || Modifier.isAbstract(c.getModifiers())) {
            LOG.info("Ignoring invalid resource class " + c.getName());
            return false;
        }
        return true;
    }

    public static ApplicationPath locateApplicationPath(Class<?> appClass) {
        ApplicationPath appPath = appClass.getAnnotation(ApplicationPath.class);
        if (appPath == null && appClass.getSuperclass() != Application.class) {
            return ResourceUtils.locateApplicationPath(appClass.getSuperclass());
        }
        return appPath;
    }

    private static boolean isValidApplicationClass(Class<?> c, Set<Object> singletons) {
        if (!ResourceUtils.isValidResourceClass(c)) {
            return false;
        }
        for (Object s : singletons) {
            if (c != s.getClass()) continue;
            LOG.info("Ignoring per-request resource class " + c.getName() + " as it is also registered as singleton");
            return false;
        }
        return true;
    }

    static {
        SERVER_PROVIDER_CLASS_NAMES.add("jakarta.ws.rs.ext.MessageBodyWriter");
        SERVER_PROVIDER_CLASS_NAMES.add("jakarta.ws.rs.ext.MessageBodyReader");
        SERVER_PROVIDER_CLASS_NAMES.add("jakarta.ws.rs.ext.ExceptionMapper");
        SERVER_PROVIDER_CLASS_NAMES.add("jakarta.ws.rs.ext.ContextResolver");
        SERVER_PROVIDER_CLASS_NAMES.add("jakarta.ws.rs.ext.ReaderInterceptor");
        SERVER_PROVIDER_CLASS_NAMES.add("jakarta.ws.rs.ext.WriterInterceptor");
        SERVER_PROVIDER_CLASS_NAMES.add("jakarta.ws.rs.ext.ParamConverterProvider");
        SERVER_PROVIDER_CLASS_NAMES.add("jakarta.ws.rs.container.ContainerRequestFilter");
        SERVER_PROVIDER_CLASS_NAMES.add("jakarta.ws.rs.container.ContainerResponseFilter");
        SERVER_PROVIDER_CLASS_NAMES.add("jakarta.ws.rs.container.DynamicFeature");
        SERVER_PROVIDER_CLASS_NAMES.add("jakarta.ws.rs.core.Feature");
        SERVER_PROVIDER_CLASS_NAMES.add("org.apache.cxf.jaxrs.ext.ContextProvider");
    }
}

