/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.BinaryOperatorNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class EqualsNode
extends BinaryOperatorNode {
    @Override
    public void validate(ParseTreeContext context) {
        super.validate(context);
        TypeHelper typeHelper = context.getTypeHelper();
        Object leftType = this.left.getType();
        Object rightType = this.right.getType();
        if (typeHelper.isEnumType(leftType) && !typeHelper.isEnumType(rightType)) {
            throw JPQLException.invalidEnumEqualExpression(context.getQueryInfo(), this.getLine(), this.getColumn(), typeHelper.getTypeName(leftType), typeHelper.getTypeName(rightType));
        }
        if (typeHelper.isEnumType(rightType) && !typeHelper.isEnumType(leftType)) {
            throw JPQLException.invalidEnumEqualExpression(context.getQueryInfo(), this.getLine(), this.getColumn(), typeHelper.getTypeName(rightType), typeHelper.getTypeName(leftType));
        }
        this.setType(typeHelper.getBooleanType());
    }

    @Override
    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getLeft().generateExpression(context);
        whereClause = whereClause.equal(this.getRight().generateExpression(context));
        return whereClause;
    }

    @Override
    public String getAsString() {
        return this.left.getAsString() + " = " + this.right.getAsString();
    }
}

