/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.file.ConfigurationSource;

public class ParameterLimitValve
extends ValveBase {
    private Map<Pattern, Integer[]> urlPatternLimits = new ConcurrentHashMap<Pattern, Integer[]>();
    private String resourcePath = "parameter_limit.config";
    private boolean context = false;

    public ParameterLimitValve() {
        super(true);
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        this.containerLog = LogFactory.getLog((String)(this.getContainer().getLogName() + ".parameterLimit"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        InputStream is;
        block29: {
            super.startInternal();
            is = null;
            if (this.getContainer() instanceof Context) {
                this.context = true;
                String webInfResourcePath = "/WEB-INF/" + this.resourcePath;
                is = ((Context)this.getContainer()).getServletContext().getResourceAsStream(webInfResourcePath);
                if (this.containerLog.isDebugEnabled()) {
                    if (is == null) {
                        this.containerLog.debug((Object)sm.getString("parameterLimitValve.noConfiguration", new Object[]{webInfResourcePath}));
                    } else {
                        this.containerLog.debug((Object)sm.getString("parameterLimitValve.readConfiguration", new Object[]{webInfResourcePath}));
                    }
                }
            } else {
                String resourceName = Container.getConfigPath(this.getContainer(), this.resourcePath);
                try {
                    ConfigurationSource.Resource resource = ConfigFileLoader.getSource().getResource(resourceName);
                    is = resource.getInputStream();
                }
                catch (IOException ioe) {
                    if (!this.containerLog.isDebugEnabled()) break block29;
                    this.containerLog.debug((Object)sm.getString("parameterLimitValve.noConfiguration", new Object[]{resourceName}), (Throwable)ioe);
                }
            }
        }
        if (is == null) {
            return;
        }
        try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(isr);){
            this.setUrlPatternLimits(reader);
        }
        catch (IOException ioe) {
            this.containerLog.error((Object)sm.getString("parameterLimitValve.closeError"), (Throwable)ioe);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                this.containerLog.error((Object)sm.getString("parameterLimitValve.closeError"), (Throwable)ioe);
            }
        }
    }

    public void setUrlPatternLimits(String urlPatternConfig) {
        this.urlPatternLimits.clear();
        this.setUrlPatternLimits(new BufferedReader(new StringReader(urlPatternConfig)));
    }

    public void setUrlPatternLimits(BufferedReader reader) {
        block9: {
            if (this.containerLog == null && this.getContainer() != null) {
                this.containerLog = LogFactory.getLog((String)(this.getContainer().getLogName() + ".parameterLimit"));
            }
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                    int lastEqualsIndex = line.lastIndexOf(61);
                    if (lastEqualsIndex == -1) {
                        throw new IllegalArgumentException(sm.getString("parameterLimitValve.invalidLine", new Object[]{line}));
                    }
                    String patternString = line.substring(0, lastEqualsIndex).trim();
                    String limitsString = line.substring(lastEqualsIndex + 1).trim();
                    Pattern pattern = Pattern.compile(UDecoder.URLDecode((String)patternString, (Charset)StandardCharsets.UTF_8));
                    String[] limits = limitsString.split(",");
                    if (limits.length == 1) {
                        this.urlPatternLimits.put(pattern, new Integer[]{Integer.valueOf(limits[0]), null, null});
                    } else if (limits.length == 3) {
                        this.urlPatternLimits.put(pattern, new Integer[]{Integer.valueOf(limits[0]), Integer.valueOf(limits[1]), Integer.valueOf(limits[2])});
                    } else {
                        throw new IllegalArgumentException(sm.getString("parameterLimitValve.invalidLimitsString", new Object[]{limitsString}));
                    }
                    if (this.containerLog == null || !this.containerLog.isTraceEnabled()) continue;
                    this.containerLog.trace((Object)("Add pattern " + pattern + " and limit(s) " + limitsString));
                }
            }
            catch (IOException ioe) {
                if (this.containerLog == null) break block9;
                this.containerLog.error((Object)sm.getString("parameterLimitValve.readError"), (Throwable)ioe);
            }
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.urlPatternLimits.clear();
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.urlPatternLimits.isEmpty()) {
            this.getNext().invoke(request, response);
            return;
        }
        String requestURI = this.context ? request.getRequestPathMB().toString() : request.getDecodedRequestURI();
        for (Map.Entry<Pattern, Integer[]> entry : this.urlPatternLimits.entrySet()) {
            if (!entry.getKey().matcher(requestURI).matches()) continue;
            Integer[] limits = entry.getValue();
            request.setMaxParameterCount(limits[0]);
            if (limits[1] == null) break;
            request.setMaxPartCount(limits[1]);
            request.setMaxPartHeaderSize(limits[2]);
            break;
        }
        this.getNext().invoke(request, response);
    }
}

