/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves.rewrite;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.connector.Request;
import org.apache.catalina.valves.rewrite.Resolver;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.jsse.PEMFile;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.net.openssl.ciphers.EncryptionLevel;
import org.apache.tomcat.util.net.openssl.ciphers.OpenSSLCipherConfigurationParser;

public class ResolverImpl
extends Resolver {
    protected Request request;

    public ResolverImpl(Request request) {
        this.request = request;
    }

    @Override
    public String resolve(String key) {
        return switch (key) {
            case "HTTP_USER_AGENT" -> this.request.getHeader("user-agent");
            case "HTTP_REFERER" -> this.request.getHeader("referer");
            case "HTTP_COOKIE" -> this.request.getHeader("cookie");
            case "HTTP_FORWARDED" -> this.request.getHeader("forwarded");
            case "HTTP_HOST" -> this.request.getServerName();
            case "HTTP_PROXY_CONNECTION" -> this.request.getHeader("proxy-connection");
            case "HTTP_ACCEPT" -> this.request.getHeader("accept");
            case "REMOTE_ADDR" -> this.request.getRemoteAddr();
            case "REMOTE_HOST" -> this.request.getRemoteHost();
            case "REMOTE_PORT" -> String.valueOf(this.request.getRemotePort());
            case "REMOTE_USER" -> this.request.getRemoteUser();
            case "REMOTE_IDENT" -> this.request.getRemoteUser();
            case "REQUEST_METHOD" -> this.request.getMethod();
            case "SCRIPT_FILENAME" -> this.request.getServletContext().getRealPath(this.request.getServletPath());
            case "REQUEST_PATH" -> this.request.getRequestPathMB().toString();
            case "CONTEXT_PATH" -> this.request.getContextPath();
            case "SERVLET_PATH" -> ResolverImpl.emptyStringIfNull(this.request.getServletPath());
            case "PATH_INFO" -> ResolverImpl.emptyStringIfNull(this.request.getPathInfo());
            case "QUERY_STRING" -> ResolverImpl.emptyStringIfNull(this.request.getQueryString());
            case "AUTH_TYPE" -> this.request.getAuthType();
            case "DOCUMENT_ROOT" -> this.request.getServletContext().getRealPath("/");
            case "SERVER_NAME" -> this.request.getLocalName();
            case "SERVER_ADDR" -> this.request.getLocalAddr();
            case "SERVER_PORT" -> String.valueOf(this.request.getLocalPort());
            case "SERVER_PROTOCOL" -> this.request.getProtocol();
            case "SERVER_SOFTWARE" -> "tomcat";
            case "THE_REQUEST" -> this.request.getMethod() + " " + this.request.getRequestURI() + " " + this.request.getProtocol();
            case "REQUEST_URI" -> this.request.getRequestURI();
            case "REQUEST_FILENAME" -> this.request.getPathTranslated();
            case "HTTPS" -> {
                if (this.request.isSecure()) {
                    yield "on";
                }
                yield "off";
            }
            case "TIME_YEAR" -> String.valueOf(Calendar.getInstance().get(1));
            case "TIME_MON" -> String.valueOf(Calendar.getInstance().get(2));
            case "TIME_DAY" -> String.valueOf(Calendar.getInstance().get(5));
            case "TIME_HOUR" -> String.valueOf(Calendar.getInstance().get(11));
            case "TIME_MIN" -> String.valueOf(Calendar.getInstance().get(12));
            case "TIME_SEC" -> String.valueOf(Calendar.getInstance().get(13));
            case "TIME_WDAY" -> String.valueOf(Calendar.getInstance().get(7));
            case "TIME" -> FastHttpDateFormat.getCurrentDate();
            default -> null;
        };
    }

    @Override
    public String resolveEnv(String key) {
        Object result = this.request.getAttribute(key);
        return result != null ? result.toString() : System.getProperty(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String resolveSsl(String key) {
        SSLSupport sslSupport = (SSLSupport)this.request.getAttribute("jakarta.servlet.request.ssl_session_mgr");
        try {
            if (key.equals("HTTPS")) {
                boolean bl;
                if (sslSupport != null) {
                    bl = true;
                    return String.valueOf(bl);
                }
                bl = false;
                return String.valueOf(bl);
            }
            if (key.equals("SSL_PROTOCOL")) {
                return sslSupport.getProtocol();
            }
            if (key.equals("SSL_SESSION_ID")) {
                return sslSupport.getSessionId();
            }
            if (key.equals("SSL_SESSION_RESUMED")) {
                return null;
            }
            if (key.equals("SSL_SECURE_RENEG")) {
                return null;
            }
            if (key.equals("SSL_COMPRESS_METHOD")) {
                return null;
            }
            if (key.equals("SSL_TLS_SNI")) {
                return null;
            }
            if (key.equals("SSL_CIPHER")) {
                return sslSupport.getCipherSuite();
            }
            if (key.equals("SSL_CIPHER_EXPORT")) {
                String cipherSuite = sslSupport.getCipherSuite();
                if (cipherSuite == null) return null;
                LinkedHashSet<Cipher> cipherList = OpenSSLCipherConfigurationParser.parse(cipherSuite);
                if (cipherList.size() != 1) return null;
                Cipher cipher = (Cipher)((Object)cipherList.iterator().next());
                if (cipher.getLevel().equals((Object)EncryptionLevel.EXP40)) return "true";
                if (!cipher.getLevel().equals((Object)EncryptionLevel.EXP56)) return "false";
                return "true";
            }
            if (key.equals("SSL_CIPHER_ALGKEYSIZE")) {
                String cipherSuite = sslSupport.getCipherSuite();
                if (cipherSuite == null) return null;
                LinkedHashSet<Cipher> cipherList = OpenSSLCipherConfigurationParser.parse(cipherSuite);
                if (cipherList.size() != 1) return null;
                Cipher cipher = (Cipher)((Object)cipherList.iterator().next());
                return String.valueOf(cipher.getAlg_bits());
            }
            if (key.equals("SSL_CIPHER_USEKEYSIZE")) {
                Integer keySize = sslSupport.getKeySize();
                if (keySize == null) {
                    return null;
                }
                String string = sslSupport.getKeySize().toString();
                return string;
            }
            if (key.startsWith("SSL_CLIENT_")) {
                X509Certificate[] certificates = sslSupport.getPeerCertificateChain();
                if (certificates == null) return null;
                if (certificates.length <= 0) return null;
                String result = this.resolveSslCertificates(key = key.substring("SSL_CLIENT_".length()), certificates);
                if (result != null) {
                    return result;
                }
                if (key.startsWith("SAN_OTHER_msUPN_")) {
                    key = key.substring("SAN_OTHER_msUPN_".length());
                    return null;
                }
                if (key.equals("CERT_RFC4523_CEA")) {
                    return null;
                }
            } else {
                if (!key.startsWith("SSL_SERVER_")) return null;
                X509Certificate[] certificates = sslSupport.getLocalCertificateChain();
                if (certificates == null) return null;
                if (certificates.length <= 0) return null;
                String result = this.resolveSslCertificates(key = key.substring("SSL_SERVER_".length()), certificates);
                if (result != null) {
                    return result;
                }
                if (!key.startsWith("SAN_OTHER_dnsSRV_")) return null;
                key = key.substring("SAN_OTHER_dnsSRV_".length());
                return null;
            }
            if (!key.equals("VERIFY")) return null;
            return null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private String resolveSslCertificates(String key, X509Certificate[] certificates) {
        if (key.equals("M_VERSION")) {
            return String.valueOf(certificates[0].getVersion());
        }
        if (key.equals("M_SERIAL")) {
            return certificates[0].getSerialNumber().toString();
        }
        if (key.equals("S_DN")) {
            return certificates[0].getSubjectX500Principal().toString();
        }
        if (key.startsWith("S_DN_")) {
            key = key.substring("S_DN_".length());
            return this.resolveComponent(certificates[0].getSubjectX500Principal().getName(), key);
        }
        if (key.startsWith("SAN_Email_")) {
            key = key.substring("SAN_Email_".length());
            return this.resolveAlternateName(certificates[0], 1, Integer.parseInt(key));
        }
        if (key.startsWith("SAN_DNS_")) {
            key = key.substring("SAN_DNS_".length());
            return this.resolveAlternateName(certificates[0], 2, Integer.parseInt(key));
        }
        if (key.equals("I_DN")) {
            return certificates[0].getIssuerX500Principal().getName();
        }
        if (key.startsWith("I_DN_")) {
            key = key.substring("I_DN_".length());
            return this.resolveComponent(certificates[0].getIssuerX500Principal().toString(), key);
        }
        if (key.equals("V_START")) {
            return String.valueOf(certificates[0].getNotBefore().getTime());
        }
        if (key.equals("V_END")) {
            return String.valueOf(certificates[0].getNotAfter().getTime());
        }
        if (key.equals("V_REMAIN")) {
            long remain = certificates[0].getNotAfter().getTime() - System.currentTimeMillis();
            if (remain < 0L) {
                remain = 0L;
            }
            return String.valueOf(TimeUnit.MILLISECONDS.toDays(remain));
        }
        if (key.equals("A_SIG")) {
            return certificates[0].getSigAlgName();
        }
        if (key.equals("A_KEY")) {
            return certificates[0].getPublicKey().getAlgorithm();
        }
        if (key.equals("CERT")) {
            try {
                return PEMFile.toPEM(certificates[0]);
            }
            catch (CertificateEncodingException certificateEncodingException) {
            }
        } else if (key.startsWith("CERT_CHAIN_")) {
            key = key.substring("CERT_CHAIN_".length());
            try {
                return PEMFile.toPEM(certificates[Integer.parseInt(key)]);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException | CertificateEncodingException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String resolveComponent(String fullDN, String component) {
        HashMap<String, String> components = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(fullDN, ",");
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken().trim();
            int pos = token.indexOf(61);
            if (pos <= 0 || pos + 1 >= token.length()) continue;
            components.put(token.substring(0, pos), token.substring(pos + 1));
        }
        return (String)components.get(component);
    }

    private String resolveAlternateName(X509Certificate certificate, int type, int n) {
        try {
            Collection<List<?>> alternateNames = certificate.getSubjectAlternativeNames();
            if (alternateNames != null) {
                ArrayList<String> elements = new ArrayList<String>();
                for (List<?> alternateName : alternateNames) {
                    Integer alternateNameType = (Integer)alternateName.get(0);
                    if (alternateNameType != type) continue;
                    elements.add(String.valueOf(alternateName.get(1)));
                }
                if (elements.size() > n) {
                    return (String)elements.get(n);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException | CertificateParsingException exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String resolveHttp(String key) {
        return Objects.requireNonNullElse(this.request.getHeader(key), "");
    }

    @Override
    public boolean resolveResource(int type, String name) {
        WebResourceRoot resources = this.request.getContext().getResources();
        WebResource resource = resources.getResource(name);
        if (!resource.exists()) {
            return false;
        }
        return switch (type) {
            case 0 -> resource.isDirectory();
            case 1 -> resource.isFile();
            case 2 -> {
                if (resource.isFile() && resource.getContentLength() > 0L) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static String emptyStringIfNull(String value) {
        return Objects.requireNonNullElse(value, "");
    }

    @Override
    public Charset getUriCharset() {
        return this.request.getConnector().getURICharset();
    }
}

