/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class TcclThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public TcclThreadFactory() {
        this("pool-" + poolNumber.getAndIncrement() + "-thread-");
    }

    public TcclThreadFactory(String namePrefix) {
        this.group = Thread.currentThread().getThreadGroup();
        this.namePrefix = namePrefix;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement());
        t.setContextClassLoader(this.getClass().getClassLoader());
        t.setDaemon(true);
        return t;
    }
}

