/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.Util;
import java.lang.reflect.Method;
import java.util.Objects;

public class RecordELResolver
extends ELResolver {
    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof Record && property != null) {
            Method method;
            context.setPropertyResolved(base, property);
            String propertyName = property.toString();
            try {
                method = base.getClass().getMethod(propertyName, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw new PropertyNotFoundException(Util.message(context, "propertyNotFound", base.getClass().getName(), propertyName), nsme);
            }
            try {
                return method.invoke(base, new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new ELException(Util.message(context, "propertyReadError", base.getClass().getName(), propertyName), e);
            }
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof Record && property != null) {
            context.setPropertyResolved(base, property);
            String propertyName = property.toString();
            try {
                base.getClass().getMethod(propertyName, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw new PropertyNotFoundException(Util.message(context, "propertyNotFound", base.getClass().getName(), propertyName), nsme);
            }
        }
        return null;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        Objects.requireNonNull(context);
        if (base instanceof Record && property != null) {
            context.setPropertyResolved(base, property);
            String propertyName = property.toString();
            try {
                base.getClass().getMethod(propertyName, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw new PropertyNotFoundException(Util.message(context, "propertyNotFound", base.getClass().getName(), propertyName), nsme);
            }
            throw new PropertyNotWritableException(Util.message(context, "resolverNotWritable", base.getClass().getName()));
        }
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        Objects.requireNonNull(context);
        if (base instanceof Record && property != null) {
            context.setPropertyResolved(base, property);
            String propertyName = property.toString();
            try {
                base.getClass().getMethod(propertyName, new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                throw new PropertyNotFoundException(Util.message(context, "propertyNotFound", base.getClass().getName(), propertyName), nsme);
            }
            return true;
        }
        return false;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof Record) {
            return Object.class;
        }
        return null;
    }
}

