/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.jsp.JspApplicationContext;
import jakarta.servlet.jsp.JspEngineInfo;
import jakarta.servlet.jsp.JspFactory;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import org.apache.jasper.runtime.JspApplicationContextImpl;
import org.apache.jasper.runtime.PageContextImpl;

public class JspFactoryImpl
extends JspFactory {
    private final ThreadLocal<PageContextPool> localPool = new ThreadLocal();
    private int poolSize = -1;

    public PageContext getPageContext(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoflush) {
        PageContextImpl pc;
        if (this.poolSize > 0) {
            PageContextPool pool = this.localPool.get();
            if (pool == null) {
                pool = new PageContextPool(this.poolSize);
                this.localPool.set(pool);
            }
            if ((pc = pool.get()) == null) {
                pc = new PageContextImpl();
            }
        } else {
            pc = new PageContextImpl();
        }
        try {
            pc.initialize(servlet, request, response, errorPageURL, needsSession, bufferSize, autoflush);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pc;
    }

    public void releasePageContext(PageContext pc) {
        if (pc == null) {
            return;
        }
        pc.release();
        if (this.poolSize > 0 && pc instanceof PageContextImpl) {
            this.localPool.get().put(pc);
        }
    }

    public JspEngineInfo getEngineInfo() {
        return new JspEngineInfo(){

            public String getSpecificationVersion() {
                return "4.0";
            }
        };
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public JspApplicationContext getJspApplicationContext(ServletContext context) {
        return JspApplicationContextImpl.getInstance(context);
    }

    private static final class PageContextPool {
        private final PageContext[] pool;
        private int current = -1;

        PageContextPool(int poolSize) {
            this.pool = new PageContext[poolSize];
        }

        public void put(PageContext o) {
            if (this.current < this.pool.length - 1) {
                ++this.current;
                this.pool[this.current] = o;
            }
        }

        public PageContext get() {
            PageContext item = null;
            if (this.current >= 0) {
                item = this.pool[this.current];
                --this.current;
            }
            return item;
        }
    }
}

