/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.ExceptionLabel;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public abstract class StatementWithFinallyBlock
extends Statement {
    ExceptionLabel anyExceptionLabel;

    public static void reenterAllExceptionHandlers(StatementWithFinallyBlock[] statements, int max, CodeStream codeStream) {
        if (statements == null) {
            return;
        }
        if (max < 0) {
            max = statements.length;
        }
        int i = 0;
        while (i < max) {
            StatementWithFinallyBlock stmt = statements[i];
            stmt.enterAnyExceptionHandler(codeStream);
            stmt.enterDeclaredExceptionHandlers(codeStream);
            stmt.enterResourceExceptionHandlers(codeStream);
            ++i;
        }
    }

    public ExceptionLabel enterAnyExceptionHandler(CodeStream codeStream) {
        if (this.anyExceptionLabel == null) {
            this.anyExceptionLabel = new ExceptionLabel(codeStream, null);
        }
        this.anyExceptionLabel.placeStart();
        return this.anyExceptionLabel;
    }

    public void enterDeclaredExceptionHandlers(CodeStream codeStream) {
    }

    public void enterResourceExceptionHandlers(CodeStream codeStream) {
    }

    public void exitAnyExceptionHandler() {
        if (this.anyExceptionLabel != null) {
            this.anyExceptionLabel.placeEnd();
        }
    }

    public void exitDeclaredExceptionHandlers(CodeStream codeStream) {
    }

    public abstract boolean generateFinallyBlock(BlockScope var1, CodeStream var2, int var3);

    public abstract boolean isFinallyBlockEscaping();

    public void placeAllAnyExceptionHandler() {
        this.anyExceptionLabel.place();
    }
}

