/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.collections;

import java.util.LinkedHashMap;
import java.util.Map;

public class ConcurrentLruCache<T> {
    private volatile LimitedLinkedHashMap<T, T> map;
    private final Object lock = new Object();

    public ConcurrentLruCache(int limit) {
        this.setLimit(limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T entry) {
        if (this.map == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.map == null) {
                return;
            }
            this.map.put(entry, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(T entry) {
        if (this.map == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.map == null) {
                return false;
            }
            return this.map.get(entry) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this.map == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.map == null) {
                return;
            }
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLimit(int limit) {
        Object object = this.lock;
        synchronized (object) {
            if (limit > 0) {
                LimitedLinkedHashMap<T, T> oldMap = this.map;
                this.map = new LimitedLinkedHashMap(limit);
                if (oldMap != null) {
                    this.map.putAll(oldMap);
                }
            } else {
                this.map = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLimit() {
        Object object = this.lock;
        synchronized (object) {
            if (this.map == null) {
                return -1;
            }
            return this.map.getLimit();
        }
    }

    private static class LimitedLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int limit;

        LimitedLinkedHashMap(int limit) {
            super(16, 0.75f, true);
            this.limit = limit;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.limit;
        }

        private int getLimit() {
            return this.limit;
        }
    }
}

