/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.HttpServiceTask;
import org.flowable.bpmn.model.MapExceptionEntry;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.util.JsonConverterUtil;

public class ServiceTaskJsonConverter
extends BaseBpmnJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        ServiceTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        ServiceTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("ServiceTask", ServiceTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(ServiceTask.class, ServiceTaskJsonConverter.class);
        convertersToJsonMap.put(HttpServiceTask.class, ServiceTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "ServiceTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
        ServiceTask serviceTask = (ServiceTask)baseElement;
        this.setPropertyValue("skipexpression", serviceTask.getSkipExpression(), propertiesNode);
        if ("mail".equalsIgnoreCase(serviceTask.getType())) {
            this.setPropertyFieldValue("mailtaskheaders", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskto", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskfrom", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtasksubject", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskcc", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskbcc", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtasktext", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskhtml", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskhtmlvar", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtasktextvar", serviceTask, propertiesNode);
            this.setPropertyFieldValue("mailtaskcharset", serviceTask, propertiesNode);
        } else if ("camel".equalsIgnoreCase(serviceTask.getType())) {
            this.setPropertyFieldValue("cameltaskcamelcontext", "camelContext", serviceTask, propertiesNode);
        } else if ("mule".equalsIgnoreCase(serviceTask.getType())) {
            this.setPropertyFieldValue("muletaskendpointurl", "endpointUrl", serviceTask, propertiesNode);
            this.setPropertyFieldValue("muletasklanguage", "language", serviceTask, propertiesNode);
            this.setPropertyFieldValue("muletaskpayloadexpression", "payloadExpression", serviceTask, propertiesNode);
            this.setPropertyFieldValue("muletaskresultvariable", "resultVariable", serviceTask, propertiesNode);
        } else if ("dmn".equalsIgnoreCase(serviceTask.getType())) {
            for (FieldExtension fieldExtension : serviceTask.getFieldExtensions()) {
                if ("decisionTableReferenceKey".equals(fieldExtension.getFieldName())) {
                    Map<String, String> decisionServiceModelInfo = converterContext.getDecisionServiceModelInfoForDecisionServiceModelKey(fieldExtension.getStringValue());
                    if (decisionServiceModelInfo != null) {
                        ObjectNode decisionServiceReferenceNode = JSON_MAPPER.createObjectNode();
                        propertiesNode.set("decisiontaskdecisionservicereference", (JsonNode)decisionServiceReferenceNode);
                        decisionServiceReferenceNode.put("id", decisionServiceModelInfo.get("id"));
                        decisionServiceReferenceNode.put("name", decisionServiceModelInfo.get("name"));
                        decisionServiceReferenceNode.put("key", decisionServiceModelInfo.get("key"));
                    } else {
                        Map<String, String> decisionTableModelInfo = converterContext.getDecisionTableModelInfoForDecisionTableModelKey(fieldExtension.getStringValue());
                        if (decisionTableModelInfo != null) {
                            ObjectNode decisionTableReferenceNode = JSON_MAPPER.createObjectNode();
                            propertiesNode.set("decisiontaskdecisiontablereference", (JsonNode)decisionTableReferenceNode);
                            decisionTableReferenceNode.put("id", decisionTableModelInfo.get("id"));
                            decisionTableReferenceNode.put("name", decisionTableModelInfo.get("name"));
                            decisionTableReferenceNode.put("key", decisionTableModelInfo.get("key"));
                        }
                    }
                } else if ("decisionTaskThrowErrorOnNoHits".equals(fieldExtension.getFieldName())) {
                    propertiesNode.set("decisiontaskthrowerroronnohits", (JsonNode)BooleanNode.valueOf((boolean)Boolean.parseBoolean(fieldExtension.getStringValue())));
                }
                if ("fallbackToDefaultTenant".equals(fieldExtension.getFieldName())) {
                    propertiesNode.set("decisiontaskfallbacktodefaulttenant", (JsonNode)BooleanNode.valueOf((boolean)Boolean.parseBoolean(fieldExtension.getStringValue())));
                }
                if (!"sameDeployment".equals(fieldExtension.getFieldName())) continue;
                propertiesNode.set("decisiontasksamedeployment", (JsonNode)BooleanNode.valueOf((boolean)Boolean.parseBoolean(fieldExtension.getStringValue())));
            }
        } else if ("http".equalsIgnoreCase(serviceTask.getType())) {
            this.setPropertyFieldValue("httptaskrequestmethod", "requestMethod", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskrequesturl", "requestUrl", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskrequestheaders", "requestHeaders", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskrequestbody", "requestBody", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskrequestbodyencoding", "requestBodyEncoding", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskrequesttimeout", "requestTimeout", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskdisallowredirects", "disallowRedirects", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskfailstatuscodes", "failStatusCodes", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskhandlestatuscodes", "handleStatusCodes", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskresponsevariablename", "responseVariableName", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskignoreexception", "ignoreException", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptasksaverequestvariables", "saveRequestVariables", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptasksaveresponseparameters", "saveResponseParameters", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptaskresultvariableprefix", "resultVariablePrefix", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptasksaveresponseparameterstransient", "saveResponseParametersTransient", serviceTask, propertiesNode);
            this.setPropertyFieldValue("httptasksaveresponseasjson", "saveResponseVariableAsJson", serviceTask, propertiesNode);
            Boolean parallelInSameTransaction = ((HttpServiceTask)serviceTask).getParallelInSameTransaction();
            if (parallelInSameTransaction != null) {
                this.setPropertyValue("httptaskparallelinsametransaction", parallelInSameTransaction.toString(), propertiesNode);
            }
        } else if ("shell".equalsIgnoreCase(serviceTask.getType())) {
            this.setPropertyFieldValue("shellcommand", "command", serviceTask, propertiesNode);
            this.setPropertyFieldValue("shellarg1", "arg1", serviceTask, propertiesNode);
            this.setPropertyFieldValue("shellarg2", "arg2", serviceTask, propertiesNode);
            this.setPropertyFieldValue("shellarg3", "arg3", serviceTask, propertiesNode);
            this.setPropertyFieldValue("shellarg4", "arg4", serviceTask, propertiesNode);
            this.setPropertyFieldValue("shellarg5", "arg5", serviceTask, propertiesNode);
            this.setPropertyFieldValue("shellcleanenv", "cleanEnv", serviceTask, propertiesNode);
            this.setPropertyFieldValue("shelldirectory", "directory", serviceTask, propertiesNode);
            this.setPropertyFieldValue("shellerrorcodevariable", "errorCodeVariable", serviceTask, propertiesNode);
            this.setPropertyFieldValue("shellerrorredirect", "errorRedirect", serviceTask, propertiesNode);
            this.setPropertyFieldValue("shelloutputvariable", "outputVariable", serviceTask, propertiesNode);
            this.setPropertyFieldValue("shellwait", "wait", serviceTask, propertiesNode);
        } else {
            if ("class".equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskclass", serviceTask.getImplementation());
            } else if ("expression".equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskexpression", serviceTask.getImplementation());
            } else if ("delegateExpression".equals(serviceTask.getImplementationType())) {
                propertiesNode.put("servicetaskdelegateexpression", serviceTask.getImplementation());
            }
            if (serviceTask.isTriggerable()) {
                propertiesNode.put("servicetasktriggerable", serviceTask.isTriggerable());
            }
            if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) {
                propertiesNode.put("servicetaskresultvariable", serviceTask.getResultVariableName());
            }
            if (serviceTask.isUseLocalScopeForResultVariable()) {
                propertiesNode.put("servicetaskuselocalscopeforresultvariable", serviceTask.isUseLocalScopeForResultVariable());
            }
            if (serviceTask.isStoreResultVariableAsTransient()) {
                propertiesNode.put("servicetaskstoreresultvariabletransient", serviceTask.isStoreResultVariableAsTransient());
            }
            if (StringUtils.isNotEmpty((CharSequence)serviceTask.getFailedJobRetryTimeCycleValue())) {
                propertiesNode.put("servicetaskfailedjobretrytimecycle", serviceTask.getFailedJobRetryTimeCycleValue());
            }
            this.addFieldExtensions(serviceTask.getFieldExtensions(), propertiesNode);
            this.addMapException(serviceTask.getMapExceptions(), propertiesNode);
        }
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        JsonNode itemsArrayNode;
        JsonNode exceptionsNode;
        JsonNode itemsArrayNode2;
        ServiceTask task = new ServiceTask();
        if (StringUtils.isNotEmpty((CharSequence)JsonConverterUtil.getPropertyValueAsString("servicetaskclass", elementNode))) {
            task.setImplementationType("class");
            task.setImplementation(JsonConverterUtil.getPropertyValueAsString("servicetaskclass", elementNode));
        } else if (StringUtils.isNotEmpty((CharSequence)JsonConverterUtil.getPropertyValueAsString("servicetaskexpression", elementNode))) {
            task.setImplementationType("expression");
            task.setImplementation(JsonConverterUtil.getPropertyValueAsString("servicetaskexpression", elementNode));
        } else if (StringUtils.isNotEmpty((CharSequence)JsonConverterUtil.getPropertyValueAsString("servicetaskdelegateexpression", elementNode))) {
            task.setImplementationType("delegateExpression");
            task.setImplementation(JsonConverterUtil.getPropertyValueAsString("servicetaskdelegateexpression", elementNode));
        }
        if (JsonConverterUtil.getPropertyValueAsBoolean("servicetasktriggerable", elementNode)) {
            task.setTriggerable(true);
        }
        if (StringUtils.isNotEmpty((CharSequence)JsonConverterUtil.getPropertyValueAsString("servicetaskresultvariable", elementNode))) {
            task.setResultVariableName(JsonConverterUtil.getPropertyValueAsString("servicetaskresultvariable", elementNode));
        }
        if (JsonConverterUtil.getPropertyValueAsBoolean("servicetaskuselocalscopeforresultvariable", elementNode)) {
            task.setUseLocalScopeForResultVariable(true);
        }
        if (JsonConverterUtil.getPropertyValueAsBoolean("servicetaskstoreresultvariabletransient", elementNode)) {
            task.setStoreResultVariableAsTransient(true);
        }
        if (StringUtils.isNotEmpty((CharSequence)JsonConverterUtil.getPropertyValueAsString("servicetaskfailedjobretrytimecycle", elementNode))) {
            task.setFailedJobRetryTimeCycleValue(JsonConverterUtil.getPropertyValueAsString("servicetaskfailedjobretrytimecycle", elementNode));
        }
        task.setSkipExpression(JsonConverterUtil.getPropertyValueAsString("skipexpression", elementNode));
        JsonNode fieldsNode = JsonConverterUtil.getProperty("servicetaskfields", elementNode);
        if (fieldsNode != null && (itemsArrayNode2 = fieldsNode.get("fields")) != null) {
            for (JsonNode itemNode : itemsArrayNode2) {
                JsonNode nameNode = itemNode.get("name");
                if (nameNode == null || !StringUtils.isNotEmpty((CharSequence)nameNode.asText())) continue;
                FieldExtension field = new FieldExtension();
                field.setFieldName(nameNode.asText());
                if (StringUtils.isNotEmpty((CharSequence)ServiceTaskJsonConverter.getValueAsString("stringValue", itemNode))) {
                    field.setStringValue(ServiceTaskJsonConverter.getValueAsString("stringValue", itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)ServiceTaskJsonConverter.getValueAsString("string", itemNode))) {
                    field.setStringValue(ServiceTaskJsonConverter.getValueAsString("string", itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)ServiceTaskJsonConverter.getValueAsString("expression", itemNode))) {
                    field.setExpression(ServiceTaskJsonConverter.getValueAsString("expression", itemNode));
                }
                task.getFieldExtensions().add(field);
            }
        }
        if ((exceptionsNode = JsonConverterUtil.getProperty("servicetaskexceptions", elementNode)) != null && (itemsArrayNode = exceptionsNode.get("exceptions")) != null) {
            for (JsonNode itemNode : itemsArrayNode) {
                MapExceptionEntry exception = new MapExceptionEntry();
                exception.setClassName(ServiceTaskJsonConverter.getValueAsString("class", itemNode));
                exception.setErrorCode(ServiceTaskJsonConverter.getValueAsString("code", itemNode));
                exception.setAndChildren(ServiceTaskJsonConverter.getValueAsBoolean("children", itemNode));
                task.getMapExceptions().add(exception);
            }
        }
        return task;
    }

    protected void setPropertyFieldValue(String name, ServiceTask task, ObjectNode propertiesNode) {
        for (FieldExtension extension : task.getFieldExtensions()) {
            if (!name.substring(8).equalsIgnoreCase(extension.getFieldName())) continue;
            if (StringUtils.isNotEmpty((CharSequence)extension.getStringValue())) {
                this.setPropertyValue(name, extension.getStringValue(), propertiesNode);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)extension.getExpression())) continue;
            this.setPropertyValue(name, extension.getExpression(), propertiesNode);
        }
    }

    protected void setPropertyFieldValue(String propertyName, String fieldName, ServiceTask task, ObjectNode propertiesNode) {
        for (FieldExtension extension : task.getFieldExtensions()) {
            if (!fieldName.equalsIgnoreCase(extension.getFieldName())) continue;
            if (StringUtils.isNotEmpty((CharSequence)extension.getStringValue())) {
                this.setPropertyValue(propertyName, extension.getStringValue(), propertiesNode);
                continue;
            }
            if (!StringUtils.isNotEmpty((CharSequence)extension.getExpression())) continue;
            this.setPropertyValue(propertyName, extension.getExpression(), propertiesNode);
        }
    }
}

