/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.fault;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.server.fault.ProcessTerminatingFaultHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public final class ProcessTerminatingFaultHandlerTest {
    private static Exit.Procedure terminatingProcedure(AtomicBoolean called) {
        return (statusCode, message) -> {
            Assertions.assertEquals((int)1, (int)statusCode);
            Assertions.assertNull((Object)message);
            called.set(true);
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExitIsCalled() {
        AtomicBoolean exitCalled = new AtomicBoolean(false);
        Exit.setExitProcedure((Exit.Procedure)ProcessTerminatingFaultHandlerTest.terminatingProcedure(exitCalled));
        AtomicBoolean actionCalled = new AtomicBoolean(false);
        Runnable action = () -> {
            Assertions.assertFalse((boolean)exitCalled.get());
            actionCalled.set(true);
        };
        try {
            new ProcessTerminatingFaultHandler.Builder().setShouldHalt(false).setAction(action).build().handleFault("", null);
        }
        finally {
            Exit.resetExitProcedure();
        }
        Assertions.assertTrue((boolean)exitCalled.get());
        Assertions.assertTrue((boolean)actionCalled.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHaltIsCalled() {
        AtomicBoolean haltCalled = new AtomicBoolean(false);
        Exit.setHaltProcedure((Exit.Procedure)ProcessTerminatingFaultHandlerTest.terminatingProcedure(haltCalled));
        AtomicBoolean actionCalled = new AtomicBoolean(false);
        Runnable action = () -> {
            Assertions.assertFalse((boolean)haltCalled.get());
            actionCalled.set(true);
        };
        try {
            new ProcessTerminatingFaultHandler.Builder().setAction(action).build().handleFault("", null);
        }
        finally {
            Exit.resetHaltProcedure();
        }
        Assertions.assertTrue((boolean)haltCalled.get());
        Assertions.assertTrue((boolean)actionCalled.get());
    }
}

