/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.web.support;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecution;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceProperty;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.support.filters.ResponseHeadersEnforcementFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.http.HttpStatus;

public class RegisteredServiceResponseHeadersEnforcementFilter
extends ResponseHeadersEnforcementFilter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RegisteredServiceResponseHeadersEnforcementFilter.class);
    private final ObjectProvider<ServicesManager> servicesManagerProvider;
    private final ObjectProvider<ArgumentExtractor> argumentExtractor;
    private final ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies;
    private final ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer;
    private final WebEndpointProperties webEndpointProperties;

    private static String getStringProperty(Optional<RegisteredService> result, RegisteredServiceProperty.RegisteredServiceProperties property) {
        if (result.isPresent()) {
            RegisteredService registeredService = result.get();
            LOGGER.trace("Resolved registered service [{}] from request to enforce response headers", (Object)registeredService);
            Map properties = registeredService.getProperties();
            if (!properties.containsKey(property.getPropertyName())) {
                LOGGER.trace("Resolved registered service [{}] from request does not contain a property definition for [{}]", (Object)registeredService.getName(), (Object)property.getPropertyName());
                return null;
            }
            RegisteredServiceProperty prop = (RegisteredServiceProperty)properties.get(property.getPropertyName());
            return prop.value();
        }
        LOGGER.trace("Resolved registered service from request can not be located");
        return null;
    }

    private static Optional<Boolean> shouldHttpHeaderBeInjectedIntoResponse(Optional<RegisteredService> registeredService, RegisteredServiceProperty.RegisteredServiceProperties property) {
        String propValue = RegisteredServiceResponseHeadersEnforcementFilter.getStringProperty(registeredService, property);
        if (propValue != null) {
            return Optional.of(BooleanUtils.toBoolean((String)propValue));
        }
        return Optional.empty();
    }

    @Override
    protected Optional<RegisteredService> prepareFilterBeforeExecution(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) throws Throwable {
        String basePath = this.webEndpointProperties.getBasePath();
        if (httpServletRequest.getRequestURI().contains(basePath)) {
            return Optional.empty();
        }
        WebApplicationService service = ((ArgumentExtractor)this.argumentExtractor.getObject()).extractService(httpServletRequest);
        if (service != null) {
            LOGGER.trace("Attempting to resolve service for [{}]", (Object)service);
            Service resolved = ((AuthenticationServiceSelectionPlan)this.authenticationRequestServiceSelectionStrategies.getObject()).resolveService((Service)service);
            ServicesManager servicesManager = (ServicesManager)this.servicesManagerProvider.getObject();
            RegisteredService registeredService = NumberUtils.isCreatable((String)resolved.getId()) ? servicesManager.findServiceBy(Long.parseLong(resolved.getId())) : servicesManager.findServiceBy(resolved);
            AuditableContext audit = AuditableContext.builder().registeredService(registeredService).service((Service)service).build();
            AuditableExecutionResult accessResult = ((AuditableExecution)this.registeredServiceAccessStrategyEnforcer.getObject()).execute(audit);
            if (accessResult.isExecutionFailure()) {
                LOGGER.warn("Service [{}] is not authorized", (Object)resolved);
                httpServletResponse.setStatus(HttpStatus.FORBIDDEN.value());
                httpServletRequest.setAttribute("jakarta.servlet.error.exception", accessResult.getException().orElse(null));
                return Optional.empty();
            }
            return Optional.of(registeredService);
        }
        return Optional.empty();
    }

    @Override
    protected void decideInsertContentSecurityPolicyHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, Optional<RegisteredService> result) {
        Optional<Boolean> shouldInject = RegisteredServiceResponseHeadersEnforcementFilter.shouldHttpHeaderBeInjectedIntoResponse(result, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_ENABLE_CONTENT_SECURITY_POLICY);
        if (shouldInject.isPresent()) {
            if (shouldInject.get().booleanValue()) {
                this.insertContentSecurityPolicyHeader(httpServletResponse, httpServletRequest);
            } else {
                LOGGER.trace("ContentSecurityPolicy header disabled by service definition");
            }
        } else {
            super.decideInsertContentSecurityPolicyHeader(httpServletResponse, httpServletRequest, result);
        }
    }

    @Override
    protected void decideInsertXSSProtectionHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, Optional<RegisteredService> result) {
        Optional<Boolean> shouldInject = RegisteredServiceResponseHeadersEnforcementFilter.shouldHttpHeaderBeInjectedIntoResponse(result, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_ENABLE_XSS_PROTECTION);
        if (shouldInject.isPresent()) {
            if (shouldInject.get().booleanValue()) {
                this.insertXSSProtectionHeader(httpServletResponse, httpServletRequest);
            } else {
                LOGGER.trace("XSSProtection header disabled by service definition");
            }
        } else {
            super.decideInsertXSSProtectionHeader(httpServletResponse, httpServletRequest, result);
        }
    }

    @Override
    protected void decideInsertXFrameOptionsHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, Optional<RegisteredService> result) {
        Optional<Boolean> shouldInject = RegisteredServiceResponseHeadersEnforcementFilter.shouldHttpHeaderBeInjectedIntoResponse(result, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_ENABLE_XFRAME_OPTIONS);
        if (shouldInject.isPresent()) {
            if (shouldInject.get().booleanValue()) {
                String xFrameOptions = RegisteredServiceResponseHeadersEnforcementFilter.getStringProperty(result, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_XFRAME_OPTIONS);
                this.insertXFrameOptionsHeader(httpServletResponse, httpServletRequest, xFrameOptions);
            } else {
                LOGGER.trace("XFrameOptions header disabled by service definition");
            }
        } else {
            super.decideInsertXFrameOptionsHeader(httpServletResponse, httpServletRequest, result);
        }
    }

    @Override
    protected void decideInsertXContentTypeOptionsHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, Optional<RegisteredService> result) {
        Optional<Boolean> shouldInject = RegisteredServiceResponseHeadersEnforcementFilter.shouldHttpHeaderBeInjectedIntoResponse(result, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_ENABLE_XCONTENT_OPTIONS);
        if (shouldInject.isPresent()) {
            if (shouldInject.get().booleanValue()) {
                this.insertXContentTypeOptionsHeader(httpServletResponse, httpServletRequest);
            } else {
                LOGGER.trace("XContentOptions header disabled by service definition");
            }
        } else {
            super.decideInsertXContentTypeOptionsHeader(httpServletResponse, httpServletRequest, result);
        }
    }

    @Override
    protected void decideInsertCacheControlHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, Optional<RegisteredService> result) {
        Optional<Boolean> shouldInject = RegisteredServiceResponseHeadersEnforcementFilter.shouldHttpHeaderBeInjectedIntoResponse(result, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_ENABLE_CACHE_CONTROL);
        if (shouldInject.isPresent()) {
            if (shouldInject.get().booleanValue()) {
                this.insertCacheControlHeader(httpServletResponse, httpServletRequest);
            } else {
                LOGGER.trace("EnableCacheControl header disabled by service definition");
            }
        } else {
            super.decideInsertCacheControlHeader(httpServletResponse, httpServletRequest, result);
        }
    }

    @Override
    protected void decideInsertStrictTransportSecurityHeader(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, Optional<RegisteredService> result) {
        Optional<Boolean> shouldInject = RegisteredServiceResponseHeadersEnforcementFilter.shouldHttpHeaderBeInjectedIntoResponse(result, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_ENABLE_STRICT_TRANSPORT_SECURITY);
        if (shouldInject.isPresent()) {
            if (shouldInject.get().booleanValue()) {
                String headerValue = (String)StringUtils.defaultIfBlank((CharSequence)RegisteredServiceResponseHeadersEnforcementFilter.getStringProperty(result, RegisteredServiceProperty.RegisteredServiceProperties.HTTP_HEADER_STRICT_TRANSPORT_SECURITY), (CharSequence)this.getStrictTransportSecurityHeader());
                this.insertStrictTransportSecurityHeader(httpServletResponse, httpServletRequest, headerValue);
            } else {
                LOGGER.trace("StrictTransportSecurity header disabled by service definition");
            }
        } else {
            super.decideInsertStrictTransportSecurityHeader(httpServletResponse, httpServletRequest, result);
        }
    }

    @Generated
    public RegisteredServiceResponseHeadersEnforcementFilter(ObjectProvider<ServicesManager> servicesManagerProvider, ObjectProvider<ArgumentExtractor> argumentExtractor, ObjectProvider<AuthenticationServiceSelectionPlan> authenticationRequestServiceSelectionStrategies, ObjectProvider<AuditableExecution> registeredServiceAccessStrategyEnforcer, WebEndpointProperties webEndpointProperties) {
        this.servicesManagerProvider = servicesManagerProvider;
        this.argumentExtractor = argumentExtractor;
        this.authenticationRequestServiceSelectionStrategies = authenticationRequestServiceSelectionStrategies;
        this.registeredServiceAccessStrategyEnforcer = registeredServiceAccessStrategyEnforcer;
        this.webEndpointProperties = webEndpointProperties;
    }
}

