/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.attrvalue.PlainAttrValidationManager;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.DynRealmDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmSearchDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.AttrCond;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.dao.AbstractJPAAnySearchDAO;
import org.apache.syncope.core.persistence.jpa.dao.AnySearchNode;
import org.apache.syncope.core.persistence.jpa.dao.OrderBySupport;
import org.apache.syncope.core.persistence.jpa.dao.SearchSupport;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.springframework.data.domain.Sort;

public class MariaDBJPAAnySearchDAO
extends AbstractJPAAnySearchDAO {
    public MariaDBJPAAnySearchDAO(RealmSearchDAO realmSearchDAO, DynRealmDAO dynRealmDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, PlainSchemaDAO schemaDAO, EntityFactory entityFactory, AnyUtilsFactory anyUtilsFactory, PlainAttrValidationManager validator, EntityManagerFactory entityManagerFactory, EntityManager entityManager) {
        super(realmSearchDAO, dynRealmDAO, userDAO, groupDAO, anyObjectDAO, schemaDAO, entityFactory, anyUtilsFactory, validator, entityManagerFactory, entityManager);
    }

    @Override
    protected void parseOrderByForPlainSchema(SearchSupport svs, OrderBySupport obs, OrderBySupport.Item item, Sort.Order clause, PlainSchema schema, String fieldName) {
        obs.nonMandatorySchemas = !"true".equals(schema.getMandatoryCondition());
        obs.views.add(svs.field());
        item.select = "( SELECT usa" + '.' + MariaDBJPAAnySearchDAO.key((AttrSchemaType)schema.getType()) + " FROM " + (schema.isUniqueConstraint() ? svs.asSearchViewSupport().uniqueAttr().name() : svs.asSearchViewSupport().attr().name()) + " usa WHERE usa.any_id = " + this.defaultSV(svs).alias() + ".any_id" + " AND usa.schema_id ='" + fieldName + "'" + " LIMIT 1" + ") AS " + fieldName;
        item.where = "plainSchema = '" + fieldName + "'";
        item.orderBy = fieldName + " " + clause.getDirection().name();
    }

    @Override
    protected Pair<Boolean, AnySearchNode> getQuery(AttrCond cond, boolean not, Pair<PlainSchema, PlainAttrValue> checked, List<Object> parameters, SearchSupport svs) {
        if (not) {
            if (cond.getType() == AttrCond.Type.ISNULL) {
                cond.setType(AttrCond.Type.ISNOTNULL);
            } else if (cond.getType() == AttrCond.Type.ISNOTNULL) {
                cond.setType(AttrCond.Type.ISNULL);
            }
        }
        switch (cond.getType()) {
            case ISNOTNULL: {
                return Pair.of((Object)true, (Object)new AnySearchNode.Leaf(svs.field(), "JSON_SEARCH(plainAttrs, 'one', '" + ((PlainSchema)checked.getLeft()).getKey() + "', NULL, '$[*].schema') IS NOT NULL"));
            }
            case ISNULL: {
                return Pair.of((Object)true, (Object)new AnySearchNode.Leaf(svs.field(), "JSON_SEARCH(plainAttrs, 'one', '" + ((PlainSchema)checked.getLeft()).getKey() + "', NULL, '$[*].schema') IS NULL"));
            }
        }
        if (!not && cond.getType() == AttrCond.Type.EQ) {
            PlainAttr container = new PlainAttr();
            container.setPlainSchema((PlainSchema)checked.getLeft());
            if (((PlainSchema)checked.getLeft()).isUniqueConstraint()) {
                container.setUniqueValue((PlainAttrValue)checked.getRight());
            } else {
                container.add((PlainAttrValue)checked.getRight());
            }
            return Pair.of((Object)true, (Object)new AnySearchNode.Leaf(svs.field(), "JSON_CONTAINS(plainAttrs, '" + POJOHelper.serialize(List.of(container)).replace("'", "''") + "')"));
        }
        Optional.ofNullable(((PlainAttrValue)checked.getRight()).getDateValue()).map(DateTimeFormatter.ISO_OFFSET_DATE_TIME::format).ifPresent(formatted -> {
            ((PlainAttrValue)checked.getRight()).setDateValue(null);
            ((PlainAttrValue)checked.getRight()).setStringValue(formatted);
        });
        return super.getQuery(cond, not, checked, parameters, svs);
    }
}

