/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.to.AuthProfileTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.AuthProfile;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;

public abstract class AbstractAuthProfileLogic
extends AbstractTransactionalLogic<AuthProfileTO> {
    protected final AuthProfileDAO authProfileDAO;
    protected final AuthProfileDataBinder binder;
    protected final EntityFactory entityFactory;

    public AbstractAuthProfileLogic(AuthProfileDataBinder binder, AuthProfileDAO authProfileDAO, EntityFactory entityFactory) {
        this.authProfileDAO = authProfileDAO;
        this.binder = binder;
        this.entityFactory = entityFactory;
    }

    protected AuthProfile authProfile(String owner) {
        AuthProfile profile = this.authProfileDAO.findByOwner(owner).orElse(null);
        if (profile == null) {
            profile = (AuthProfile)this.entityFactory.newEntity(AuthProfile.class);
            profile.setOwner(owner);
        }
        return profile;
    }

    protected AuthProfileTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof AuthProfileTO)) continue;
                AuthProfileTO authProfileTO = (AuthProfileTO)object;
                key = authProfileTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getAuthProfileTO((AuthProfile)this.authProfileDAO.findById(key).orElseThrow());
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

