/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.resources.oidcc4ui;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.common.lib.oidc.OIDCLoginResponse;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.rest.api.service.OIDCC4UIService;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CodeConsumerResource
extends AbstractResource {
    private static final long serialVersionUID = -692581789294259519L;
    protected static final Logger LOG = LoggerFactory.getLogger(CodeConsumerResource.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).serializationInclusion(JsonInclude.Include.NON_EMPTY)).build();

    protected abstract Class<? extends WebPage> getLoginPageClass();

    protected abstract Pair<Class<? extends WebPage>, PageParameters> getSelfRegInfo(UserTO var1) throws JsonProcessingException;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        String authorizationCode = attributes.getRequest().getQueryParameters().getParameterValue("code").toOptionalString();
        HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
        OIDCC4UIService service = (OIDCC4UIService)((BaseSession)BaseSession.class.cast(Session.get())).getAnonymousService(OIDCC4UIService.class);
        OIDCLoginResponse oidcResponse = service.login(request.getRequestURL().toString(), authorizationCode, Session.get().getAttribute("op").toString());
        if (oidcResponse.isSelfReg()) {
            UserTO newUser = new UserTO();
            newUser.setUsername(oidcResponse.getUsername());
            newUser.getPlainAttrs().addAll(oidcResponse.getAttrs());
            try {
                Pair<Class<? extends WebPage>, PageParameters> selfRegInfo = this.getSelfRegInfo(newUser);
                throw new RestartResponseException((Class)selfRegInfo.getLeft(), (PageParameters)selfRegInfo.getRight());
            }
            catch (JsonProcessingException e) {
                LOG.error("Could not serialize new user {}", (Object)newUser, (Object)e);
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        throw new RestartResponseException(this.getLoginPageClass(), new PageParameters().set("oidcc4ui.jwt", (Object)oidcResponse.getAccessToken()).set("oidcc4ui.sloSupported", (Object)oidcResponse.isLogoutSupported()));
    }
}

