/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.variablelistener.VariableListenerSession;
import org.flowable.common.engine.impl.variablelistener.VariableListenerSessionData;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluateVariableListenerEventDefinitionsOperation
extends AbstractOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvaluateVariableListenerEventDefinitionsOperation.class);
    protected String processDefinitionId;
    protected String processInstanceId;

    public EvaluateVariableListenerEventDefinitionsOperation(CommandContext commandContext, String processDefinitionId, String processInstanceId) {
        super(commandContext, null);
        this.processDefinitionId = processDefinitionId;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public void run() {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(this.processDefinitionId);
        if (!bpmnModel.hasVariableListeners()) {
            return;
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(this.commandContext);
        VariableListenerSession variableListenerSession = (VariableListenerSession)this.commandContext.getSession(VariableListenerSession.class);
        Map variableSessionData = variableListenerSession.getVariableData();
        if (variableSessionData == null || variableSessionData.isEmpty()) {
            return;
        }
        List eventSubscriptionEntities = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionEntityManager().findEventSubscriptionsByProcessInstanceAndType(this.processInstanceId, "variable");
        for (EventSubscriptionEntity eventSubscription : eventSubscriptionEntities) {
            if (eventSubscription.isDeleted() || !variableSessionData.containsKey(eventSubscription.getEventName()) || !bpmnModel.containsVariableListenerForVariableName(eventSubscription.getEventName())) continue;
            List variableListenerDataList = (List)variableSessionData.get(eventSubscription.getEventName());
            for (VariableListenerSessionData variableListenerData : variableListenerDataList) {
                if (!this.processInstanceId.equals(variableListenerData.getScopeId())) continue;
                String executionId = eventSubscription.getExecutionId();
                ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(this.commandContext).findById(executionId);
                String configuration = eventSubscription.getConfiguration();
                String changeTypeValue = "all";
                if (StringUtils.isNotEmpty((CharSequence)configuration)) {
                    try {
                        JsonNode configNode = processEngineConfiguration.getObjectMapper().readTree(configuration);
                        if (configNode.has("changeType") && !configNode.get("changeType").isNull()) {
                            changeTypeValue = configNode.get("changeType").asText();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error reading variable listener configuration value for {}", (Object)eventSubscription.getActivityId(), (Object)e);
                    }
                }
                if (!changeTypeValue.equals(variableListenerData.getChangeType()) && !"all".equals(changeTypeValue) && (!"update-create".equals(changeTypeValue) || !"create".equals(variableListenerData.getChangeType()) && !"update".equals(variableListenerData.getChangeType())) || variableListenerData.containsProcessedElementId(execution.getActivityId())) continue;
                CommandContextUtil.getAgenda().planTriggerExecutionOperation(execution);
                variableListenerData.addProcessedElementId(execution.getActivityId());
            }
        }
    }
}

