/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.CloseableDataSource;
import org.apereo.cas.configuration.support.JpaBeans;
import org.apereo.cas.jpa.JpaBeanFactory;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.metadata.SAML2MetadataGenerator;
import org.pac4j.saml.metadata.jdbc.SAML2JdbcMetadataGenerator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.jdbc.core.JdbcTemplate;

@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.DelegatedAuthentication}, module="saml-jdbc", enabledByDefault=false)
@Configuration(value="DelegatedAuthenticationSaml2JdbcConfiguration", proxyBeanMethods=false)
@ConditionalOnClass(value={JpaBeanFactory.class})
class DelegatedAuthenticationSaml2JdbcConfiguration {
    DelegatedAuthenticationSaml2JdbcConfiguration() {
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"delegatedSaml2ClientJdbcMetadataCustomizer"})
    public DelegatedClientFactoryCustomizer delegatedSaml2ClientJdbcMetadataCustomizer(CasConfigurationProperties casProperties) {
        return client -> {
            if (client instanceof SAML2Client) {
                SAML2Client saml2Client = (SAML2Client)client;
                SAML2Configuration configuration = saml2Client.getConfiguration();
                casProperties.getAuthn().getPac4j().getSaml().stream().map(saml -> saml.getMetadata().getServiceProvider().getJdbc()).filter(saml -> StringUtils.isNotBlank((CharSequence)saml.getUrl()) && StringUtils.isNotBlank((CharSequence)saml.getTableName())).forEach(saml -> {
                    CloseableDataSource datasource = JpaBeans.newDataSource((AbstractJpaProperties)saml);
                    SAML2JdbcMetadataGenerator metadataGenerator = new SAML2JdbcMetadataGenerator(new JdbcTemplate((DataSource)datasource), configuration.getServiceProviderEntityId());
                    metadataGenerator.setTableName(saml.getTableName());
                    configuration.setServiceProviderMetadataResource(ResourceUtils.NULL_RESOURCE);
                    configuration.setMetadataGenerator((SAML2MetadataGenerator)metadataGenerator);
                });
            }
        };
    }
}

