/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.remote;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.RemoteFrameworkConnectionInfo;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.ConnectorIOException;
import org.identityconnectors.framework.common.serializer.BinaryObjectDeserializer;
import org.identityconnectors.framework.common.serializer.BinaryObjectSerializer;
import org.identityconnectors.framework.common.serializer.ObjectSerializerFactory;

public class RemoteFrameworkConnection
implements Closeable {
    private static final Log LOG = Log.getLog(RemoteFrameworkConnection.class);
    private Socket socket;
    private BinaryObjectSerializer encoder;
    private BinaryObjectDeserializer decoder;

    public RemoteFrameworkConnection(RemoteFrameworkConnectionInfo info) {
        try {
            this.init(info);
        }
        catch (SocketException e) {
            throw new ConnectorIOException("Failed to init remote connection to " + (null != info ? info.toString() : "null"), (Throwable)e);
        }
        catch (Exception e) {
            throw new ConnectorException("Failed to init remote connection to " + (null != info ? info.toString() : "null"), (Throwable)e);
        }
    }

    public RemoteFrameworkConnection(Socket socket) {
        try {
            LOG.ok("About to initialize socket for remote framework connection", new Object[0]);
            this.init(socket);
        }
        catch (SocketException e) {
            throw new ConnectorIOException("Failed to init remote connection to " + (null != socket ? socket.toString() : "null"), (Throwable)e);
        }
        catch (Exception e) {
            throw new ConnectorException("Failed to init remote connection to " + (null != socket ? socket.toString() : "null"), (Throwable)e);
        }
    }

    private void init(RemoteFrameworkConnectionInfo connectionInfo) throws Exception {
        Socket socket = new Socket();
        socket.setSoTimeout(connectionInfo.getTimeout());
        socket.connect(new InetSocketAddress(connectionInfo.getHost(), connectionInfo.getPort()), connectionInfo.getTimeout());
        try {
            if (connectionInfo.getUseSSL()) {
                SSLSocketFactory factory;
                List trustManagers = connectionInfo.getTrustManagers();
                TrustManager[] trustManagerArr = null;
                if (null != trustManagers && trustManagers.size() > 0) {
                    trustManagerArr = trustManagers.toArray(new TrustManager[trustManagers.size()]);
                }
                if (trustManagers == null) {
                    factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                } else {
                    SSLContext context = SSLContext.getInstance("TLS");
                    context.init(null, trustManagerArr, null);
                    factory = context.getSocketFactory();
                }
                socket = factory.createSocket(socket, connectionInfo.getHost(), connectionInfo.getPort(), true);
                ((SSLSocket)socket).startHandshake();
            }
        }
        catch (Exception e) {
            try {
                LOG.warn("Closing socket for remote framework connection because of error {}", new Object[]{e.getLocalizedMessage()});
                socket.close();
            }
            catch (Exception e2) {
                LOG.warn("Error while closing socket for remote framework connection {}", new Object[]{e.getLocalizedMessage()});
            }
            throw e;
        }
        this.init(socket);
    }

    private void init(Socket socket) throws Exception {
        this.socket = socket;
        InputStream inputStream = this.socket.getInputStream();
        OutputStream outputStream = this.socket.getOutputStream();
        ObjectSerializerFactory factory = ObjectSerializerFactory.getInstance();
        this.encoder = factory.newBinarySerializer(outputStream);
        this.decoder = factory.newBinaryDeserializer(inputStream);
    }

    @Override
    public void close() {
        this.flush();
        try {
            if (this.socket instanceof SSLSocket) {
                this.socket.close();
            } else {
                this.socket.shutdownOutput();
                this.socket.shutdownInput();
                this.socket.close();
                LOG.info("Remote framework connection has been closed", new Object[0]);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e, "Failed to close connection.", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public void flush() {
        this.encoder.flush();
    }

    public void writeObject(Object object) {
        this.encoder.writeObject(object);
    }

    public Object readObject() {
        this.flush();
        return this.decoder.readObject();
    }
}

