/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.expression.SpelPropertyAccessorRegistrar;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SpelPropertyAccessorsParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        ManagedMap propertyAccessors = new ManagedMap();
        ManagedMap indexAccessors = new ManagedMap();
        SpelPropertyAccessorsParser.parseTargetedAccessors(element, parserContext, (Map<String, Object>)propertyAccessors);
        Element indexAccessorsElement = DomUtils.getChildElementByTagName((Element)element, (String)"index-accessors");
        if (indexAccessorsElement != null) {
            SpelPropertyAccessorsParser.parseTargetedAccessors(indexAccessorsElement, parserContext, (Map<String, Object>)indexAccessors);
        }
        BeanDefinitionBuilder registrarBuilder = BeanDefinitionBuilder.genericBeanDefinition(SpelPropertyAccessorRegistrar.class).setRole(2);
        if (!CollectionUtils.isEmpty((Map)propertyAccessors)) {
            registrarBuilder.addConstructorArgValue((Object)propertyAccessors);
        }
        if (!CollectionUtils.isEmpty((Map)indexAccessors)) {
            registrarBuilder.addPropertyValue("indexAccessors", (Object)indexAccessors);
        }
        parserContext.getRegistry().registerBeanDefinition("spelPropertyAccessorRegistrar", (BeanDefinition)registrarBuilder.getBeanDefinition());
        return null;
    }

    private static void parseTargetedAccessors(Element accessorsElement, ParserContext parserContext, Map<String, Object> accessorsMap) {
        BeanDefinitionParserDelegate delegate = parserContext.getDelegate();
        List accessorElements = DomUtils.getChildElementsByTagName((Element)accessorsElement, (String[])new String[]{"bean", "ref"});
        for (Element accessorElement : accessorElements) {
            BeanDefinitionHolder accessor;
            String accessorName;
            if (delegate.nodeNameEquals((Node)accessorElement, "bean")) {
                accessorName = accessorElement.getAttribute("id");
                if (!StringUtils.hasText((String)accessorName)) {
                    parserContext.getReaderContext().error("The '<bean>' 'id' attribute is required within 'spel-property-accessors'.", (Object)accessorElement);
                    return;
                }
                accessor = delegate.parseBeanDefinitionElement(accessorElement);
            } else {
                BeanReference propertyAccessorRef = (BeanReference)delegate.parsePropertySubElement(accessorElement, null);
                accessorName = propertyAccessorRef.getBeanName();
                accessor = propertyAccessorRef;
            }
            accessorsMap.put(accessorName, accessor);
        }
    }
}

