/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.client.authentication;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.apereo.cas.client.authentication.AuthenticationRedirectStrategy;
import org.apereo.cas.client.util.CommonUtils;

public final class FacesCompatibleAuthenticationRedirectStrategy
implements AuthenticationRedirectStrategy {
    private static final String FACES_PARTIAL_AJAX_PARAMETER = "javax.faces.partial.ajax";

    @Override
    public void redirect(HttpServletRequest request, HttpServletResponse response, String potentialRedirectUrl) throws IOException {
        if (CommonUtils.isNotBlank(request.getParameter(FACES_PARTIAL_AJAX_PARAMETER))) {
            response.setContentType("text/xml");
            response.setStatus(200);
            PrintWriter writer = response.getWriter();
            writer.write("<?xml version='1.0' encoding='UTF-8'?>");
            writer.write(String.format("<partial-response><redirect url=\"%s\"></redirect></partial-response>", potentialRedirectUrl));
        } else {
            response.sendRedirect(potentialRedirectUrl);
        }
    }
}

