/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Collection;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.MultifactorAuthenticationPrincipalResolver;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Principal;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

public interface MultifactorAuthenticationHandler
extends AuthenticationHandler {
    public ObjectProvider<? extends MultifactorAuthenticationProvider> getMultifactorAuthenticationProvider();

    default public Principal resolvePrincipal(ApplicationContext applicationContext, Principal principal) {
        Collection resolvers = applicationContext.getBeansOfType(MultifactorAuthenticationPrincipalResolver.class).values();
        return resolvers.stream().sorted(AnnotationAwareOrderComparator.INSTANCE).filter(resolver -> resolver.supports(principal)).findFirst().map(r -> r.resolve(principal)).orElseThrow(() -> new IllegalStateException("Unable to resolve principal for multifactor authentication"));
    }
}

