/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldup;

import java.util.Optional;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import net.tirasa.connid.bundles.ldup.LdUpUtils;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidCredentialException;
import org.identityconnectors.framework.common.exceptions.PasswordExpiredException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;
import org.identityconnectors.framework.spi.operations.ResolveUsernameOp;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.Credential;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.SingleConnectionFactory;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.SearchDnResolver;
import org.ldaptive.auth.SimpleBindAuthenticationHandler;
import org.ldaptive.auth.User;
import org.ldaptive.control.PasswordExpiredControl;
import org.ldaptive.control.PasswordPolicyControl;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.handler.ResultPredicate;

public class LdUpAuthenticateOp
implements AuthenticateOp,
ResolveUsernameOp {
    protected final LdUpUtils ldUpUtils;

    public LdUpAuthenticateOp(LdUpUtils ldUpUtils) {
        this.ldUpUtils = ldUpUtils;
    }

    protected SearchDnResolver searchDnResolver(ConnectionFactory factory) {
        return SearchDnResolver.builder().factory(factory).dn(this.ldUpUtils.getConfiguration().getBaseDn()).subtreeSearch(true).filter("(" + this.ldUpUtils.getConfiguration().getUidAttribute() + "={user})").build();
    }

    public Uid authenticate(ObjectClass objectClass, String username, GuardedString password, OperationOptions options) {
        SingleConnectionFactory scf = new SingleConnectionFactory(this.ldUpUtils.getConnectionConfig());
        try {
            scf.initialize();
            Authenticator authenticator = new Authenticator((DnResolver)this.searchDnResolver((ConnectionFactory)scf), (AuthenticationHandler)new SimpleBindAuthenticationHandler((ConnectionFactory)scf));
            AuthenticationResponse response = authenticator.authenticate(new AuthenticationRequest(username, new Credential(SecurityUtil.decrypt((GuardedString)password)), new String[]{this.ldUpUtils.getConfiguration().getUidAttribute()}));
            if (response.isSuccess()) {
                LdapEntry entry = response.getLdapEntry();
                return new Uid(entry.getAttribute(this.ldUpUtils.getConfiguration().getUidAttribute()).getStringValue());
            }
            for (ResponseControl ctl : response.getControls()) {
                if (ctl instanceof PasswordExpiredControl) {
                    throw new PasswordExpiredException();
                }
                if (!(ctl instanceof PasswordPolicyControl)) continue;
                ((PasswordPolicyControl)ctl).getError().throwSecurityException();
            }
            throw new InvalidCredentialException("Authentication failed: " + response.getDiagnosticMessage());
        }
        catch (LoginException e) {
            if (e instanceof CredentialExpiredException) {
                throw new PasswordExpiredException((Throwable)e);
            }
            throw new InvalidCredentialException((Throwable)e);
        }
        catch (LdapException e) {
            throw new ConnectorException("While authenticating " + username, (Throwable)e);
        }
    }

    public Uid resolveUsername(ObjectClass objectClass, String username, OperationOptions options) {
        try {
            return Optional.ofNullable(this.searchDnResolver((ConnectionFactory)this.ldUpUtils.getConnectionFactory()).resolve(new User(username))).map(dn -> {
                try {
                    SearchResponse response = ((SearchOperation)((SearchOperation.Builder)((SearchOperation.Builder)SearchOperation.builder().factory((ConnectionFactory)this.ldUpUtils.getConnectionFactory())).throwIf(ResultPredicate.NOT_SUCCESS)).build()).execute(SearchRequest.objectScopeSearchRequest((String)dn, (String[])new String[]{this.ldUpUtils.getConfiguration().getUidAttribute()}));
                    return new Uid(response.getEntry().getAttribute(this.ldUpUtils.getConfiguration().getUidAttribute()).getStringValue());
                }
                catch (LdapException e) {
                    throw new ConnectorException("While reading " + this.ldUpUtils.getConfiguration().getUidAttribute() + " from " + dn, (Throwable)e);
                }
            }).orElseThrow(() -> new InvalidCredentialException("Cannot resolve username " + username));
        }
        catch (LdapException e) {
            throw new ConnectorException("While resolving username " + username, (Throwable)e);
        }
    }
}

