/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication.principal;

import com.google.common.base.Predicates;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class X509UPNExtractorUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(X509UPNExtractorUtils.class);
    private static final String UPN_OBJECTID = "1.3.6.1.4.1.311.20.2.3";
    private static final int SAN_TYPE_OTHER = 0;

    private static String getUPNStringFromSequence(ASN1Sequence seq) {
        ASN1ObjectIdentifier id = Optional.ofNullable(seq).map(asn1Encodables -> ASN1ObjectIdentifier.getInstance((Object)asn1Encodables.getObjectAt(0))).orElse(null);
        if (id != null && UPN_OBJECTID.equals(id.getId())) {
            ASN1TaggedObject obj = (ASN1TaggedObject)seq.getObjectAt(1);
            ASN1Object primitiveObj = obj.getBaseObject();
            Function func = FunctionUtils.doIf((Predicate)Predicates.instanceOf(ASN1TaggedObject.class), () -> ASN1TaggedObject.getInstance((Object)primitiveObj).getBaseObject(), () -> primitiveObj);
            ASN1Object prim = (ASN1Object)func.apply(primitiveObj);
            if (prim instanceof ASN1OctetString) {
                ASN1OctetString instance = (ASN1OctetString)prim;
                return new String(instance.getOctets(), StandardCharsets.UTF_8);
            }
            if (prim instanceof ASN1String) {
                ASN1String instance = (ASN1String)prim;
                return instance.getString();
            }
        }
        return null;
    }

    private static ASN1Sequence getOtherNameTypeSAN(List<?> sanItem) {
        if (sanItem.size() < 2) {
            LOGGER.error("Subject Alternative Name List does not contain at least two required elements");
            return null;
        }
        Integer itemType = (Integer)sanItem.getFirst();
        if (itemType == 0) {
            byte[] altName = (byte[])sanItem.get(1);
            return X509UPNExtractorUtils.getAltnameSequence(altName);
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ASN1Sequence getAltnameSequence(byte[] sanValue) {
        try (ByteArrayInputStream bInput = new ByteArrayInputStream(sanValue);){
            ASN1Sequence aSN1Sequence;
            try (ASN1InputStream input = new ASN1InputStream((InputStream)bInput);){
                aSN1Sequence = ASN1Sequence.getInstance((Object)input.readObject());
            }
            return aSN1Sequence;
        }
        catch (IOException e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }

    public static Optional<String> extractUPNString(Collection<List<?>> subjectAltNames) {
        for (List<?> sanItem : subjectAltNames) {
            ASN1Sequence seq;
            String upnString;
            if (LOGGER.isTraceEnabled()) {
                if (sanItem.size() == 2) {
                    Object object;
                    Object name = sanItem.get(1);
                    if (name instanceof String) {
                        object = name;
                    } else if (name instanceof byte[]) {
                        byte[] array = (byte[])name;
                        object = X509UPNExtractorUtils.getAltnameSequence(array);
                    } else {
                        object = name;
                    }
                    Object value = object;
                    LOGGER.trace("Found subject alt name of type [{}] with value [{}]", sanItem.getFirst(), value);
                } else {
                    LOGGER.trace("SAN item of unexpected size found: [{}]", sanItem);
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(upnString = X509UPNExtractorUtils.getUPNStringFromSequence(seq = X509UPNExtractorUtils.getOtherNameTypeSAN(sanItem))))) continue;
            LOGGER.debug("Found user principal name in certificate: [{}]", (Object)upnString);
            return Optional.of(upnString);
        }
        return Optional.empty();
    }

    @Generated
    private X509UPNExtractorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

