/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.x509.authentication;

import java.security.GeneralSecurityException;
import java.time.ZonedDateTime;
import lombok.Generated;

public class ExpiredCRLException
extends GeneralSecurityException {
    private static final long serialVersionUID = 5157864033250359972L;
    private final String id;
    private final ZonedDateTime expirationDate;
    private final int leniency;

    public ExpiredCRLException(String identifier, ZonedDateTime expirationDate) {
        this(identifier, expirationDate, 0);
    }

    @Override
    public String getMessage() {
        if (this.leniency > 0) {
            return String.format("CRL %s expired on %s and is beyond the leniency period of %s seconds.", this.id, this.expirationDate, this.leniency);
        }
        return String.format("CRL %s expired on %s", this.id, this.expirationDate);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public ZonedDateTime getExpirationDate() {
        return this.expirationDate;
    }

    @Generated
    public int getLeniency() {
        return this.leniency;
    }

    @Generated
    public ExpiredCRLException(String id, ZonedDateTime expirationDate, int leniency) {
        this.id = id;
        this.expirationDate = expirationDate;
        this.leniency = leniency;
    }
}

