/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.transport.netty;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.transport.Transport;
import org.ldaptive.transport.netty.NettyConnection;
import org.ldaptive.transport.netty.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StatefulNettyTransport
implements Transport {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<? extends Channel> channelType;
    private final EventLoopGroup ioWorkerGroup;
    private final EventLoopGroup messageWorkerGroup;
    private final boolean shutdownOnClose;

    StatefulNettyTransport() {
        this(0);
    }

    StatefulNettyTransport(int ioThreads) {
        this(null, ioThreads, -1, true);
    }

    StatefulNettyTransport(int ioThreads, int messageThreads) {
        this(null, ioThreads, messageThreads, true);
    }

    StatefulNettyTransport(String name, int ioThreads, int messageThreads, boolean shutdown) {
        this(NettyUtils.getDefaultSocketChannelType(), NettyUtils.createDefaultEventLoopGroup((name == null ? "stateful-netty-transport" : name) + "-io", ioThreads), messageThreads == -1 ? null : NettyUtils.createDefaultEventLoopGroup((name == null ? "stateful-netty-transport" : name) + "-messages", messageThreads), shutdown);
    }

    StatefulNettyTransport(Class<? extends Channel> type, EventLoopGroup ioGroup, EventLoopGroup messageGroup, boolean shutdown) {
        this.channelType = type;
        this.ioWorkerGroup = ioGroup;
        this.messageWorkerGroup = messageGroup;
        this.shutdownOnClose = shutdown;
    }

    @Override
    public Connection create(ConnectionConfig cc) {
        return new NettyConnection(cc, this.channelType, this.ioWorkerGroup, this.messageWorkerGroup, false);
    }

    @Override
    public void close() {
        if (this.shutdownOnClose) {
            this.shutdown();
        }
    }

    @Override
    public void shutdown() {
        if (!this.ioWorkerGroup.isShutdown()) {
            NettyUtils.shutdownGracefully(this.ioWorkerGroup);
            this.logger.trace("shutdown worker group {}", (Object)this.ioWorkerGroup);
        }
        if (this.messageWorkerGroup != null && !this.messageWorkerGroup.isShutdown()) {
            NettyUtils.shutdownGracefully(this.messageWorkerGroup);
            this.logger.trace("shutdown worker group {}", (Object)this.messageWorkerGroup);
        }
    }

    boolean getShutdownOnClose() {
        return this.shutdownOnClose;
    }

    public String toString() {
        return "[" + this.getClass().getName() + "@" + this.hashCode() + "::channelType=" + this.channelType + ", ioWorkerGroup=" + this.ioWorkerGroup + ", messageWorkerGroup=" + this.messageWorkerGroup + ", shutdownOnClose=" + this.shutdownOnClose + "]";
    }
}

